<?php

/*
 * Copyright (C) xgcms.com
 */

class xgcms_html extends base_model {
	
	function __construct(&$conf) {
		parent::__construct($conf);
	}
    public function build_list_html($html,$cate,$page=1){
		$url=$cate['type']==1?$cate['url']:$cate['url_list'];
        $path=str_replace(array('[catid]','[catdir]','[page]',$this->conf['cms_url'],'?'),array($cate['catid'],$cate['catdir'],$page,'',''),$url);
		$rs=$this->check_dir($path);
		if(!is_array($rs)){
			echo $rs.'<br>';
		}else{
			$filename= $rs['filename'];
		    $dir=ROOT_PATH.$rs['dir'];
			if(!file_exists($dir)) {
				mkdir($dir, 0777, true);
			}
			if($page==1&&$cate['type']==0){
				 $index= 'index'.strrchr($filename, '.');
				 file_put_contents($dir.$index,$html);
			}
			file_put_contents($dir.$filename,$html);
		}
    }
	public function build_show_html($html,$cate,$id,$time,$page=1){
		$path=$this->xgcms_content->get_url($id,$cate,$time,$page);
		//$path=substr(str_replace('//','',$path),stripos($path,'/'));
		$path=str_replace($this->conf['cms_url'],'',$path);
		$rs=$this->check_dir($path);
		if(!is_array($rs)){
			echo $rs.'<br>';
		}else{
			$filename= $rs['filename'];
		    $dir=ROOT_PATH.$rs['dir'];
			if(!file_exists($dir)) {
				mkdir($dir, 0777, true);
			}
			file_put_contents($dir.$filename,$html);
		}
    }
	public function build_show_html_by_url($id,$cate,$time,$pagenum=1){
		$url=$this->conf['cms_url'].'?show-index-catid-'.$cate['catid'].'-id-'.$id.'.'.'htm';
		$path=$this->xgcms_content->get_url($id,$cate,$time);
		$html=misc::fetch_url($url);
		$path=str_replace($this->conf['cms_url'],'',$path);
		
		$rs=$this->check_dir($path);
		if(!is_array($rs)){
			echo $rs.'<br>';
		}else{
			$filename= $rs['filename'];
		    $dir=ROOT_PATH.$rs['dir'];
			if(!file_exists($dir)) {
				mkdir($dir, 0777, true);
			}
			file_put_contents($dir.$filename,$html);
			if($pagenum>1){
				for($i=2;$i<=$pagenum;$i++){
					$url=$this->conf['cms_url'].'?show-index-catid-'.$cate['catid'].'-id-'.$id.'-page-'.$i.'.'.'htm';
					$html=misc::fetch_url($url);
					$path=$this->xgcms_content->get_url($id,$cate,$time,$i);
					$filename= strrchr($path, '/');
					file_put_contents($dir.$filename,$html);
				}
			}
			
		}
    }
	public function delete_show_html($id,$cate,$time,$pagenum=1){
		$path=$this->xgcms_content->get_url($id,$cate,$time);
		$path=str_replace($this->conf['cms_url'],'',$path);
		$rs=$this->check_dir($path);
		if(!is_array($rs)){
			echo $rs;
		}else{
			$file=ROOT_PATH.$rs['dir'].$rs['filename'];
			is_file($file) && unlink($file);
			if($pagenum>1){
				for($i=2;$i<=$pagenum;$i++){
					$path=$this->xgcms_content->get_url($id,$cate,$time,$i);
					$file=ROOT_PATH.str_replace($this->conf['cms_url'],'',$path);
					is_file($file) && unlink($file);
				}
			}
		}
	}
	// 检查是否为合法的 dir
	public function check_dir($path) {
		$file= str_replace('/','',strrchr($path, '/'));
		empty($file) && $file='index.html';
		
		$dir=substr($path, 0,strripos($path,'/')).'/';
		$arr=explode('/',$dir);
		$s='';
		foreach($arr as $d){
			if(empty($d)) continue;
			$d1=misc::safe_str($d,'-_');
			if($d1!=$d) return '路径包含特殊字符';
			$s.=$d.'/';
		}
		if($s=='') return '没有设置生成目录';
		//系统目录
		$sysdirs=array('bbs','caiji','conf','plugin','runtime','service','static','upload','xcenter','xgcms');
		if(in_array(substr($s,0,stripos($s,'/')),$sysdirs)) return '不得生成到系统目录';
		//!is_dir($s) && mkdir($s);
		$pos=stripos($file,'.');
		$name=substr($file,0,$pos);
		$name=misc::safe_str($name);
		if(empty($name)) return '文件名为空';
		$ext=substr($file,$pos);
		if(!in_array($ext,array('.htm','.html'))) return '只允许htm/html后辍';
		return array('dir'=>$s,'filename'=>$file);
	}
	// hook xgcms_html_model_end.php
}

?>