<?php

/*
 * Copyright (C) xgcms.com
 */

class xgcms_model_field extends base_model {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->table = 'xgcms_model_field';
		$this->primarykey = array('fieldid');
		$this->maxcol = 'fieldid';
	}
	
	
	public function get_one($map) {

		$rs = $this->index_fetch($map,array('fieldid'=>1),0,1);
		return $rs=$rs?array_pop($rs):false;
	}
	public function get_list($map=array(),$start=0,$limit=100,$order=array('listorder'=>1)){
		$list = $this->index_fetch($map,$order,$start,$limit);
        misc::arrlist_change_key($list, 'field');
		return $list;
	
	}
    public function get_field_by_modelid($modelid){
        $list=$this->get_list(array('modelid'=>$modelid));
        //misc::arrlist_change_key($list, 'field');
        return $list;  
        
    }
	// 用来显示给用户
	public function format(&$v) {
	
	}
    
    public function field_inc(){
        $arr=array();
        $arr['fields'] = array('text'=>'单行文本',
				'textarea'=>'多行文本',
				'editor'=>'编辑器',
				'catid'=>'栏目',
				'title'=>'标题',
				'box'=>'选项',
				'image'=>'图片',
				//'images'=>'多图片',
				'number'=>'数字',
				//'datetime'=>'日期和时间',
				//'posid'=>'推荐位',
				'keyword'=>'关键词',
				'author'=>'作者',
				'copyfrom'=>'来源',
				'groupid'=>'会员组',
				'islink'=>'转向链接',
				'template'=>'模板',
				'pages'=>'分页选择',
				'typeid'=>'类别',
				'readpoint'=>'积分、点数',
				//'linkage'=>'联动菜单',
				//'downfile'=>'镜像下载',
				//'downfiles'=>'多文件上传',
				//'map'=>'地图字段',
				//'omnipotent'=>'万能字段',
				//'video'=>'视频库',
				);
//不允许删除的字段，这些字段讲不会在字段添加处显示
$arr['not_allow_fields'] = array('catid','typeid','title','keyword','pagenum','posids','template','username','linkage','readpoint','map','omnipotent','video');
//允许添加但必须唯一的字段
$arr['unique_fields'] = array('pages','readpoint','author','copyfrom','islink');
//禁止被禁用的字段列表
$arr['forbid_fields'] = array('catid','title','updatetime','inputtime','url','listorder','status','template','username','pagenum');
//禁止被删除的字段列表
$arr['forbid_delete'] = array('catid','typeid','title','thumb','keywords','updatetime','inputtime','posids','pagenum','url','listorder','status','template','username');
//可以追加 JS和CSS 的字段
        
        return $arr;
    }
    // hook xgcms_model_field_model_end.php
}
?>