<?php

/*
 * Copyright (C) xgcms.com
 */

class xgcms_pos_data extends base_model {
	private $num=0;
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->table = 'xgcms_pos_data';
		$this->primarykey = array('pid');
		$this->maxcol='pid';
	}
	
	public function get_one($map) {
		$rs = $this->index_fetch($map,array('posid'=>1),0,1);
		return $rs=$rs?array_pop($rs):false;
	}
	public function get_list($map=array(),$start=0,$limit=1000,$order=array('listorder'=>-1,'id'=>-1)){
		$list = $this->index_fetch($map,$order,$start,$limit);
		$newlist=array();
		foreach($list as $v){
			$data=core::json_decode($v['data']);
			
			if($data){
				unset($data['listorder']);
				$v=array_merge($v,$data);
			}
            $newlist[$v['pid']]=$v;
		}
		return $newlist;
	}
	public function format(&$v){
	
	}
	public function xcreate($data,$posid,$modelid,$num=20){
		empty($this->num) && $this->num=$this->index_count(array('posid'=>$posid));
		$arr=array(
		   'id'=>$data['id'],
		   'catid'=>$data['catid'],
		   'posid'=>$posid,
		   'modelid'=>$modelid,
		   'thumb'=>$data['thumb']?1:0,
		   'data'=>core::json_encode($data),
		);
		$rs=$this->get_one(array('posid'=>$posid,'id'=>$data['id']));
		// hook xgcms_pos_data_model_xcreate_before.php
		if($rs){
			$rs=array_merge($rs,$arr);
			$this->update($rs);
		}else{
		   $this->create($arr);	
		}
		$this->num++;
		if($this->num>$num){
			$list=$this->index_fetch(array('posid'=>$posid),array('listorder'=>-1,'id'=>-1),$num,1000);
			foreach($list as $c){
				$this->delete($c['pid']);
			}
		}
		// hook xgcms_pos_data_model_xcreate_end.php
	}
	public function delete_by_posid($posid){
		$list=$this->get_list(array('posid'=>$posid));
		foreach($list as $v){
			$this->delete($v['pid']);
		}
		// hook xgcms_pos_data_model_delete_by_posid_end.php
	}
	public function delete_by_id($id){
		$list=$this->index_fetch(array('id'=>$id),array('id'=>-1),0,1000);;
		foreach($list as $v){
			$this->delete($v['pid']);
		}
		// hook xgcms_pos_data_model_delete_by_id_end.php
	}
	public function get_posid_by_id($id){
		$list=$this->get_list(array('id'=>$id));
		$arr=misc::arrlist_values($list,'posid');
		array_unique($arr);
		// hook xgcms_pos_data_model_get_posid_by_id_end.php
		return $arr;
	}
	// hook xgcms_pos_data_model_end.php
}

?>