var GLOBAL = {};
GLOBAL.namespace = function(str){
	var arr = str.split("."),o = GLOBAL;
	for (i=(arr[0] == "GLOBAL") ? 1 : 0; i<arr.length; i++) {
		o[arr[i]]=o[arr[i]] || {};
		o=o[arr[i]];
	}
}
GLOBAL.namespace("Dom");
GLOBAL.Dom.getElementsByClassName = function(str,root,tag){
	if(root){
		root = typeof root == "string" ? document.getElementById(root) : root;
	} else {
		root = document.body;
	}
	tag = tag || "*";
	var els = root.getElementsByTagName(tag),arr = [];	
	for(var i=0,n=els.length;i<n;i++){
		for(var j=0,k=els[i].className.split(" "),l=k.length;j<l;j++){
			if(k[j] == str){
				arr.push(els[i]);
				break;
			}
		}
	}
	return arr;
}

GLOBAL.Dom.addClass = function(node,str){
	if(!new RegExp("(^|\\s+)"+str).test(node.className)){
		node.className = node.className + " " + str;
	}
}
GLOBAL.Dom.removeClass = function(node,str){
	node.className = node.className.replace(new RegExp("(^|\\s+)"+str),"");
}
GLOBAL.namespace("Event");
GLOBAL.Event.on = function(node,eventType,handler,scope){
	node = typeof node == "string" ? document.getElementById(node) : node;
	scope = scope || node;
	if(document.all){
		node.attachEvent("on"+eventType,function(){handler.apply(scope,arguments)});
	} else {
		node.addEventListener(eventType,function(){handler.apply(scope,arguments)},false);
	}
}


function Tab(config){
this._root = config.root;
this._currentClass = config.currentClass;
var trigger = config.trigger || "click";	
this._handler = config.handler;
this._autoPlay = config.autoPlay;
this._moveStop = config.moveStop==null? true:config.moveStop;
this._playTime = config.playTime || 3000;
this._tabMenus = GLOBAL.Dom.getElementsByClassName("J_tab-menu",this._root);
this._tabContents = GLOBAL.Dom.getElementsByClassName("J_tab-content",this._root);
var moreElements = GLOBAL.Dom.getElementsByClassName("tab-menu-m",this._root);
if(moreElements[0]){
  this._divMore = moreElements[0];
  this._moreUrl = this._divMore.getElementsByTagName("a")[0];
}
this._tabMoreLinks = config.moreLinks;
this.currentIndex = 0;
var This = this;
if(this._autoPlay){
	this.flashIntv = setInterval(function(){This._autoHandler()},this._playTime);
}
for(var i=0;i<this._tabMenus.length;i++){
	this._tabMenus[i]._Tab = This;
	this._tabMenus[i]._index = i;
	GLOBAL.Event.on(this._tabMenus[i],trigger,function(){
		this._Tab.currentIndex = this._index;
		This.showItem(this._index);
	});

	if( this._moveStop ){
		this._tabContents[i]._Tab = This;
		GLOBAL.Event.on(this._tabMenus[i],"mousemove",function(){
			if( this._Tab._autoPlay ){
				this._Tab._autoPlay = false;
			}
		});
		GLOBAL.Event.on(this._tabMenus[i],"mouseout",function(){
			this._Tab._autoPlay = true;
		});
		GLOBAL.Event.on(this._tabContents[i],"mousemove",function(){
			if( this._Tab._autoPlay ){
				this._Tab._autoPlay = false;
			}
		});
		GLOBAL.Event.on(this._tabContents[i],"mouseout",function(){
			this._Tab._autoPlay = true;
		});
	}

}

}
Tab.prototype = {
showItem : function(n){
	for(var i=0;i<this._tabContents.length;i++){
		this._tabContents[i].style.display = "none";
	}
	this._tabContents[n].style.display = "block";
	if(this._moreUrl&&this._tabMoreLinks&&this._tabMoreLinks[n]){
		this._moreUrl.href = this._tabMoreLinks[n];
	}
	if(this._currentClass){
		var currentMenu = GLOBAL.Dom.getElementsByClassName(this._currentClass,this._root)[0];
		if(currentMenu){
			GLOBAL.Dom.removeClass(currentMenu,this._currentClass);
		}
		GLOBAL.Dom.addClass(this._tabMenus[n],this._currentClass);
	}
	if(this._handler){
		this._handler(n);
	}
},
_autoHandler : function(){
	if( this._autoPlay ){
		this.currentIndex++;
		if(this.currentIndex >= this._tabMenus.length){
			this.currentIndex = 0;
		}
		this.showItem(this.currentIndex);
	}
}		
}

function selecttab(obj){
	var n = 0;
	var tabs = obj.parentNode.parentNode.getElementsByTagName("li"); 
	for(i=0; i<tabs.length; i++){
		tmp = tabs[i].getElementsByTagName("a")[0];
		if(tmp == obj){
			tmp.className="selected";
			n=i;
		}else{
			tmp.className="";
		}
 	}
	contents = obj.parentNode.parentNode.parentNode.getElementsByTagName("div");
	for(i=0; i<contents.length; i++){
		contents[i].style.display = i==n ? "block" : "none";
 	}
}