<?php
/*********************/
/*                   */
/*  Version : 5.1.0  */
/*  Author  : RM     */
/*  Comment : 071223 */
/*                   */
/*********************/

function utf82gb( $gb )
{
    if ( !trim( $gb ) )
    {
        return $gb;
    }
    include( "GB2UTF8.CodeTable.inc2.php" );
    $out = "";
    $len = strlen( $gb );
    $i = 0;
    while ( $i < $len )
    {
        $c = ord( substr( $gb, $i++, 1 ) );
        switch ( $c >> 4 )
        {
        case 0 :
        case 1 :
        case 2 :
        case 3 :
        case 4 :
        case 5 :
        case 6 :
        case 7 :
            $out .= substr( $gb, $i - 1, 1 );
            break;
        case 12 :
        case 13 :
            $char2 = ord( substr( $gb, $i++, 1 ) );
            $char3 = $codetable[( $c & 31 ) << 6 | $char2 & 63];
            $out .= _hex2bin( dechex( $char3 + 32896 ) );
            break;
        case 14 :
            $char2 = ord( substr( $gb, $i++, 1 ) );
            $char3 = ord( substr( $gb, $i++, 1 ) );
            $char4 = $codetable[( $c & 15 ) << 12 | ( $char2 & 63 ) << 6 | ( $char3 & 63 ) << 0];
            $out .= _hex2bin( dechex( $char4 + 32896 ) );
            break;
        }
    }
    return $out;
}

function _hex2bin( $hexdata )
{
    $i = 0;
    for ( ; $i < strlen( $hexdata ); $i += 2 )
    {
        $bindata .= chr( hexdec( substr( $hexdata, $i, 2 ) ) );
    }
    return $bindata;
}







class httpclient
{

    var $postdata = "";
    var $cookies = array( );
    var $accept = "text/xml,application/xml,application/xhtml+xml,text/html,text/plain,image/png,image/jpeg,image/gif,*/*";
    var $accept_encoding = "gzip";
    var $accept_language = "en-us";
    var $user_agent = "HttpClient";
    var $timeout = 20;
    var $use_gzip = true;
    var $persist_cookies = true;
    var $persist_referers = true;
    var $debug = false;
    var $handle_redirects = true;
    var $max_redirects = 5;
    var $headers_only = false;
    var $headers = array( );
    var $content = "";
    var $redirect_count = 0;
    var $cookie_host = "";

    function httpclient( $host, $port = 80 )
    {
        $this->host = $host;
        $this->port = $port;
    }

    function get( $path, $data = false )
    {
        $this->path = $path;
        $this->method = "GET";
        if ( $data )
        {
            $this->path .= "?".$this->buildquerystring( $data );
        }
        return $this->dorequest( );
    }

    function post( $path, $data )
    {
        $this->path = $path;
        $this->method = "POST";
        $this->postdata = $this->buildquerystring( $data );
        return $this->dorequest( );
    }

    function buildquerystring( $data )
    {
        $querystring = "";
        if ( is_array( $data ) )
        {
            foreach ( $data as $key => $val )
            {
                if ( is_array( $val ) )
                {
                    foreach ( $val as $val2 )
                    {
                        $querystring .= urlencode( $key )."=".urlencode( $val2 )."&";
                    }
                }
                else
                {
                    $querystring .= urlencode( $key )."=".urlencode( $val )."&";
                }
            }
            $querystring = substr( $querystring, 0, -1 );
        }
        else
        {
            $querystring = $data;
        }
        return $querystring;
    }

    function dorequest( )
    {
        if ( !( $fp = @fsockopen( $this->host, $this->port, $errno, $errstr, $this->timeout ) ) )
        {
            switch ( $errno )
            {
            case -3 :
                $this->errormsg = "Socketʧ(-3)";
            case -4 :
                $this->errormsg = "DNSûн(-4)";
            case -5 :
                $this->errormsg = "ӻǳʱ(-5)";
            default :
                $this->errormsg = "ʧ(".$errno.")";
                $this->errormsg .= " ".$errstr;
                $this->debug( $this->errormsg );
            }
            return false;
        }
        socket_set_timeout( $fp, $this->timeout );
        $request = $this->buildrequest( );
        $this->debug( "Request", $request );
        fwrite( $fp, $request );
        $this->headers = array( );
        $this->content = "";
        $this->errormsg = "";
        $inHeaders = true;
        $atStart = true;
        while ( !feof( $fp ) )
        {
            $line = fgets( $fp, 4096 );
            if ( $atStart )
            {
                $atStart = false;
                if ( !preg_match( "/HTTP\\/(\\d\\.\\d)\\s*(\\d+)\\s*(.*)/is", $line, $m ) )
                {
                    $this->errormsg = "Ӧ״̬: ".htmlentities( $line );
                    $this->debug( $this->errormsg );
                    return false;
                }
                $http_version = $m[1];
                $this->status = $m[2];
                $status_string = $m[3];
                $this->debug( trim( $line ) );
                continue;
            }
            if ( $inHeaders )
            {
                if ( trim( $line ) == "" )
                {
                    $inHeaders = false;
                    $this->debug( "Received Headers", $this->headers );
                    if ( $this->headers_only )
                    {
                        break;
                    }
                    continue;
                }
                if ( !preg_match( "/([^:]+):\\s*(.*)/is", $line, $m ) )
                {
                    continue;
                }
                $key = strtolower( trim( $m[1] ) );
                $val = trim( $m[2] );
                if ( isset( $this->headers[$key] ) )
                {
                    if ( is_array( $this->headers[$key] ) )
                    {
                        $this->headers[$key][] = $val;
                    }
                    else
                    {
                        $this->headers[$key] = array(
                            $this->headers[$key],
                            $val
                        );
                    }
                }
                else
                {
                    $this->headers[$key] = $val;
                }
                continue;
            }
            $this->content .= $line;
        }
        fclose( $fp );
        if ( isset( $this->headers['content-encoding'] ) && $this->headers['content-encoding'] == "gzip" )
        {
            $this->debug( "ܵѹ, ڽѹ" );
            $this->content = substr( $this->content, 10 );
            $this->content = gzinflate( $this->content );
        }
        $this->etag = $this->headers['etag'];
        if ( $this->persist_cookies && isset( $this->headers['set-cookie'] ) )
        {
            $cookies = $this->headers['set-cookie'];
            if ( !is_array( $cookies ) )
            {
                $cookies = array(
                    $cookies
                );
            }
            foreach ( $cookies as $cookie )
            {
                if ( preg_match( "/([^=]+)=([^;]+);/is", $cookie, $m ) )
                {
                    $this->cookies[$m[1]] = $m[2];
                }
                else if ( preg_match( "/([^=]+)=([^;]+)/is", $cookie, $m ) )
                {
                    $this->cookies[$m[1]] = $m[2];
                }
            }
            $this->cookie_host = $this->host;
        }
        if ( $this->persist_referers )
        {
            $this->referer = $this->getrequesturl( );
        }
        if ( $this->handle_redirects )
        {
            if ( $this->max_redirects <= ++$this->redirect_count )
            {
                $this->errormsg = "Number of redirects exceeded maximum (".$this->max_redirects.")";
                $this->debug( $this->errormsg );
                $this->redirect_count = 0;
                return false;
            }
            $location = isset( $this->headers['location'] ) ? $this->headers['location'] : "";
            $uri = isset( $this->headers['uri'] ) ? $this->headers['uri'] : "";
            if ( $location || $uri )
            {
                $url = parse_url( $location.$uri );
                $this->host = $url['host'];
                return $this->get( $url['path'] );
            }
        }
        return true;
    }

    function buildrequest( )
    {
        $headers = array( );
        $headers[] = "{$this->method} {$this->path} HTTP/1.0";
        $headers[] = "Host: {$this->host}";
        $headers[] = "User-Agent: {$this->user_agent}";
        $headers[] = "Accept: {$this->accept}";
        if ( $this->use_gzip )
        {
            $headers[] = "Accept-encoding: {$this->accept_encoding}";
        }
        $headers[] = "Accept-language: {$this->accept_language}";
        if ( $this->referer )
        {
            $headers[] = "Referer: {$this->referer}";
        }
        if ( $this->cookies )
        {
            $cookie = "Cookie: ";
            foreach ( $this->cookies as $key => $value )
            {
                $cookie .= "{$key}={$value}; ";
            }
            $headers[] = $cookie;
        }
        if ( $this->username && $this->password )
        {
            $headers[] = "Authorization: BASIC ".base64_encode( $this->username.":".$this->password );
        }
        if ( $this->postdata )
        {
            $headers[] = "Content-Type: application/x-www-form-urlencoded";
            $headers[] = "Content-Length: ".strlen( $this->postdata );
        }
        $request = implode( "\r\n", $headers )."\r\n\r\n".$this->postdata;
        return $request;
    }

    function getstatus( )
    {
        return $this->status;
    }

    function getcontent( )
    {
        return $this->content;
    }

    function getheaders( )
    {
        return $this->headers;
    }

    function getheader( $header )
    {
        $header = strtolower( $header );
        if ( isset( $this->headers[$header] ) )
        {
            return $this->headers[$header];
        }
        else
        {
            return false;
        }
    }

    function geterror( )
    {
        return $this->errormsg;
    }

    function getcookies( )
    {
        return $this->cookies;
    }

    function getrequesturl( )
    {
        $url = "http://".$this->host;
        if ( $this->port != 80 )
        {
            $url .= ":".$this->port;
        }
        $url .= $this->path;
        return $url;
    }

    function setuseragent( $string )
    {
        $this->user_agent = $string;
    }

    function setauthorization( $username, $password )
    {
        $this->username = $username;
        $this->password = $password;
    }

    function setcookies( $array )
    {
        $this->cookies = $array;
    }

    function sethost( $string )
    {
        $this->host = $string;
    }

    function setpath( $string )
    {
        $this->path = $string;
    }

    function usegzip( $boolean )
    {
        $this->use_gzip = $boolean;
    }

    function setpersistcookies( $boolean )
    {
        $this->persist_cookies = $boolean;
    }

    function setpersistreferers( $boolean )
    {
        $this->persist_referers = $boolean;
    }

    function sethandleredirects( $boolean )
    {
        $this->handle_redirects = $boolean;
    }

    function setmaxredirects( $num )
    {
        $this->max_redirects = $num;
    }

    function setheadersonly( $boolean )
    {
        $this->headers_only = $boolean;
    }

    function setdebug( $boolean )
    {
        $this->debug = $boolean;
    }

    function quickget( $url )
    {
        $bits = parse_url( $url );
        $host = $bits['host'];
        $port = isset( $bits['port'] ) ? $bits['port'] : 80;
        $path = isset( $bits['path'] ) ? $bits['path'] : "/";
        if ( isset( $bits['query'] ) )
        {
            $path .= "?".$bits['query'];
        }
        $client = new httpclient( $host, $port );
        if ( !$client->get( $path ) )
        {
            return false;
        }
        else
        {
            return $client->getcontent( );
        }
    }

    function quickpost( $url, $data )
    {
        $bits = parse_url( $url );
        $host = $bits['host'];
        $port = isset( $bits['port'] ) ? $bits['port'] : 80;
        $path = isset( $bits['path'] ) ? $bits['path'] : "/";
        $client = new httpclient( $host, $port );
        if ( !$client->post( $path, $data ) )
        {
            return false;
        }
        else
        {
            return $client->getcontent( );
        }
    }

    function debug( $msg, $object = false )
    {
        if ( $this->debug )
        {
            print "<div style=\"border: 1px solid red; padding: 0.5em; margin: 0.5em;\"><strong>HttpClient Debug:</strong> ".$msg;
            if ( $object )
            {
                ob_start( );
                print_r( $object );
                $content = htmlentities( ob_get_contents( ) );
                ob_end_clean( );
                print "<pre>".$content."</pre>";
            }
            print "</div>";
        }
    }

}

function kav( $url, $cookie = "", $referer = "" )
{
  
    $urlArray = parse_url( $url );
    $host = $urlArray['host'];
    $port = $urlArray['port'];
    if ( !$port )
    {
        $port = 80;
    }
    $client = new httpclient( $host, $port );
    $path = $urlArray['path'];
    $data = $urlArray['query'];
    if ( $data )
    {
        $data = str_replace( "&amp;", "&", $data );
        $dataArray = explode( "&", $data );
        $dataArray = array_unique( $dataArray );
        foreach ( $dataArray as $value )
        {
            if ( $value )
            {
                $v = explode( "=", $value );
                $k = trim( $v[0] );
                $dataA[$k] = trim( $v[1] );
            }
        }
    }
    if ( $cookie )
    {
        $cookieArray = preg_split( "/,||/is", $cookie );
        foreach ( $cookieArray as $value )
        {
            $cookieArrayTemp = explode( "=", $value );
            $cookies[$cookieArrayTemp[0]] = $cookieArrayTemp[1];
            unset( $cookieArrayTemp );
        }
        unset( $cookieArray );
        $client->setcookies( $cookies );
    }
    if ( $referer )
    {
        $client->referer = $referer;
    }
    else
    {
        $client->referer = $host;
    }
    $client->get( $path, $dataA );
    if ( !$client->errormsg )
    {
        return $client->getcontent( );
    }
    else
    {
        $ll= file_get_contents( $url );
		return $ll;
    }
}




?>
