<?php
/**
 +---------------------------------------------------------
 *  搜索控制器
 +---------------------------------------------------------
 * @name      Search.control.php [UTF-8]
 * @copyright http://www.97md.net
 * @access    MyDream
 * @author    zxing@97md.net
 * @version   2010-8-5 10:47:32
 +---------------------------------------------------------
 * @example
 */
defined('MyDream') or exit('Error: Access Denied!');

class SearchControl extends ControlBase {
    /**
     +-----------------------------------------------------
     * __call--执行检索查询
     * @access public
     * @param String $key 检索关键词
     * @return Boolen
     * @author zxing@97md.net 2010-08-05 22:58:37
     +-----------------------------------------------------
     * @example
     */
    public function __call( $key, $p) {
        if (!BrowserCache::isCached()) {
            $error_leval = error_reporting();
            error_reporting( E_ERROR );
            $key_title =  urldecode( str_replace('\'', '', substr( $key, 2 ) ) );
            global $_CONFIG;
            try {
                if( empty($key_title) ) {
                    throw new Exception('搜索内容为空', 0 );
                }
                // 初始化控制变量
                $is_add_new      = false; // 是否需要添加新关键词条目
                $is_get_related = false; // 是否需要重新抓取相关关键词
                $is_get_results  = false; // 是否需要重新抓取搜索结果
                $keywords_id    = false; // 关键词编号
                // 载入数据模块
                $model_keywords  = $this->LoadModel('Keywords');
                $model_results       = $this->LoadModel('Results');
                $keywords               = $model_keywords->byTitle($key_title);
                if( empty($keywords) ) {
                    $keywords = array();
                    $is_get_related = true;
                    $is_get_results  = true;
                    $is_add_new      = true;
                }else {
                    $keywords_id = $keywords['id'];
                    // 检查相关数据是否存在
                    if( empty($keywords['related']) ) {
                        $is_get_related = true;
                    }
                    $results = $model_results->getOne( $keywords_id ,false);
                    if(  empty($results) ) {
                        $is_get_results  = true;
                    }else {
                        $results['results'] = unserialize( preg_replace('!s:(\d+):"(.*?)";!se', "'s:'.strlen('$2').':\"$2\";'", $results['results'] ) );
                    }
                }
                // 初始化搜索引擎对象
                $seach_engine = array();
                $seach_engine[] = new YahooEngine();
                $seach_engine[] = new YoudaoEngine();
                $seach_engine[] = new GoogleEngine();
                $seach_engine[] = new BaiduEngine();
                shuffle($seach_engine);
                // 计数
                $seach_engine_count = count($seach_engine);
                // 插入新的关键词条目
                if( $is_add_new == true || $keywords_id == false ) {
                    $keywords = array(
                            'title' => $key_title,
                            'showtimes' => 1,
                            'lastseach' => time(),
                            'isseed' => 0,
                            'related' => NULL,
                            'lastupdate' => time()
                    );
                    $keywords['id'] = $keywords_id = $model_keywords->insert($keywords);
                }
                // 重新取得相关关键词
                if( $is_get_related ) {
                    $i = 0;
                    do {
                        $seach_engine[$i]->getUrl($key_title);
                        $keywords['related'] = $seach_engine[$i]->Related();
                        $i ++;
                    }while ( $i< $seach_engine_count && empty ($keywords['related']) );
                    $keywords['lastupdate'] = time();
                    $var = $keywords;
                    unset ($var['id']);
                    unset ($var['lastseach']);
                    $model_keywords->updateOne( $var, $keywords['id']);
                }
                // 重新获取搜索结果
                if( $is_get_results ) {
                    $temp  = array(); // 存放检索结果条目
                    $num_all = 0;
                    $temp_data = array();
                    $temp_url_rank = array();
                    $temp_url_id     = array();
                    foreach($seach_engine as $key=>$value) {
                        if($key==0 && ! empty($_CONFIG['domain'])) {
                            $_temp = $seach_engine[$key] ->getAll( 'site:'  .$_CONFIG['domain'][ array_rand($_CONFIG['domain']) ].   '  ' . $key_title) ;
                        }else {
                            $_temp =$seach_engine[$key] ->getAll($key_title) ;
                        }
                        $num_all += count($_temp);
                        foreach($_temp as $value) {
                            if( key_exists($value['link'], $temp_url_rank)) {
                                $_tmp_id = $temp_url_id[ $value['link'] ] ;
                                $temp_data[ $_tmp_id ]['rank'] = intval( ( $temp_data[ $_tmp_id ]['rank'] +$value['rank']  )* 0.8  );
                            }else {
                                $value['rank'] = floatval( $value['rank'] ) ;
                                $temp_data[] = $value;
                                $temp_url_rank[$value['link']] = intval($value['rank']);
                                $temp_url_id[$value['link']] = count( $temp_data ) - 1;
                            }
                        }
                    }
                    arsort($temp_url_rank);
                    $num_num = 0;
                    foreach ($temp_url_rank as $key=>$value) {
                        $num_num ++;
                        $temp[] = $temp_data[$temp_url_id[$key]];
                        if( $num_num>=100 ) {
                            break;
                        }
                    }
                    $results = array(
                            'id' => $keywords['id'],
                            'results' => $temp,
                            'islock' => 0,
                            'num' => $num_num,
                            'all' => $num_all,
                            'lastupdate' => time()
                    );
                    $var = $results;
                    $var['results'] = serialize($results['results']);
                    $model_results->insert($var);
                }
                error_reporting( $error_leval );
                // 分页信息
                $page = array();
                $page['now'] = empty (MDUrl::$page[1])?1:MDUrl::$page[1];
                $page['beg'] = 1;
                $page['end'] = ceil( $results['num']/10 );
                if($page['now']>1) {
                    $page['pl'] = $page['now']-1;
                }
                if( $page['now'] < $page['end'] ) {
                    $page['pn'] = $page['now'] +1;
                }
                $beg = ($page['now']-1) *10;
                $end = $beg + 10;
                $end = ($results['num']>$end)?$end:$results['num'];
                $r = array();
                for( $i=$beg; $i<$end; $i++ ) {
                    $r[$i] = $results['results'][$i];
                }
                $results['results'] = $r;
                // 传递变量
                $this->view->setVar( 'page', $page );
                $this->view->setVar( 'keywords', $keywords );
                $this->view->setVar( 'recent_words', $model_keywords->getRecent( 20 ) );
                $this->view->setVar( 'results', $results );
                $this->view->Show('/search');
            }catch(Exception $e ) {
                $e->getMessage();
                header('Location: /');
            }
        }
    }
}