<?php
/**
 * 应用程序基础类，让 ModelBase 和 ConlrolBase 共享部分功能
 * @name      AppBase.class.php
 * @copyright http://www.97md.net 
 * @access    MyDream
 * @author    zxing  Thu Jul 09 00:17:53 GMT+08:00 2009
 * @version   Thu Jul 09 00:17:53 GMT+08:00 2009
 */
defined('MyDream') or exit('Error: Access Denied!');

class AppBase extends Base {
    public $model = array();
    protected $input = null;
    /**
     +-----------------------------------------------------
     * 构造函数和析构函数
     * @access public
     * @param String $var
     * @return Void
     * @author zxing Thu Jul 09 01:09:23 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     * 如果程序员在子类中声明构造函数或析构函数则必须调用父类的构造函数和析构函数
     * parent::__construct();
     * parent::__destruct();
     */
    public function __construct(){
        $this->input = new Input();
    }
    /**
     +-----------------------------------------------------
     * 载入模块类
     * @access protected
     * @param String $model_name
     * @return Void
     * @author zxing Thu Jul 09 01:21:53 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    protected function LoadModel($model_name){
        if(empty($_ENV[$model_name])) {
            $model_class = $model_name.'Model';
            $model_file =   MD_ROOT.MODEL_ROOT.'/'.$model_name.'.model.php';
            if (!is_file($model_file) || !file_exists($model_file)){
                echo $model_file;
                throw new MDException('<br> 模型 : <b>'.$model_name.'</b> 不存在 ! <br/>');
            }
            require  $model_file;
            $_ENV[$model_name] = new $model_class();
            if ( get_parent_class($_ENV[$model_name]) != 'ModelBase' ) {
                unset($_ENV[$model_name]);
                throw new MDException('<br/> 模型:<b>'.$model_name.'</b> 不是拓展自模型基类 !</br>');
            }
        }
        return $_ENV[$model_name];
    }
}