<?php
/**
 * 动作类基类
 * @name      Action.class.php
 * @copyright http://www.97md.net
 * @access    97MD
 * @author    zxing  Sun Jun 07 12:09:08 GMT+08:00 2009
 * @version   Sun Jun 07 12:09:08 GMT+08:00 2009
 *
 * 注意：
 * 子类如果需要使用构造方法，
 * 则必须声明一个引用类型的参数，
 * 并将其传递给父类构造函数。
 *
 */
defined('MyDream') or exit('Error: Access Denied!');

abstract class ControlBase extends AppBase {
    public    $view      = null;
    protected $app       = null; // 应用程序类的引用
    private   $_my_model = null;
    private   $_base_tpl = '';
    /**
     * 构造函数和析构函数定义初始化变量和清理信息
     * @name name
     * @param Void
     * @return String
     * @author zxing Tue Jun 09 22:49:49 GMT+08:00 2009
     * @version  Tue Jun 09 22:49:49 GMT+08:00 2009
     */
    public function __construct() {
        parent::__construct();
        $this->view = new View($this);
        if (method_exists($this,'MdDefault')) {
            $this->MdDefault();
        }
    }
    /**
     * 自动调用默认函数
     * @name __call
     * @author zxing Thu Jun 11 22:23:17 GMT+08:00 2009
     * @version  Thu Jun 11 22:23:17 GMT+08:00 2009
     * @example
     */
    public function __call($fun,$key) {
        throw new MDException('<b> '.get_class($this).' </b>控制器不包含<b> '.$fun.' </b>动作!');
    }
    // 赋值该控制器的基础模型对象
    protected function _setMyModel(&$model_object) {
        $this->_my_model = $model_object;
    }
    // 传递控制器默认参数
    protected function _setDefault($title,$base_tpl='default') {
        $this->view->setVars('title',$title);
        $this->_base_tpl = $base_tpl;
    }
    // 入口 函数 给出列表
    public function onDefault($p) {
        try {
            // 取得表单信息
            if(empty($this->_my_model)) {
                throw new Exception('没有为控制器设置默认数据模型', 0);
            }
            $date_schema = $this->_my_model->getDateSchema();
            $schema_key  = $this->_my_model->getDateColumn();
            $this->view->setVars( 'date_schema' , $date_schema );
            $this->view->setVars( 'schema_key' , $schema_key );
            $paging = array();
            $list  = $this->_my_model->getList($paging);
            $this->view->setVars( 'paging' , $paging );
            $this->view->setVars( 'list' , $list );
            $this->view->show('list',array(),'default');
        }catch (Exception $e) {
            header('Location: /');
        }
    }
    // 给出添加页面
    public function onShowAdd($p) {
        try {
            if(empty($this->_my_model)) {
                throw new Exception('您未定义默认模型不能使用默认方法', 1);
            }
            // 取得表单信息
            $date_schema = $this->_my_model->getDateSchema();
            // 取得表单信息
            $this->view->setVars( 'date_schema' , $date_schema );
            $this->view->show( 'add' , array() , $this->_base_tpl );
        }catch (Exception $e) {
            $this->view->setVars('error',$e->getMessage());
            $this->view->setVars('go','/'.MDUrl::$C);
            $this->view->show('error',array(),'default');
        }
    }
    // 处理添加表单
    public function onDoAdd($p) {
        try {
            if(empty($this->_my_model)) {
                throw new Exception('您未定义默认模型不能使用默认方法', 1);
            }
            // 取得表单信息
            $date_schema = $this->_my_model->getDateSchema();
            // 表 us_area 数据条目
            $var = array();
            foreach ($date_schema as $key=>$value) {
                // 如果字段为修改时间则给出当前的UNIX时间戳 并继续
                if( $key == 'subtime' ) {
                    $var[$key] = time();
                    continue;
                }
                // 如果该字段为自动增长的字段则不在读取提交信息 并继续
                elseif(  strstr($value['EXTRA'], 'auto_increment') ) {
                    continue;
                }
                // 如果该字段没有提供 又为不必填字段则抛出异常
                elseif( empty ($_POST[$key]) && $value['IS_NULLABLE'] == 'NO' ) {
                    throw new Exception( $value['COLUMN_COMMENT'] . '('.$key.')' . ' 为必填字段', 1);
                }
                // 如果某一字段允许为空 且没有提交 则继续
                elseif( empty ($_POST[$key]) ) {
                    continue;
                }
                $var[$key] = $this->input->post($key);
            }
            // 数据取得完毕 开始写操作
            $result = $this->_my_model->insert($var);
            if($result && intval($result)) {
                // 写入成功
                $this->view->setVars( 'date_schema' , $date_schema );
                $this->view->show( 'add' , array('msg'=>'记录已保存!') , $this->_base_tpl);
            }else {
                // 写入失败 给出错误的 SQL 语句
                throw new Exception(
                '数据写入错误,SQL:<br/><small color="Red">'.$this->_my_model->getLastSql().'</small>'
                , 1);
            }
        }catch (Exception $e) {
            $this->view->setVars('error',$e->getMessage());
            $this->view->setVars('go','/'.MDUrl::$C);
            $this->view->show('error',array(),'default');
        }
    }
    // 给出编辑表单
    public function onShowEdit($id) {
        try {
            if(empty($this->_my_model)) {
                throw new Exception('您未定义默认模型不能使用默认方法', 1);
            }
            // 取得表单信息
            $date_schema = $this->_my_model->getDateSchema();
            // 取得表单信息
            $this->view->setVars( 'date_schema' , $date_schema );
            $this->view->setVars('id',$id);
            $this->view->setVars('var',$this->_my_model->getOne($id));
            $this->view->show( 'edit' , array() , $this->_base_tpl );
        }catch (Exception $e) {
            $this->view->setVars('error',$e->getMessage());
            $this->view->setVars('go','/'.MDUrl::$C);
            $this->view->show('error',array(),'default');
        }
    }
    // 处理编辑表单
    public function onDoEdit($id) {
        try {
            if(empty($this->_my_model)) {
                throw new Exception('您未定义默认模型不能使用默认方法', 1);
            }
            // 取得表单信息
            $date_schema = $this->_my_model->getDateSchema();
            // 表 us_area 数据条目
            $var = array();
            foreach ($date_schema as $key=>$value) {
                // 如果字段为修改时间则给出当前的UNIX时间戳 并继续
                if( $key == 'subtime' ) {
                    $var[$key] = time();
                    continue;
                }
                // 如果该字段为自动增长的字段则不在读取提交信息 并继续
                elseif(  strstr($value['EXTRA'], 'auto_increment') ) {
                    continue;
                }
                // 如果某一字段允许为空 且没有提交 则继续
                elseif( empty ($_POST[$key]) ) {
                    continue;
                }
                $var[$key] = $this->input->post($key);
            }
            // 数据取得完毕 开始写操作
            $result = $this->_my_model->updateOne($var,$id);
            if($result) {
                // 写入成功
                $this->view->setVars( 'date_schema' , $date_schema );
                $this->view->setVars('id',$id);
                $this->view->setVars('var',$this->_my_model->getOne($id));
                $this->view->show( 'edit' , array('msg'=>'记录已保存!') , $this->_base_tpl);
            }else {
                // 写入失败 给出错误的 SQL 语句
                throw new Exception(
                '数据写入错误,SQL:<br/><small color="Red">'.$this->_my_model->getLastSql().'</small>'
                , 1);
            }
        }catch (Exception $e) {
            $this->view->setVars('error',$e->getMessage());
            $this->view->setVars('go','/'.MDUrl::$C);
            $this->view->show('error',array(),'default');
        }
    }
}