<?php
/**
 * 模型类基类
 * @name      ModelBase.class.php
 * @copyright http://www.97md.net
 * @access    MyDream
 * @author    zxing  Thu Jul 09 00:16:57 GMT+08:00 2009
 * @version   Thu Jul 09 00:16:57 GMT+08:00 2009
 */
defined('MyDream') or exit('Error: Access Denied!');

class ModelBase extends AppBase {
    private $_table    = ''; // 表名
    private $_table_id = 'id'; // ID字段名
    protected $db     = null;
    protected $cache  = null;
    /**
     +-----------------------------------------------------
     * 构造函数和析构函数
     * @access public
     * @return Void
     * @author zxing Thu Jul 09 01:06:50 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function __construct($app_key='') {
        global $_CONFIG;
        parent::__construct();
        // $this->db = new mysql();
        if( empty($_ENV['db_object']) ) {
            $_ENV['db_object'] = new DB($_CONFIG['db']);
        }
        $this->db = $_ENV['db_object'];
        $this->cache  = new CacheDB($app_key.':Model:'.get_class($this) );
        if (method_exists($this,'MdDefault')) {
            $this->MdDefault();
        }
    }
    /**
     +-----------------------------------------------------
     * 取得一个分页查询对象
     * @access public
     * @param String $object=null 默认取得该模块的分页对象
     * @return Void
     * @author zxing@97md.net Sun Aug 16 16:08:18 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function getPaging($limit=20,$object='') {
        $key = get_class($this).'::'.$object;
        if (isset($_ENV['paging::'.$key])) {
            $this->paging = $_ENV['paging::'.$key];
        }else {
            global $_CONFIG;
            $this->paging = new DBPaging($_CONFIG['db'],$limit);
            $_ENV['paging::'.$key] = $this->paging;
        }
        return $this->paging;
    }
    // 取得数据库错误
    public function getDbError() {
        return $this->db->getError();
    }
    public function getLastSql() {
        return $this->db->getLastSql();
    }
    /**
     +-----------------------------------------------------
     * 取得数据表级别的缓存
     * @access protected
     * @param  Array $keys 要缓存的值, String  $table 要缓存的表, String $where 限制条件 , Int $time 缓存时间
     * @return Void
     * @author zxing Sun Jul 19 02:40:50 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     * 是为了方便操作那些必须存储在数据库中又几乎几百年不变的数据而设计的，
     * 使用它就可以将那些数据统统抓出来现形，又不必每个模块单独写处理函数，以减少代码和增加缓存的命中率。
     */
    protected function tableCache($keys,$table,$where,$time=36000) {
        $result = array();
        $key = md5('$keys'.serialize($keys).'$table'.$table.'$where'.$where);
        $old_model = $this->cache->EditModel(__FUNCTION__);
        if ($this->cache->isCached($key,$time)) {
            $result = $this->cache->getCached();
        }else {
            $sql = 'SELECT '.implode(',',$keys).' FROM '.trim($table).' ';
            if (!empty($where)) {
                $sql .= ' WHERE '.$where;
            }
            $sql .= ';';
            $this->db->query($sql);
            while ($this->db->fetchArray()) {
                $result[] = $this->db->result_array;
            }
            $this->cache->saveCached($result);
        }
        $this->cache->EditModel($old_model);
        return $result;
    }
    /**
     +-----------------------------------------------------
     * 设置表名和索引字段名
     * @access protected
     * @param String $table 表名
     * @param String $table_id 索引字段名
     * @return Void
     * @author zxing@97md.net Tue Nov 24 18:36:50 CST 2009
     +-----------------------------------------------------
     * @example
     */
    protected  function _SetTable($table,$table_id='id') {
        $this->_table = $table;
        $this->_table_id = $table_id;
    }
    // 取得数据库中的数据结构
    public function getDateSchema( $is_cache = true ) {
        $result = array();
        if (empty($this->_table) || empty($this->_table_id)) {
            throw new Exception('您还没设置表名不能使用'.__FUNCTION__);
        }
        $cache_key = __FUNCTION__.'-'.$this->_table;
        if ( $is_cache && $this->cache->isCached($cache_key,3600*24*7) ) {
            $result = $this->cache->getCached();
        }else {
            global $_CONFIG; // 取得全局配置中的mysql数据库信息
            $sql = 'SELECT *
            FROM INFORMATION_SCHEMA.COLUMNS
            WHERE table_name = \''.$this->_table.'\'
            AND table_schema = \''.$_CONFIG['db']['database'].'\'';
            $this->db->query($sql);
            while ($this->db->fetchArray()) {
                $result[$this->db->result_array['COLUMN_NAME']] = $this->db->result_array;
            }
            $this->cache->saveCached($result,$cache_key);
        }
        return $result;
    }
    // 取得数据模型的所有字段
    public function getDateColumn( $is_cache = true ) {
        $result = array();
        if (empty($this->_table) || empty($this->_table_id)) {
            throw new Exception('您还没设置表名不能使用'.__FUNCTION__);
        }
        $cache_key = __FUNCTION__.'-'.$this->_table;
        if ( $is_cache && $this->cache->isCached($cache_key,3600*24*7) ) {
            $result = $this->cache->getCached();
        }else {
            // 调用 getDateSchema 得到全部的数据结构
            $column = $this->getDateSchema($is_cache);
            foreach ($column as $key=>$value) {
                $result[] = $key;
            }
            $this->cache->saveCached($result,$cache_key);
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * 得到指定ID的一条数据
     * @access public
     * @param Int $id
     * @return Array
     * @author zxing@97md.net Tue Nov 24 18:28:06 CST 2009
     +-----------------------------------------------------
     * @example
     */
    public function getOne($id,$is_cache=true) {
        $result = array();
        if (empty($this->_table) || empty($this->_table_id)) {
            throw new Exception('您还没设置表名不能使用'.__FUNCTION__);
        }
        $cache_key = 'getOne-' . serialize( $id ) ;
        if ($is_cache && $this->cache->isCached($cache_key,3600*24*7)) {
            $result = $this->cache->getCached();
        }else {
            if( is_numeric($id) ) {
                $sql = 'SELECT * FROM `'.$this->_table.'` WHERE `'.$this->_table_id.'` = '.$id;
            }elseif( is_array($id) ) {
                $sql = 'SELECT * FROM `'.$this->_table.'` WHERE `'.$this->_table_id.'` IN (' . implode(',', $id ) . ');';
            }elseif( is_string($id) ) {
                $sql = 'SELECT * FROM `'.$this->_table.'` WHERE '. $id . ';';
            }
            $this->db->query($sql);
            while ($this->db->fetchArray()) {
                if( is_numeric($id) ) {
                    $result = $this->db->result_array;
                }else {
                    $result[ $this->db->result_array[$this->_table_id] ] = $this->db->result_array;
                }
            }
            $this->cache->saveCached($result,$cache_key);
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * 向指定的表中插入一条数据，并且数据值是以数组方式给出的
     * @access protected
     * @param String $table
     * @param Array $var
     * @param Array $table_key 数据表里面的字段
     * @return Int 插入后的编号
     * @author zxing Thu Jul 09 01:53:02 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function insert($var,$table_key=array()) {
        $result = false;
        if (empty($this->_table) || empty($this->_table_id)) {
            throw new Exception('您还没设置表名不能使用'.__FUNCTION__);
        }
        $table = $this->_table;
        if ( !empty($table) && !empty($var) ) {
            $sql    = 'INSERT INTO `'.$table.'` SET ';
            foreach ($var as $key=>$value) {
                if (!empty($table_key) && !in_array($key,$table_key)) {
                    continue;
                }
                if ($value===null) {
                    $sql .= ' `'.$key.'` = null ,';
                }else {
                    $sql .= ' `'.$key.'` = \''.$value.'\',';
                }
            }
            $sql = substr($sql,0,-1);
            // 执行SQL语句
            $result = $this->db->query($sql);
            if ($result) {
                $result = $this->db->getInsertId();
                if (!$result) {
                    $result = true;
                }
            }else {
                $_ENV['ERROR'] = $sql;
            }
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * 删除一条指定的数据
     * @access public
     * @param Int $id
     * @return Boolen
     * @author zxing@97md.net Tue Nov 24 18:34:56 CST 2009
     +-----------------------------------------------------
     * @example
     */
    public function deleteOne($id) {
        $result = false;
        if (empty($this->_table) || empty($this->_table_id)) {
            throw new Exception('您还没设置表名不能使用'.__FUNCTION__);
        }
        $sql = 'DELETE FROM '.$this->_table.' WHERE '.$this->_table_id.'='.$id;
        $result = $this->db->query($sql);
        $this->cache->deleteCache( 'getOne-' . $id);
        return $result;
    }
    /**
     +-----------------------------------------------------
     * 更新数据表
     * @access protected
     * @param String $table 要更新的数据表名称
     * @param Array $var 需要更新的字段数组
     * @param String $where 限制条件 更新哪些记录
     * @return Boolen SQL是否执行成功
     * @author zxing Thu Jul 09 01:58:11 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function updateOne($var,$id,$table_key=array()) {
        $result = false;
        if (empty($this->_table) || empty($this->_table_id)) {
            throw new Exception('您还没设置表名不能使用'.__FUNCTION__);
        }
        $table = $this->_table;
        $sql    = 'UPDATE '.$table.' SET ';
        foreach ($var as $key=>$value) {
            if (!empty($table_key) && !in_array($key,$table_key)) {
                continue;
            }
            if ($value===null) {
                $sql .= ' '.$key.' = null,';
            }else {
                $sql .= ' '.$key.' = \''.$value.'\',';
            }
        }
        $sql = substr($sql,0,-1);
        $sql .= ' WHERE `'.$this->_table_id.'`='.$id.' ;';
        // 执行SQL语句
        // exit($sql);
        $result = $this->db->query($sql);
        $this->cache->deleteCache( 'getOne-' . $id);
        return $result;
    }
    /**
     +-----------------------------------------------------
     * 给出该表格的列表以及分页
     * @access protected
     * @param Array $paging 返回的分页信息
     * @param Array $limit 限制条件 数组各项之间是 AND 关系请仔细填写每个子项目
     * @param Array $order 排序条件 请写明每一项的排序方式 ORDER BY {0},{1},...
     * @param Int $page_now 当前分页页数
     * @return Array 结果集数组
     * @author zxing
     +-----------------------------------------------------
     * @example
     */
    public function getList(&$paging,$limit=array(),$order=array(),$page_now=false) {
        $result = array();
        if (empty($this->_table) || empty($this->_table_id)) {
            throw new Exception('您还没设置表名不能使用'.__FUNCTION__);
        }
        if($page_now===false) {
            $page_now = isset (MDUrl::$page[1])?MDUrl::$page[1]:1 ;
        }else {
            $page_now = intval($page_now);
        }
        $order[]  = ' `'.$this->_table_id.'`  DESC ';
        // $cache_key = __FUNCTION__.$this->_table.' - '.serialize($order).' - '.serialize($limit).' - '.$page_now;
        // 根据限制条件组合SQL语句
        $sql = ' FROM `'.$this->_table.'` ';
        if(!empty($limit)) {
            $sql .= ' WHERE '.implode(' AND ', $limit);
        }

        // 读取信息总条数
        $total_number = 0;
        $this->db->query('SELECT COUNT(*) AS number '.$sql);
        if($this->db->fetchArray()) {
            $total_number = $this->db->result_array['number'];
        }
        // 取得分页信息
        $page = new Paging(20);
        $page->totalNum($total_number);
        $page->pageNow( $page_now ); // 取得当前分页
        $sql_limit = $page->getLimit();  // 读取limit
        $sql = 'SELECT `'.$this->_table_id.'` ' . $sql . ( empty ($order)?'':' ORDER BY '.implode(' , ', $order) ) . ' LIMIT '.$sql_limit;
        $this->db->query($sql);
        while ($this->db->fetchArray()) {
            $result[$this->db->result_array[$this->_table_id]] = array();
        }
        foreach ($result as $key => $value) {
            $result[$key] = $this->getOne($key);
        }
        $paging = $page->getPageLink();
        return $result;
    }
}