<?php
/**
 * 界面展示类用来处理应用程序的模板展示问题
 * @name      View.class.php
 * @copyright http://www.97md.net
 * @access    97MD
 * @author    zxing  Mon Jun 08 23:15:32 GMT+08:00 2009
 * @version   Mon Jun 08 23:15:32 GMT+08:00 2009
 */
defined('MyDream') or exit('Error: Access Denied!');

class View extends Base {
    protected
            $_control  = '',
            $_tpl_name = null,
            $_tpl_file = null,
            $_app      = null,  // App 应用程序类对象的应用
            $_long     = null,  // 数组，语言包变量
            $_vars     = array();
    /**
     +-----------------------------------------------------
     * 模版类构造函数
     * @access public
     * @param Object Control control类的引用
     * @return Void
     * @author zxing Sun Jul 12 18:17:19 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function __construct(&$action) {
        if (strstr(get_class($action),'Control')) {
            $this->_control = str_replace('Control','',get_class($action));
        }
    }
    /**
     +-----------------------------------------------------
     * 设置模板变量
     * @access public
     * @param String $key 变量名, $value 变量值
     * @return Void
     * @author zxing Sun Jul 12 18:14:13 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function setVar($key, $value) {
        $this->_vars[$key] = $value;
    }
    /**
     +-----------------------------------------------------
     * 批量设置模板变量
     * @access public
     * @param Array $key_value 变量信息
     * @return Void
     * @author zxing 2010-05-13 23:48:22
     +-----------------------------------------------------
     * @example
     */
    public function setVars($key_value) {
        if (!is_array($key_value)) {
            throw new Exception(__FUNCTION__.'($key_value)参数必须为数组！');
        }
        foreach($key_value as $key => $value) {
            $this->_vars[$key] = $value;
        }
    }
    /**
     +-----------------------------------------------------
     * 载入模板
     * @access public
     * @param Array String $tpl 模板文件名称，Array $_show_var 附加变量数组优先级高于 $this->vars
     * @return Void 显示输出到浏览器
     * @author zxing@97md.net Fri Aug 07 14:54:21 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function show($tpl,$_show_var = array(),$base_tpl='') {
        global $_CONFIG;
        // 如果要求的模板以 / 开始则跳出控制器目录直接读取模板根目录
        if (substr($tpl,0,1)!='/') {
            if(empty($base_tpl)) {
                $tpl = '/'.$this->_control.'/'.$tpl;
            }else {
                $tpl = '/'.$base_tpl.'/'.$tpl;
            }
            if (!file_exists(MD_ROOT.TPL_ROOT.'/'.$this->_control)) {
                mkdir(MD_ROOT.TPL_ROOT.'/'.$this->_control,0755);
            }
        }
        $this->_tpl_name = $tpl;
        $this->_tpl_file = MD_ROOT.TPL_ROOT.$this->_tpl_name.'.html.php';
        unset($tpl);
        // 重建 Action 的 var 变量和 Show 传递的变量
        if (is_array($this->_vars)) {
            foreach ($this->_vars as $key=>$value) {
                $$key = $value;
            }
        }
        if (is_array($_show_var)) {
            foreach ($_show_var as $key=>$value) {
                $$key = $value;
            }
        }
        // 如果模板文件存在则直接引入 否则 抛出异常
        if (is_file($this->_tpl_file) && file_exists($this->_tpl_file)) {
            include($this->_tpl_file);
        }else {
            throw new MDException('Tpl : <b>'.$this->_tpl_name.'</b> is not Exists!');
        }
    }
    /**
     +-----------------------------------------------------
     * 输出Json格式的数据，注意此函数不会载入语言包！
     * @access public
     * @param Array $_show_var 附加变量数组优先级高于 $this->vars
     * @return Void 使用echo显示输出到浏览器
     * @author zxing@97md.net Fri Aug 07 14:54:21 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function showJson($_show_var = array()) {
        $var = array_merge($this->_vars,$_show_var);
        echo json_encode($var);
    }
}