<?php
/**
 +---------------------------------------------------------
 * 应用程序入口类
 +---------------------------------------------------------
 * @name      app.class.php
 * @copyright http://www.97md.net
 * @access    MyDream
 * @author    zxing  Sun Jul 12 18:33:44 GMT+08:00 2009
 * @version   Sun Jul 12 18:33:44 GMT+08:00 2009
 +---------------------------------------------------------
 * @example
 */
defined('MyDream') or exit('Error: Access Denied!');

class app extends Base {
    public
            $Controler,   // 控制器
            $Action,      // 动作
            $Parameters;  // 参数
    /**
     +-----------------------------------------------------
     * 应用程序类入口
     * @access public
     * @return Void
     * @author zxing Sun Jul 12 18:34:18 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function __construct() {
        new MDUrl();
        $this->Controler  = empty(MDUrl::$C)?'index':MDUrl::$C;
        $this->Action     = empty(MDUrl::$A)?'Default':MDUrl::$A;
        $this->Parameters = empty(MDUrl::$P)?'':MDUrl::$P;
    }
    /**
     +-----------------------------------------------------
     * 执行应用程序
     * @access public
     * @return Void
     * @author zxing Sun Jul 12 18:35:18 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function run() {
        global $_CONFIG;
        if($_CONFIG['super_cache']) {
            $cache_obj = new CacheDB(__FUNCTION__);
            $cache_key  = 'http://' . $_SERVER['HTTP_HOST'];
            $cache_key .= '?' . MDUrl::$C . '&' . MDUrl::$A . '&' . serialize(MDUrl::$P);
            $cache_time = 1800;
            $http_host   = explode( '.' , $_SERVER['HTTP_HOST'] );
            if( isset ($http_host[0]) && isset ($http_host[1]) && is_numeric($http_host[0]) && $http_host[1]=='atc' ) {
                $cache_time = 3600*24*30;
            }
        }
        if($_SERVER['REQUEST_METHOD'] == 'GET' && $_CONFIG['super_cache'] ==true && $cache_obj->isCached($cache_time,3600) ) {
            echo $cache_obj->getCached();
            echo "\r\n<!--" ,$cache_obj->getCacheName() , '-->';
        }else {
            $controler_class = $this->Controler.'Control';
            $action_function = 'on'.$this->Action;
            $controler_file =  MD_ROOT.CONTROL_ROOT.'/'.$this->Controler.'.control.php';
            if (is_file($controler_file) && file_exists($controler_file)) {
                require($controler_file);
                $action_obj = null;
                if (class_exists($controler_class,false)) {
                    $action_obj = new $controler_class();
                }else {
                    throw new MDException('<br> 控制器类 : <b>'.$controler_class.'</b> 不存在 ! <br/>');
                }
                if ( get_parent_class($action_obj) != 'ControlBase' ) {
                    throw new MDException('<br/> <b>'.$controler_class.'</b> 未继承自 ControlBase !</br>');
                }
                if (method_exists($action_obj,$action_function) || method_exists($action_obj,'__call')) {
                    $action_obj->$action_function($this->Parameters);
                }else {
                    throw new MDException('<br/> Action:<b>'.$action_function.'</b> is not extends in '.$controler_class.' !</br>');
                }
            }else {
                echo $controler_file;
                throw new MDException('<br> Controler : <b>'.$this->Controler.'</b> is not exists ! <br/>');
            }
            if( $_CONFIG['super_cache'] ) {
                $cache_obj->saveCached(ob_get_contents(), $cache_key);
            }
        }
    }
}
