<?php
/**
 +---------------------------------------------------------
 * 缓存类基类
 +---------------------------------------------------------
 * @name      CacheBase.class.php
 * @copyright http://www.97md.net 
 * @access    MyDream
 * @author    zxing  Sun Jul 12 12:14:25 GMT+08:00 2009
 * @version   Sun Jul 12 12:14:25 GMT+08:00 2009
 +---------------------------------------------------------
 * @example
 */
defined('MyDream') or exit('Error: Access Denied!');

abstract class CacheBase extends Base {
    protected $cache_id='';
    protected $time_out = 3600;
    
    private $_model = '';
    /**
     +-----------------------------------------------------
     * 缓存类构造函数
     * @access public
     * @param String $model 模块缓存分组
     * @return Void
     * @author zxing Sun Jul 12 12:15:11 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function __construct($model=''){
        $this->_model = $model;
    }
    public function __destruct(){ }
    /**
     +-----------------------------------------------------
     * 修改模块名字
     * @access public
     * @param String $model_name
     * @return Void
     * @author zxing Sun Jul 19 02:43:54 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function EditModel($model_name){
    	$result = $this->_model;
    	$this->_model = $model_name;
    	return $result;
    }
    /**
     +-----------------------------------------------------
     * 根据ID得到缓存编号
     * @access protected
     * @param String $key
     * @return Void
     * @author zxing Sun Jul 12 12:17:05 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    protected function getId($key){
        if (!empty($this->_model)){
            $key = 'Model-'.$this->_model.'::key-'.$key;
        }
        $this->cache_id = md5($key);
        return $this->cache_id;
    }
}