<?php
/**
 +---------------------------------------------------------
 * 数据库缓存类
 +---------------------------------------------------------
 * @name      CacheDB.class.php
 * @copyright http://www.97md.net
 * @access    MyDream
 * @author    zxing  Sun Jul 12 12:30:30 GMT+08:00 2009
 * @version   Sun Jul 12 12:30:30 GMT+08:00 2009
 +---------------------------------------------------------
 * @example
 */
defined('MyDream') or exit('Error: Access Denied!');
// 缓存文件目录设置
defined('CACHEFILE_BASE') or define('CACHEFILE_BASE',MD_ROOT.CACHE_ROOT);

class CacheDB extends CacheBase implements CacheInterfice {
    private $_db = '';
    private $_table = '';
    /**
     +-----------------------------------------------------
     * __construct--构造函数
     * @access public
     * @return Boolen
     * @author zxing@97md.net 2010-05-25 18:23:58
     +-----------------------------------------------------
     * @example
     */
    public function  __construct($model='') {
        parent::__construct($model);
        global $_CONFIG;
        $this->_table = $_CONFIG['db']['prefix'].'cache';
        $this->_db = new DB($_CONFIG['db']);
        $rand_key =rand(1, 10000);
         if( $rand_key>9999 ) {
            $this->_db->query('DROP TABLE IF EXISTS `' . $this->_table . '` ;');
        }
        $sql = 'CREATE TABLE IF NOT EXISTS `' . $this->_table . '` (
            `key` char(32) NOT NULL ,
            `value` longblob,
            `creattime` int(11) unsigned DEFAULT NULL ,
            PRIMARY KEY (`key`)
            ) ENGINE=MyISAM  DEFAULT CHARSET='.$_CONFIG['db']['charset'].' ;';
        $this->_db->query($sql);
        if( $rand_key>9990 ) {
            $this->_db->query('OPTIMIZE TABLE `' . $this->_table . '`;');
        }
    }
    /**
     +-----------------------------------------------------
     * 检查缓存文件是否存在
     * @access public
     * @param String $key=null,$time_out=3600
     * @return Void
     * @author zxing Sun Jul 12 12:34:00 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function isCached($key,$time_out=3600) {
        $this->getId($key);
        $this->time_out = $time_out;
        $cached = false;
        $sql = 'SELECT COUNT(*) AS `number`
            FROM `' . $this->_table . '`
            WHERE `key`=\''.$this->cache_id.'\' AND `creattime`>='.( time()-$time_out ).';';
        $this->_db->query($sql);
        if($this->_db->fetchArray()) {
            if($this->_db->result_array['number']>0) {
                $cached = true;
            }
        }
        return $cached;
    }
    /**
     +-----------------------------------------------------
     * 检查缓存文件是否存在
     * @access public
     * @param String $key=null
     * @return Void
     * @author zxing Sun Jul 12 12:34:00 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function getCached($key=null) {
        $result = false;
        if (!empty($key)) {
            $this->getId($key);
        }
        $sql = 'SELECT UNCOMPRESS(`value`) AS value
            FROM `' . $this->_table . '`
            WHERE `key`=\''.$this->cache_id.'\' ;';
        $this->_db->query($sql);
        if($this->_db->fetchArray()) {
            $result = unserialize( preg_replace('!s:(\d+):"(.*?)";!se', "'s:'.strlen('$2').':\"$2\";'", $this->_db->result_array['value']  ) );
            // $result = unserialize( gzuncompress( $this->_db->result_array['value'] ) );
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * 检查缓存文件是否存在
     * @access public
     * @param  Var $var 要保存的变量, String $key=null
     * @return Void
     * @author zxing Sun Jul 12 12:34:00 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function saveCached($var,$key=null) {
        // 处理缓存编号信息
        if (!empty($key)) {
            $this->getId($key);
        }
        $cached = false;
        $sql = 'SELECT COUNT(*) AS `number`
            FROM `' . $this->_table . '`
            WHERE `key`=\''.$this->cache_id.'\';';
        $this->_db->query($sql);
        if($this->_db->fetchArray()) {
            if($this->_db->result_array['number']>0) {
                $cached = true;
            }
        }
        if($cached) {
            $sql = 'UPDATE `' . $this->_table . '` SET
                   `value`=COMPRESS(\''.serialize($var).'\'),`creattime`='.( time() ).'
                   WHERE `key`= \''.$this->cache_id.'\';';
        }else {
            $sql = 'INSERT INTO `' . $this->_table . '`
            (`key`,`value`,`creattime`)
            VALUES
            (\''.$this->cache_id.'\',COMPRESS(\''.  serialize($var) .'\'),'.( time() ).');';
            // (\''.$this->cache_id.'\',\''. gzcompress( serialize($var) ,5 ) .'\','.( time() ).');';
        }
        $result = $this->_db->query($sql);
        return $result;
    }
    /**
     +-----------------------------------------------------
     * 删除缓存文件
     * @access public
     * @param  String $key=null
     * @return Void
     * @author zxing 2010-04-07 00:55:06
     +-----------------------------------------------------
     * @example
     */
    public function deleteCache($key=null) {
        if (!empty($key)) {
            $this->getId($key);
        }
        $sql = 'DELETE * FROM `' . $this->_table . '`
            WHERE `key`=\''.$this->cache_id.'\';';
        $this->_db->query($sql);
        return TRUE;
    }
    /**
     +-----------------------------------------------------
     * getCacheName--得到缓存键名
     * @access public
     * @param  $key=null
     * @return String
     * @author zxing@97md.net 2010-06-14 23:38:05
     +-----------------------------------------------------
     * @example
     */
    public function getCacheName($key=null) {
        if (!empty($key)) {
            $this->getId($key);
        }
        return $this->cache_id;
    }
}