<?php
/**
 +---------------------------------------------------------
 * 文件缓存类
 +---------------------------------------------------------
 * @name      CacheFile.class.php
 * @copyright http://www.97md.net
 * @access    MyDream
 * @author    zxing  Sun Jul 12 12:30:30 GMT+08:00 2009
 * @version   Sun Jul 12 12:30:30 GMT+08:00 2009
 +---------------------------------------------------------
 * @example
 */
defined('MyDream') or exit('Error: Access Denied!');
// 缓存文件目录设置
defined('CACHEFILE_BASE') or define('CACHEFILE_BASE',MD_ROOT.CACHE_ROOT);

class CacheFile extends CacheBase implements CacheInterfice {
    private $_cache_file = '';
    /**
     +-----------------------------------------------------
     * 检查缓存文件是否存在
     * @access public
     * @param String $key=null,$time_out=3600
     * @return Void
     * @author zxing Sun Jul 12 12:34:00 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function isCached($key,$time_out=3600) {
        $this->getId($key);
        $this->_getCacheFile();
        $this->time_out = $time_out;
        $cached = false;
        // 检查缓存文件是否存在 如果存在再检查文件修改时间是否在缓存要求时间之内
        if (is_file($this->_cache_file) && file_exists($this->_cache_file)) {
            if (time() - filectime($this->_cache_file) < $this->time_out) {
                $cached = true;
            }
        }
        return $cached;
    }
    /**
     +-----------------------------------------------------
     * 检查缓存文件是否存在
     * @access public
     * @param String $key=null
     * @return Void
     * @author zxing Sun Jul 12 12:34:00 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function getCached($key=null) {
        if (!empty($key)) {
            $this->getId($key);
            $this->_getCacheFile();
        }
        if (empty($this->_cache_file)) {
            $this->_getCacheFile();
        }
        // 取出文件
        return unserialize(file_get_contents($this->_cache_file));
    }
    /**
     +-----------------------------------------------------
     * 检查缓存文件是否存在
     * @access public
     * @param  Var $var 要保存的变量, String $key=null
     * @return Void
     * @author zxing Sun Jul 12 12:34:00 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function saveCached($var,$key=null) {
        // 处理缓存编号信息
        if (!empty($key)) {
            $this->getId($key);
            $this->_getCacheFile();
        }
        if (empty($this->_cache_file)) {
            $this->_getCacheFile();
        }
        // 重写缓存文件
        $handle = fopen($this->_cache_file,'w+');
        $result = fwrite($handle,serialize($var));
        fclose($handle);
        return $result;
    }
    /**
     +-----------------------------------------------------
     * 删除缓存文件
     * @access public
     * @param  String $key=null
     * @return Void
     * @author zxing 2010-04-07 00:55:06
     +-----------------------------------------------------
     * @example
     */
    public function deleteCache($key=null) {
        if (!empty($key)) {
            $this->getId($key);
            $this->_getCacheFile();
        }
        if (empty($this->_cache_file)) {
            $this->_getCacheFile();
        }
        // 如果缓存文件存在则删除，否则直接返回成功
        if (file_exists($this->_cache_file)) {
            return unlink($this->_cache_file);
        }else {
            return TRUE;
        }
    }
    /**
     +-----------------------------------------------------
     * 得到缓存文件的名字，并且尝试创建目录
     * @access protected
     * @param void
     * @return Void
     * @author zxing Sun Jul 12 12:37:05 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    protected function _getCacheFile() {
        $this->_cache_file = CACHEFILE_BASE;
        if (!file_exists($this->_cache_file)) {
            mkdir($this->_cache_file,0755);
        }
        $this->_cache_file .= '/'.substr($this->cache_id,10,1);
        if (!file_exists($this->_cache_file)) {
            mkdir($this->_cache_file,0755);
        }
        $this->_cache_file .= '/'.substr($this->cache_id,20,1);
        if (!file_exists($this->_cache_file)) {
            mkdir($this->_cache_file,0755);
        }
        $this->_cache_file .= '/'.substr($this->cache_id,30,1);
        if (!file_exists($this->_cache_file)) {
            mkdir($this->_cache_file,0755);
        }
        $this->_cache_file .= '/'.$this->cache_id.'.cache';
        return $this->_cache_file;
    }
    /**
     +-----------------------------------------------------
     * getCacheName--得到缓存文件名
     * @access public
     * @param Int $id
     * @return Boolen
     * @author zxing@97md.net 2010-06-14 23:29:20
     +-----------------------------------------------------
     * @example
     */
    public function getCacheName($key=null) {
        if (!empty($key)) {
            $this->getId($key);
            $this->_getCacheFile();
        }
        return substr($this->_cache_file,strlen(dirname($this->_cache_file)));
    }
}