<?php
/**
 +---------------------------------------------------------
 * 内存缓存
 +---------------------------------------------------------
 * @name      CacheMem.class.php
 * @copyright http://www.97md.net 
 * @access    MyDream
 * @author    zxing@97md.net  Tue Aug 11 15:14:06 GMT+08:00 2009
 * @version   Tue Aug 11 15:14:06 GMT+08:00 2009
 +---------------------------------------------------------
 * @example
 * $mem = new CacheMem($_CONFIG['mem']);
 * $mem->saveCached(array('1','sdfsdf'),'zxing');
 * print_r( $mem->getCached('zxing'));
 */
defined('MyDream') or exit('Error: Access Denied!');

class CacheMem extends CacheBase implements CacheInterfice{
    private $_memcached = null;
    private $_result_cache = null;
    private $_id  = false;
    /**
     +-----------------------------------------------------
     * 构造函数
     * @access public
     * @param String $array
     * @return Void
     * @author zxing@97md.net Tue Aug 11 15:22:33 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function __construct(){
        if ( empty( $_MEM ) ){
            global $_CONFIG;
            $_MEM = new memcached($_CONFIG['mem']);
        }
        $this->_memcached = $_MEM;
        parent::__construct();
    }
    /**
     +-----------------------------------------------------
     * 尝试从内存中读取缓存信息
     * @access public
     * @param String $array
     * @return Void
     * @author zxing@97md.net Tue Aug 11 15:22:33 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function isCached($key,$time_out=3600){
        $this->_id = $this->getId($key);
        $this->time_out = $time_out;
        $this->_result_cache = $this->_memcached->get($this->_id);
        if ($this->_result_cache!==false){
            return true;
        }else{
            return false;
        }
    }
    /**
     +-----------------------------------------------------
     * 读取缓存信息
     * @access public
     * @param String $array
     * @return Void
     * @author zxing@97md.net Tue Aug 11 15:22:33 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function getCached($key=null){
        if (!empty($key)){
            $this->_id = $this->getId($key);
            return $this->_memcached->get($this->_id);
        }elseif ($this->_result_cache !== false){
            return $this->_result_cache;
        }else{
            return $this->_memcached->get($this->_id);
        }
    }
    /**
     +-----------------------------------------------------
     * 写入或更新内存中的缓存信息
     * @access public
     * @param String $array
     * @return Void
     * @author zxing@97md.net Tue Aug 11 15:22:33 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function saveCached($var,$key=null){
        if (!empty($key)){
            $this->_id = $this->getId($key);
        }
        if (!$this->_memcached->add($this->_id, $var,$this->time_out)){
            $this->_memcached->replace($this->_id, $var,$this->time_out);
        }
    }
     /**
     +-----------------------------------------------------
     * 删除缓存文件
     * @access public
     * @param  String $key=null
     * @return Void
     * @author zxing 2010-04-07 00:55:06
     +-----------------------------------------------------
     * @example
     */
    public function deleteCache($key=null) {
        if (!empty($key)) {
            $this->getId($key);
        }
        $sql = 'DELETE * FROM `' . $this->_table . '`
            WHERE `key`=\''.$this->cache_id.'\';';
        $this->_db->query($sql);
        return TRUE;
    }
    /**
     +-----------------------------------------------------
     * getCacheName--得到缓存键名
     * @access public
     * @param  $key=null
     * @return String
     * @author zxing@97md.net 2010-06-14 23:38:05
     +-----------------------------------------------------
     * @example
     */
    public function getCacheName($key=null) {
       if (!empty($key)) {
            $this->getId($key);
        }
        return $this->cache_id;
    }
}