<?php
/**
 +-----------------------------------------------------
 * 取得表单变量
 +-----------------------------------------------------
 * @name      Input.class.php
 * @copyright http://www.97md.net 
 * @access    MyDream
 * @author    zxing  Thu Jul 09 02:26:17 GMT+08:00 2009
 * @version   Thu Jul 09 02:26:17 GMT+08:00 2009
 +-----------------------------------------------------
 */
defined('MyDream') or exit('Error: Access Denied!');

class Input {
    private $_get = array();
    private $_post = array();
    /**
     +-----------------------------------------------------
     * 析构函数
     * @access public
     * @author zxing Thu Jul 09 02:44:25 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function __destruct(){
        unset($this->_get,$this->_post);
    }
    /**
     +-----------------------------------------------------
     * 取得 GET 变量
     * @access public
     * @param String $key 变量名
     * @param String $filter 过滤器名称
     * @return $value
     * @author zxing Thu Jul 09 02:36:04 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function get($key,$filter=''){
        $result = false;
        if (isset($this->_get[$key])){
            $result = $this->_get[$key];
        }elseif (isset($_GET[$key])){
            $result = $_GET[$key];
            if (!empty($filter)){
                $this->Filter($result,$filter);
            }
            $this->_get[$key] = $result;
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * 取得 POST 数据
     * @access public
     * @param String $key 变量名
     * @param String $filter 过滤器名称
     * @return $value
     * @author zxing Thu Jul 09 02:37:43 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function post($key,$filter=''){
        $result = false;
        if (isset($this->_post[$key])){
            $result = $this->_post[$key];
        }elseif (isset($_POST[$key])){
            $result = $_POST[$key];
            if (!empty($filter)){
                $this->Filter($result,$filter);
            }
            $this->_post[$key] = $result;
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * 变量过滤器入口函数
     * @access private
     * @param  $value  变量值
     * @param String $check_type 变量类型【,,,,,,】
     * @return $value
     * @author zxing Thu Jul 09 02:32:11 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    private function Filter(&$value,$check_type){
        $actions = explode(',',$check_type);
        // 逐个执行检查
        foreach ($actions as $key=>$fun){
            $function = 'Filter_'.$fun;
            if (method_exists($this,$function)){
                $this->$function($value);
            }
        }
    }
    
}
