<?php
/**
 * MyDream 异常处理类
 * @name      MDException.class.php
 * @copyright http://www.97md.net 
 * @access    MyDream
 * @author    zxing  Wed Jul 08 01:11:35 GMT+08:00 2009
 * @version   Wed Jul 08 01:11:35 GMT+08:00 2009
 */
defined('MyDream') or exit('Error: Access Denied!');

class MDException extends Exception {
    /**
     +-----------------------------------------------------
     * 直接显示错误信息
     * @access public
     * @param object $control_obj
     * @return Void
     * @author zxing@97md.net Tue Oct 13 23:27:53 CST 2009
     +-----------------------------------------------------
     * @example
     * 此函数只能用于控制器类函数内部 
     * try {
     *      throw new MDException('异常测试');
     * }catch (MDException $e){
     *      $e->Display($this);
     * }
     */
    public function Display(&$control_obj){
        ob_clean();
        if (get_parent_class($control_obj) != 'ControlBase'){
            echo '<p><center>',$this->getMessage(),'</center></p>';
        }else{
            $msg = array('msg'=>$this->getMessage(),'title'=>'Application Exception');
            $control_obj->view->Show('/ShowMsg',$msg);
        }
    }
}