<?php
/**
 * MD的URL处理函数库
 * @name      MDUrl.class.php
 * @copyright http://www.97md.net
 * @access    97MD
 * @author    zxing  Mon Jun 08 22:02:49 GMT+08:00 2009
 * @version   Mon Jun 08 22:02:49 GMT+08:00 2009
 * 支持三种方式的URL转发处理
 * 1 GET index.php?C=控制器&A=动作&P=参数
 * 2 URI index.php/{C}/{A}/{P}
 * 3 URL index.php?S=/{C}/{A}/{P}
 */
defined('MyDream') or exit('Error: Access Denied!');

class MDUrl {
    public static $C    = null;// C 控制器
    public static $A    = null;// A 动作
    public static $P    = null;// P 参数
    public static $page = array();// 分页参数
    /**
     * 构造函数用来接收URL传来的参数
     * @name __construct
     * @param Void
     * @return Void
     * @author zxing Mon Jun 08 22:10:45 GMT+08:00 2009
     * @version  Mon Jun 08 22:10:45 GMT+08:00 2009
     * @example
     */
    function __construct() {
        $get_controlle = false;
        if (!empty($_GET['C'])) {
            $get_controlle = true;
            self::$C = $_GET['C'];
            if (!empty($_GET['A'])) self::$C = $_GET['A'];
            if (!empty($_GET['P'])) self::$C = $_GET['P'];
        }
        $request_uri = ''; // 用来传递参数的 URI
        if (!empty($_GET['S']) && !$get_controlle) {
            $request_uri = $_GET['S'];
        }else {
            $get_url = $_SERVER['REQUEST_URI'];
            $file_url = $_SERVER['SCRIPT_NAME'];
            // 这里增加了对 apache URL转发的支持
            if (function_exists('apache_lookup_uri')) { // php module 方式运行时
                $info = apache_lookup_uri($_SERVER['PHP_SELF']);
                if (isset($info)&&substr($get_url,0,strlen($_SERVER['SCRIPT_NAME']))!=$_SERVER['SCRIPT_NAME']) {
                    $get_url = $_SERVER['SCRIPT_NAME'].$_SERVER['REQUEST_URI'];
                }
                $request_uri = substr($get_url,strlen($file_url));
            }else {  // fcgi 方式运行时
                $request_uri = $get_url;
            }
            // 截取 ? 前面的内容
            if (strstr($request_uri,'?')) {
                $request_uri = substr($request_uri,0,strpos($request_uri,'?')) ;
            }
        }
        if (!empty($request_uri)) {
            // 处理前后的 Slash(/)
            if (substr($request_uri,0,1)=='/') $request_uri = substr($request_uri,1);
            if (substr($request_uri,-1)=='/') $request_uri = substr($request_uri,0,-1);
            // 拆分URL到各个模块中
            $array_tmp = explode('/',$request_uri);
            $array     = array();
            // 将分页参数从 URL里面过滤出去
            foreach ($array_tmp as $key=>$value) {
                if (substr($value,-7)!='-p.html') {
                    $array[] = $value;
                    unset($array_tmp[$key]);
                }
                if (count($array)==2) break;
            }
            if (!empty($array[0])) {
                self::$C = $array[0];
            }
            if (!empty($array[1])) {
                self::$A = $array[1];
            }
            // 把不包含 C A 两部分的参数还原为原来的状态
            self::$P = implode('/',$array_tmp);
        }
        unset($get_controlle,$request_uri,$get_url,$file_url,$array);
        self::GetPagings();
    }
    /**
     * 得到分页参数
     * @name GetPagings
     * @param Void
     * @return String
     * @author zxing Wed Jun 17 06:45:08 GMT+08:00 2009
     * @version  Wed Jun 17 06:45:08 GMT+08:00 2009
     * @example
     */
    private static  function GetPagings() {
        self::$page = array();
        // 分页可以包含在GET变量中
        foreach ($_GET as $key=>$value){
            if (substr($key,0,4) == 'page'){
                $key = substr($key,4);
                self::$page[$key] = intval($value);
            }
        }
        // 如果 URI 以 -p.html 结尾则可能包含分页参数 处理之
        // 注意在这里 /page1-85-p.html 这个的优先级要比 ?page2=5 高
        // 如果用两个参数给出了page1那么读取到的是 -p.html 所传的值
        if (substr($_SERVER['REQUEST_URI'],-7) == '-p.html'){
            $get_values = substr($_SERVER['REQUEST_URI'],strrpos($_SERVER['REQUEST_URI'],'/')+1,-7);
            $get_values = explode('-',$get_values);
            for ($i=0;$i<count($get_values);$i+=2){
                if ( substr($get_values[$i],0,4) == 'page'){
                    self::$page[substr($get_values[$i],4)] = intval($get_values[$i+1]);
                }
            }
        }
        return self::$page;
    }
    /**
     * 得到不包含分页参数的URL
     * @name GetPagingBaseURL
     * @param Int $pagegroup 分页分组
     * @param Int $page 分页数
     * @return String
     * @author zxing Wed Jun 17 07:32:26 GMT+08:00 2009
     * @version  Wed Jun 17 07:32:26 GMT+08:00 2009
     * @example
     */
    public function GetPagingLink($pagegroup=1,$page=1) {
        $result    = $_SERVER['SCRIPT_NAME'].'/'.self::$C.'/'.self::$A.'/';
        $p_key     = 'page'.$pagegroup;
        $p_array   = explode('/',self::$P);
        $get_group = false;
        foreach ($p_array as $key=>$value) {
            if ($value==$p_key) {
                $get_group = $value.'/'.$p_array[$key+1];
                break;
            }
        }
        $result .= self::$P;
        if ($get_group) {
            $result = str_replace($get_group,$p_key.'/'.$page,$result);
        }else {
            $result .= '/'.$p_key.'/'.$page;
        }
        $result = str_replace('//','/',$result);
        $result = str_replace('//','/',$result);
        $result =  str_replace('//','/',$result);
        return $result;
    }
}