<?php
/**
 * MyDream 基础类
 * @name      MyDream.class.php
 * @copyright http://www.97md.net 
 * @access    MyDream
 * @author    zxing  Sun Jul 05 04:22:47 GMT+08:00 2009
 * @version   Sun Jul 05 04:22:47 GMT+08:00 2009
 */
defined('MyDream') or exit('Error: Access Denied!');

class MyDream {
    public static $class_array = array();// 框架包含的类库列表
    /**
     * 载入MD中类库名称
     * @name loadClass
     * @param Void
     * @return Array 包含类库中所有类名称的数组
     * @author zxing Mon Jun 08 20:52:57 GMT+08:00 2009
     * @version  Mon Jun 08 20:52:57 GMT+08:00 2009
     * @example 
     */
    public static function loadClass(){ // 载入系统类库列表
        global $_CONFIG;
        $class_cache_file = MD_ROOT.DATA_ROOT.'/MyDreamLibs.cache';
        if ($_CONFIG['libcache'] && file_exists($class_cache_file)){
            self::$class_array = unserialize(file_get_contents($class_cache_file));
        }else{
            // 递归列出全部类库
            self::_loadClass(MD_ROOT.LIB_ROOT);
            if ($_CONFIG['libcache']){
                $handle = fopen($class_cache_file,'w+');
                fwrite($handle,serialize(self::$class_array));
                fclose($handle);
            }
        }
    }
    /**
     * 递归的检索所有类库
     * @name _loadClass
     * @param String $libs_root 类库目录
     * @return Array 类名为索引路径为值的类库
     * @author zxing Mon Jun 08 20:56:11 GMT+08:00 2009
     * @version  Mon Jun 08 20:56:11 GMT+08:00 2009
     * @example 
     */
    private static function _loadClass( $libs_root ){
        if (!file_exists($libs_root)) return false;
        $array = glob( $libs_root.'/*' );
        if (is_array($array)){
            foreach($array as $item){
                $item = str_replace('\\','/',$item);
                if(is_dir($item)){
                    call_user_func(array(__CLASS__,__FUNCTION__),$item);
                }else{
                    $key = substr($item,strrpos($item,'/')+1,-10);
                    if (substr($key,0,1)!='_') self::$class_array[$key] = realpath($item);
                }
            }
        }
    }
}
/**
 +-----------------------------------------------------
 * __autoload--自动载入类
 * @access public
 * @param String $class_name 类名
 * @return Boolen
 * @author zxing@97md.net 2010-05-13 23:57:46
 +-----------------------------------------------------
 * @example 无需程序员调用
 */
function __autoload($class_name){
    if (empty(MyDream::$class_array)) MyDream::loadClass();
    if (key_exists($class_name,MyDream::$class_array)){
        require_once(MyDream::$class_array[$class_name]);
        return true;
    }else return false;
}