<?php
/**
 +---------------------------------------------------------
 * 数据库抽象层
 +---------------------------------------------------------
 * @name      DB.class.php
 * @copyright http://www.97md.net 
 * @access    MyDream
 * @author    zxing@97md.net  Fri Jul 31 22:19:33 GMT+08:00 2009
 * @version   Fri Jul 31 22:19:33 GMT+08:00 2009
 +---------------------------------------------------------
 * @example
 * 可以管理多个数据库链接，并且支持永久链接
 */
defined('MyDream') or exit('Error: Access Denied!');

class DB implements  DBInterface  {
    public  $result_array;
    private $_dsn  = array();
    private $_link = null;
    private $_is_select = false;
    private $_last_sql  = '';
    /**
     +-----------------------------------------------------
     * 构造函数用来发起链接
     * @access public
     * @param Array $dsn
     * @return Void
     * @author zxing@97md.net Sat Aug 01 12:35:44 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */ 
    public function __construct($dsn){
        $_dsn = array();
        $_dsn['driver']    = 'mysql';     // 使用的链接驱动
        $_dsn['server']    = 'localhost'; // 数据库服务器名
        $_dsn['port']      = '3306';      // 链接端口
        $_dsn['user']      = 'root';      // 用户名
        $_dsn['pass']      = '';          // 密码
        $_dsn['prefix']    = '';          // 名称替换符字符串，SQL语句中的字符串 @__#  将被替换成这个变量的值
        $_dsn['database']  = 'test';      // 数据库名
        $_dsn['charset']   = 'utf8';      // 链接编码
        $_dsn['pconnect']  = false;       // 是否使用永久链接
        $this->_dsn = array_merge($_dsn,$dsn);
        $driver_class = 'DBDriver'.$this->_dsn['driver'];
        // 检查数据库驱动类是否存在
        if (!class_exists($driver_class)){
            $driver_file = dirname(__FILE__).'/Drivers/'.$this->_dsn['driver'].'.driver.php';
            if (is_file($driver_file) && file_exists($driver_file)) {
                require($driver_file);
            }else{
                throw new MDException('数据库错误，数据库驱动 '.$this->_dsn['driver'].' 不存在！');
            }
        }
        $this->_link = new $driver_class($this->_dsn);
    }
    /**
     +-----------------------------------------------------
     * 执行一条SQL查询
     * @access public
     * @param String $sql
     * @return Void
     * @author zxing@97md.net Mon Aug 03 22:00:22 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function query($sql){
        $result = false;
        try {
            // 检查sql语句并处理
            $this->_last_sql = $this->_CheckSQL($sql,$is_select);
            $result = $this->_link->query($this->_last_sql);
            if ($is_select){
                $this->fetchArray();
            }
            $_ENV['query'] ++;
        }catch (Exception $e){
            throw new MDException('数据库查询错误:'.$this->getError().'<font color="Red">'.$this->_last_sql.'</font>');
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * 对于SELECT 类型的查询执行向后滚动结果集操作
     * @access public
     * @param Void
     * @return Boolen
     * @author zxing@97md.net Mon Aug 03 22:08:38 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function fetchArray(){
        $result = $this->_link->fetchArray();
        $this->result_array = $this->_link->result_array;
        return $result;
    }
    /**
     +-----------------------------------------------------
     * 得到最近发生的一条错误
     * @access public
     * @param Void
     * @return String
     * @author zxing@97md.net Mon Aug 03 22:16:55 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function getError(){        
        return $this->_link->getError();
    }
    // 取得上次执行的SQL语句
    public function getLastSql(){
        return $this->_last_sql;
    }
    /**
     +-----------------------------------------------------
     * 得到结果行数
     * @access public
     * @param  Void
     * @return Int
     * @author zxing@97md.net Mon Aug 03 22:17:55 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function getNumRows(){
        return $this->_link->getNumRows();
    }
    /**
     +-----------------------------------------------------
     * 得到上次插入的ID
     * @access public
     * @param Void
     * @return Int
     * @author zxing@97md.net Mon Aug 03 22:21:07 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function getInsertId(){
        return $this->_link->getInsertId();
    }
    /**
     +-----------------------------------------------------
     * 得到上次SQL语句影响的列数
     * @access public
     * @param Void
     * @return Int
     * @author zxing@97md.net Mon Aug 03 22:21:07 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function getAffectedRows(){
        return $this->_link->getAffectedRows();
    }
    /**
     +-----------------------------------------------------
     * 清理数据准备下一次查询
     * @access public
     * @param Void
     * @return Void
     * @author zxing@97md.net Mon Aug 03 22:21:07 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function clean(){
        return $this->_link->clean();
    }
    /**
     +-----------------------------------------------------
     * 事务回滚
     * @access public
     * @param Void
     * @return boolen
     * @author zxing@97md.net Mon Aug 03 22:21:07 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    // 事务开始
    public function beginTransaction(){
        return $this->_link->beginTransaction();
    }
    /**
     +-----------------------------------------------------
     * 事务回滚
     * @access public
     * @param Void
     * @return boolen
     * @author zxing@97md.net Mon Aug 03 22:21:07 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function rollBack(){
        return $this->_link->rollBack();
    }
    /**
     +-----------------------------------------------------
     * 事务提交
     * @access public
     * @param Void
     * @return boolen
     * @author zxing@97md.net Mon Aug 03 22:21:07 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function commit(){
        return $this->_link->commit();
    }
    /**
     +-----------------------------------------------------
     * 检查SQL语句
     * @access private
     * @param String $sql 要处理的SQL语句 &$is_select 是否SELECT类型的查询
     * @return Void
     * @author zxing@97md.net Mon Aug 03 21:53:34 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    private function _CheckSQL($sql,&$is_select){
        $sql = trim($sql);
        if (strtolower(substr($sql,0,6))=='select' || strtolower(substr($sql,0,4))=='show' ){
            $is_select = true;
        }else{
            $is_select = false;
        }
        $sql = str_replace('@__#',$this->_dsn['prefix'],$sql);
        return $sql;
    }
}