<?php
/**
 +---------------------------------------------------------
 * 数据库驱动接口
 +---------------------------------------------------------
 * @name      DBDriverInterface.class.php
 * @copyright http://www.97md.net 
 * @access    MyDream
 * @author    zxing@97md.net  Sat Aug 01 12:34:10 GMT+08:00 2009
 * @version   Sat Aug 01 12:34:10 GMT+08:00 2009
 +---------------------------------------------------------
 * @example
 * 数据库驱动类基类，其中规定了所有数据库驱动类应该包含的方法以及需要付予的参数
 * 数据库驱动类 文件必须放在 /Libs/Db/Drivers 目录下  命名为 {$dirver}.dirver.php
 * 数据库驱动类 名应为 DBDriver{$driver}
 */
defined('MyDream') or exit('Error: Access Denied!');

interface DBDriverInterface {
    // 构造函数用来发起链接
    public function __construct($dsn);
    // 执行一条SQL查询
    public function query($sql);
    // 对于SELECT 类型的查询执行回滚操作
    public function fetchArray();
    // 得到最近发生的一条错误
    public function getError();
    // 得到结果行数
    public function getNumRows();
    // 得到上次插入的ID
    public function getInsertId();
    // 得到上次SQL语句影响的列数
    public function getAffectedRows();    
    // 清理数据准备下一次查询
    public function clean();
    // 事务开始
    public function beginTransaction();
    // 事务回滚
    public function rollBack();
    // 事务提交
    public function commit();
}
