<?php
/**
 +---------------------------------------------------------
 * 数据库异常类 处理数据库查询错误信息
 +---------------------------------------------------------
 * @name      DBException.class.php
 * @copyright http://www.97md.net 
 * @access    MyDream
 * @author    zxing@97md.net  Tue Oct 27 16:07:13 CST 2009
 * @version   Tue Oct 27 16:07:13 CST 2009
 +---------------------------------------------------------
 * @example
 */
defined('MyDream') or exit('Error: Access Denied!');

class DBException extends Exception {
    /**
     +-----------------------------------------------------
     * 
     * @access public
     * @param String $INDEX2
     * @return Void
     * @author zxing@97md.net Tue Oct 27 16:11:01 CST 2009
     +-----------------------------------------------------
     * @example
     */
    public function __construct($sql,$message='',$code=0){
        if (empty($message)){
            $message = $sql;
        }else{
            $message = '<p><b>'.$message.'</b></p><p>'.$sql.'</p>';
        }
        parent::__construct($message,$code);
    }
    /**
     +-----------------------------------------------------
     * 直接显示错误信息
     * @access public
     * @param object $control_obj
     * @return Void
     * @author zxing@97md.net Tue Oct 27 16:09:52 CST 2009
     +-----------------------------------------------------
     * @example
     * 此函数只能用于控制器类函数内部 
     * try {
     *      throw new DBException('异常测试');
     * }catch (MDException $e){
     *      $e->Display($this);
     * }
     */
    public function Display(&$control_obj){
        ob_clean();
        if (get_parent_class($control_obj) != 'ControlBase'){
            echo '<p><center>',$this->getMessage(),'</center></p>';
        }else{
            $msg = array('msg'=>$this->getMessage(),'title'=>'数据库异常');
            $control_obj->view->Show('/ShowMsg',$msg);
        }
    }
}