<?php
/**
 +---------------------------------------------------------
 * 数据库操作类接口
 +---------------------------------------------------------
 * @name      DBInterface.class.php
 * @copyright http://www.97md.net 
 * @access    MyDream
 * @author    zxing@97md.net  Sat Aug 01 12:33:48 GMT+08:00 2009
 * @version   Sat Aug 01 12:33:48 GMT+08:00 2009
 +---------------------------------------------------------
 * @example
 */
defined('MyDream') or exit('Error: Access Denied!');

interface DBInterface {
    // 构造函数用来发起链接
    public function __construct($dsn);
    // 执行一条SQL查询
    public function query($sql);
    // 对于SELECT 类型的查询执行回滚操作
    public function fetchArray();
    // 得到最近发生的一条错误
    public function getError();
    // 得到结果行数
    public function getNumRows();
    // 得到上次插入的ID
    public function getInsertId();
    // 得到上次SQL语句影响的列数
    public function getAffectedRows();    
    // 清理数据准备下一次查询
    public function clean();
    // 事务开始
    public function beginTransaction();
    // 事务回滚
    public function rollBack();
    // 事务提交
    public function commit();
}