<?php
/**
 +---------------------------------------------------------
 * 分页类 继承自数据库操作类
 +---------------------------------------------------------
 * @name      DBPaging.class.php
 * @copyright http://www.97md.net 
 * @access    MyDream
 * @author    zxing@97md.net  Sat Aug 15 16:47:43 GMT+08:00 2009
 * @version   Sat Aug 15 16:47:43 GMT+08:00 2009
 +---------------------------------------------------------
 * @example
 * 1、本类继承自数据库类拥有数据库类的所有方法，但执行的SQL语句仅限于 SELECT 。
 * 2、注意分页链接是从 1 开始的，不是 0 ！
 */
defined('MyDream') or exit('Error: Access Denied!');

class DBPaging extends DB {
    public
    $num_total,     // 总条数
    $num_limit,     // 最大分页条数
    $page_limit,    // 最多显示的页数
    $page_begin,    // 从第几页开始显示
    $page_end,      // 要显示的最后一夜
    $page_now,      // 当前分页
    $page_total,    // 总页数
    $base_url;      // 静态页面的URL
    private
    $_is_cache,      // 是否缓存查询信息
    $_is_select,    // 是否查询操作
    $_get_key,      // GET 键名
    $_link_type,    // 分页样式
    $_SQL_limit,    // 最终查询用的SQL语句
    $_total_num;    // 总计条数
    private static
    $_page = 0;     // 当前分页索引
    /**
     * 发起链接请求
     * @name __construct
     * @param  String $link_key 链接索引 ; int $num_limit 最大显示的条数
     * @return Boolen
     * @author zxing Mon Feb 02 09:35:25 CST 2009
     * @version  Mon Feb 02 09:35:25 CST 2009
     * @example 
     */
    public function __construct($dsn , $num_limit=20){
        // 当前最大分页数
        $this->num_limit = (int)$num_limit;
        // 发起数据库链接请求
        parent::__construct($dsn);
        // 得到当前类监听的分页变量名称
        self::$_page++;
        $this->_get_key = 'page'.self::$_page;
        // 得到当前的页数
        $this->page_now = (isset(MDUrl::$page['page'.self::$_page])&&(MDUrl::$page['page'.self::$_page])>1)?MDUrl::$page['page'.self::$_page]:1;
    }
    /**
	 * 送出查询
	 * @name query
	 * @param String 
	 * @return Boolen
	 * @author zxing Fri Feb 06 09:16:11 CST 2009
	 * @version  Fri Feb 06 09:16:11 CST 2009
	 * @example 
	 */
    public function query($SQL){
        $SQL = trim($SQL);
        // 得到总记录数
        $this->num_total = $this->_getTotal($SQL);
        // 得到Limit处理过的SQL语句，用来查询当前页数据
        $this->_SQL_limit = $this->_getLimitSQL($SQL,$this->num_limit,$this->page_now);
        // 查询数据返回结果
        return parent::query($this->_SQL_limit);
    }
    /**
	  * 设置分页样式
	  * @name setLinkType
	  * @param String LinkType
	  * @return Boolen
	  * @author zxing Fri Feb 06 09:21:32 CST 2009
	  * @version  Fri Feb 06 09:21:32 CST 2009
	  * @example 
	  */
    public function setLinkType(){
        $result = false;
        if (func_num_args()){
            // 设置分页条数
            $this->page_limit = func_get_arg(0);
            $this->page_limit = (int)$this->page_limit;
            // 设置显示内容
            for ($i=1;$i<func_num_args();$i++){
                $this->_link_type .= func_get_arg($i).';';
            }
        }else{
            // 默认显示内容
            if (empty($this->page_limit)){
                $this->page_limit = 10;
            }
            $this->_link_type = 'top;next;stat;';
        }
        $this->_link_type = strtolower($this->_link_type);
        return $result;
    }
    /**
	  * 得到分页链接
	  * @name getPageLink
	  * @param  Void
	  * @return String
	  * @author zxing Fri Feb 06 09:20:56 CST 2009
	  * @version  Fri Feb 06 09:20:56 CST 2009
	  * @example 
	  */
    public function getPageLink(){
        $result = false;
        // 计算总页数
        if ($this->num_total>0){
            $this->page_total = ceil($this->num_total/$this->num_limit);
        }else{
            $this->page_total = 0;
        }
        // 取得默认分页链接样式
        if (empty($this->_link_type)){
            $this->setLinkType();
        }
        // 计算最前面的页
        if ( $this->page_total <= $this->page_limit ){
            $this->page_begin = 1;
            $this->page_end = $this->page_total;
        }else{
            // 将当前页放置于中间位置
            $half = floor(($this->page_limit)/2);
            $surplus = $this->page_limit - $half - 1 ;
            $this->page_begin = $this->page_now - $half;
            $this->page_end = $this->page_now + $surplus;
            // -- 检查前面部分
            if ($this->page_begin<1){
                $this->page_begin = 1;
                $this->page_end = $this->page_limit;
            }
            // -- 检查后面部分
            if ( $this->page_end > $this->page_total ){
                $this->page_begin = $this->page_total - $this->page_limit + 1 ;
                $this->page_end = $this->page_total;
            }
        }
        // 检查链接内容
        $setting = $this->_checkLinks();
        // 组合分页链接HTML
        $result = '<div class="page_turner">';
        if ($setting['first']){
            // 首页
            $result .= '<a href="'.$this->_getHref(1).'"  target="_self"  title="第一页">首页</a>';
        }
        // 分页内容
        for ($i=$this->page_begin;$i<=$this->page_end;$i++){
            $result .= '<a href="'.$this->_getHref($i).'" '.(($i == $this->page_now)?' class="c" ':'').'  target="_self"  title="第'.$i.'页">'.$i.'</a>';
        }
        if ($setting['last']){
            // 尾页
            $result .= '<a href="'.$this->_getHref($this->page_total).'"  target="_self"  title="最后一页">尾页</a>';
        }
        if ($setting['prior']){
            // 上一页
            $result .= '<a href="'.$this->_getHref($this->page_now-1).'"  target="_self" title="上一页">&#8249;&#8249;</a>';
        }
        if ($setting['next']){
            // 下一页
            $result .= '<a href="'.$this->_getHref($this->page_now+1).'"  target="_self"  title="下一页">&#8250;&#8250;</a>';
        }
        if ($setting['stat']){
            // 详细信息
            $result .= '<span>'.$this->page_now.'<cite>/</cite>'.$this->page_total.'页&nbsp;共<label id="total">'.$this->num_total.'</label>条</span>';
        }
        $result .= '</div>';
        return $result;
    }
    /**
	 * 得到最大条数
	 * @name _getTotal
	 * @param String $SQL
	 * @return Int
	 * @author zxing Fri Feb 06 09:14:51 CST 2009
	 * @version  Fri Feb 06 09:14:51 CST 2009
	 * @example 
	 */
    public  function _getTotal($SQL){
        $result = 0;
        $sqlmd5 = md5($SQL);
        $cache = new CacheFile(__CLASS__);
        if ($cache->isCached(__FUNCTION__.'::'.$sqlmd5,3600*6)){
            $result = $cache->getCached();
        }else{
            // 整理SQL
            $sql_type = strtolower(substr($SQL,0,6));
            // 查询总计条数
            if ('select' == $sql_type){
                $this->_is_select = true;
                $countsql = 'SELECT COUNT(*) AS allnums ';
                $countsql .= substr($SQL,strpos($SQL,'FROM')?strpos($SQL,'FROM'):strpos($SQL,'from'));
                if (parent::query($countsql)){
                    $result = (int)$this->result_array['allnums'];
                }
            }else{
                $this->_is_select = false;
            }
            $cache->saveCached($result);
        }
        return $result;
    }
    /**
	  * 得到分页对应SQL
	  * @name _getLimitSQL
	  * @param String 
	  * @return Boolen
	  * @author zxing Fri Feb 06 09:33:05 CST 2009
	  * @version  Fri Feb 06 09:33:05 CST 2009
	  * @example 
	  */
    private function _getLimitSQL($SQL,$num_limit,$page_now){
        $result = false;
        // 整理 Limit 限制串
        $limit_one = $num_limit*($page_now-1)-1;
        if ($limit_one<0){
            $limit_one = 0;
        }
        $limit = ' LIMIT '.$limit_one.' , '.$num_limit.' ;';
        // 拼装成正式查询用的SQL语句
        if (substr($SQL,strlen($SQL)-1) == ';'){
            $result = substr($SQL,0,strlen($SQL)-1);
        }else{
            $result = $SQL;
        }
        $result .= $limit;
        return $result;
    }
    /**
	 * 检查要显示的链接信息
	 * @name _checkLinks
	 * @param String 
	 * @return Boolen
	 * @author zxing Fri Feb 06 16:11:46 CST 2009
	 * @version  Fri Feb 06 16:11:46 CST 2009
	 * @example 
	 */
    private function _checkLinks(){
        $result = array(
        'stat'  => false,       // 相信信息
        'first' => false,       // 首页
        'last'  => false,       // 尾页
        'prior' => false,       // 上一页
        'next'  => false,       // 下一页
        );
        $link_type = explode(';',$this->_link_type);
        // 是否显示分页链接
        if ($this->num_total>0){
            // 是否显示首页尾页
            if (in_array('top',$link_type)){
                // 不从第一页开始时才显示 首页
                if ($this->page_begin>1){
                    $result['first'] = true;
                }
                // 不显示最后一页时才显示 尾页
                if ($this->page_begin+$this->page_limit<$this->page_total){
                    $result['last'] = true;
                }
            }
            // 是否显示上一页下一页
            if (in_array('next',$link_type)){
                // 当前页 不是第一页 的时候才显示上一页
                if ($this->page_now >1){
                    $result['prior'] = true;
                }
                // 当前页 不是最后一页 的时候才显示下一页
                if ($this->page_now < $this->page_total){
                    $result['next'] = true;
                }
            }
            // 是否显示相信信息
            if (in_array('stat',$link_type)){
                $result['stat'] = true;
            }
        }
        return $result;
    }
    /**
	 * 得到HREF链接
	 * @name _getHref
	 * @param Int $page_num 页数
	 * @return String
	 * @author zxing Sat Feb 07 10:41:45 CST 2009
	 * @version  Sat Feb 07 10:41:45 CST 2009
	 * @example 
	 */
    function _getHref($page_num){
        // 一个对象仅执行一次取根URL的操作
        return MDUrl::GetPagingLink(substr($this->_get_key,4),$page_num);
    }
}