<?php
/**
 +---------------------------------------------------------
 * MySql拓展的数据库驱动类
 +---------------------------------------------------------
 * @name      mysql.driver.php
 * @copyright http://www.97md.net 
 * @access    MyDream
 * @author    zxing@97md.net  Sat Aug 01 15:23:57 GMT+08:00 2009
 * @version   Sat Aug 01 15:23:57 GMT+08:00 2009
 +---------------------------------------------------------
 * @example
 */
defined('MyDream') or exit('Error: Access Denied!');

class DBDrivermysql implements DBDriverInterface {
    public  $result_array;//查询结果行
    private $_link;    // 数据库链接
    private $_dsn;     // 数据库链接参数
    private $_result;  // 查询结果
    private $_result_now;  // 记录当前结果行数
    private $_fetch_jump;  // fetchArray 时是否需要条行
    /**
     +-----------------------------------------------------
     * 构造函数，用来链接数据库
     * @access public
     * @param Array $dsn 数据库链接参数
     * @return Void
     * @author zxing@97md.net Sat Aug 01 15:23:57 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function __construct($dsn){
        // 检查拓展是否已经载入
        if(!function_exists('mysql_connect')){
            throw new MDException('MySQL模块未载入！');
        }
        // 检查DSN信息完整性
        $this->_dsn = $dsn;
        if (empty($dsn['server'])){
            throw new MDException('数据库配置错误，服务器IP为空！');
        }
        if (empty($dsn['database'])){
            throw new MDException('数据库配置错误，数据库名为空！');
        }
        // 创建链接
        if (!empty($dsn['port']) && $dsn['port']!='3306'){
            $this->_dsn['server'] = $dsn['server'].':'.$dsn['port'];
        }
        if ($this->_dsn['pconnect']){
            $this->_link = mysql_pconnect($this->_dsn['server'], $this->_dsn['user'], $this->_dsn['pass']);
        }else{
            $this->_link = mysql_connect($this->_dsn['server'], $this->_dsn['user'], $this->_dsn['pass'],true);
        }
        if (!$this->_link){
            throw new MDException(mysql_error());
        }
        // 选择数据库、指定操作编码
        if(mysql_select_db($this->_dsn['database'],$this->_link)){
            mysql_query('SET NAMES \''.$this->_dsn['charset'].'\';',$this->_link);
        }else {
            throw new MDException(mysql_error());
        }
    }
    public function __destruct(){ }
    /**
     +-----------------------------------------------------
     * 执行一条SQL查询
     * @access public
     * @param String $sql 用于送去查询的SQL语句
     * @return boolen
     * @author zxing@97md.net Sat Aug 01 15:23:57 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function query($sql){
        if (!mysql_ping($this->_link)){
            self::__construct($this->_dsn);
        }
        mysql_select_db($this->_dsn['database'],$this->_link);
        $this->_result = mysql_query($sql,$this->_link);
        $this->_fetch_jump =  true;
        $this->_result_now =  0;
        return $this->_result;
    }
    /**
     +-----------------------------------------------------
     * 对于SELECT 类型的查询执行回滚一行操作
     * @access public
     * @param Void
     * @return boolen
     * @author zxing@97md.net Sat Aug 01 15:23:57 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function fetchArray(){
        $result = false;
        if ($this->_result ){
            if ($this->_result_now == 1 && $this->_fetch_jump == true){
                $result = $this->result_array;
                $this->_fetch_jump = false;
            }elseif($this->_result_now < $this->getNumRows()){
                $this->result_array = mysql_fetch_assoc($this->_result);
                if ($this->result_array){
                    $result = $this->result_array;
                    $this->_result_now ++ ;
                }
            }
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * 得到最近发生的一条错误
     * @access public
     * @param Void
     * @return String
     * @author zxing@97md.net Sat Aug 01 15:23:57 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function getError(){
        return mysql_error();
    }
    /**
     +-----------------------------------------------------
     * 得到结果行数
     * @access public
     * @param Void
     * @return int
     * @author zxing@97md.net Sat Aug 01 15:23:57 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function getNumRows(){
        return mysql_num_rows($this->_result);
    }
    /**
     +-----------------------------------------------------
     * 得到上次插入的ID
     * @access public
     * @param Void
     * @return Int
     * @author zxing@97md.net Sat Aug 01 15:23:57 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function getInsertId(){
        return mysql_insert_id($this->_link);
    }
    /**
     +-----------------------------------------------------
     * 得到上次SQL语句影响的列数
     * @access public
     * @param Void
     * @return boolen
     * @author zxing@97md.net Sat Aug 01 15:23:57 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function getAffectedRows(){
        return mysql_affected_rows($this->_link);
    }
    /**
     +-----------------------------------------------------
     * 清理数据准备下一次查询
     * @access public
     * @param Void
     * @return boolen
     * @author zxing@97md.net Sat Aug 01 15:23:57 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function clean(){
        $this->_fetch_jump =  true;
        $this->_result_now =  0;
    }
    /**
     +-----------------------------------------------------
     * 事务开始
     * @access public
     * @param Void
     * @return boolen
     * @author zxing@97md.net Sat Aug 01 15:23:57 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function beginTransaction(){
        $this->query('BEGIN;');
        $this->query('SET AUTOCOMMIT=0;');
    }
    /**
     +-----------------------------------------------------
     * 事务回滚
     * @access public
     * @param void
     * @return boolen
     * @author zxing@97md.net Sat Aug 01 15:23:57 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function rollBack(){
        $this->query('ROLLBACK;');
    }
    /**
     +-----------------------------------------------------
     * 事务提交
     * @access public
     * @param Void
     * @return boolen
     * @author zxing@97md.net Sat Aug 01 15:23:57 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function commit(){
        $this->query('COMMIT;');
    }
}