<?php
/**
 * MD加密类
 * @name      MDEncrypt.class.php
 * @copyright http://www.97md.net 
 * @access    97MD
 * @author    zxing  Sun Jun 07 19:56:56 GMT+08:00 2009
 * @version   Sun Jun 07 19:56:56 GMT+08:00 2009
 * Zxing的加密算法，得到的结果中前三位为检校码位 后三位为随机偏移量位
 * 如果偏移量不同则得出的密文也不同因偏移量有三位则
 * 同一密码明文在密钥相同的条件下总共可出现100-999的899种结果
 * 因检校码和偏移量问题 密文会比明文多出几位
 */
defined('MyDream') or exit('Error: Access Denied!');

class MDEncrypt{
    /**
     +-----------------------------------------------------
     * 对一个字符串进行加密操作
     * @access public
     * @param String $data 明文
     * @param String $key  密钥
     * @return String 密文
     * @author zxing Thu Jul 09 02:19:57 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     * MDEncrypt::encode('明文');
     */    
    public static function encode($data,$key='MDEncrypt'){
        $result = '';
        $char_ascii = 0;
        $for_count = strlen($data);
        $key = md5($key);
        $char_code = 0;
        $lastkey = rand(100,999);
        for ($i=0;$i<32;$i++){
            $char_code += intval(substr($key,$i,1));
        }
        $char_code += $for_count;
        $char_code %= 360;
        $char_code = intval(10*sin($char_code));
        for ($i=0;$i<$for_count;$i++){
            $char_ascii = ord(substr($data,$i,1));
            $change = intval(tan($for_count+$i)*$lastkey);
            if ($i%4==3){
                $char_ascii += $char_code - $change;
            }elseif($i%4==2){
                $char_ascii -= $char_code + $change;
            }elseif($i%4==1){
                $char_ascii += $char_code + $change;
            }else{
                $char_ascii -= $change;
            }
            $result .= chr($char_ascii);
        }
        $result = base64_encode($result);
        $result .= $lastkey;
        $result = substr(md5($result),16,3).$result;
        return $result;
    }
    /**
     +-----------------------------------------------------
     * 对加密数据进行解密操作
     * @access public
     * @param String $data 密文
     * @param String $key  密钥
     * @return String 解密后的密码明文
     * @author zxing Thu Jul 09 02:19:57 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     * MDEncrypt::decode('密文');
     */
    public static function decode($data,$key='MDEncrypt'){
        $result = '';
        $char_ascii = 0;
        $lastkey = substr($data,strlen($data)-3);
        $data = base64_decode(substr($data,3,strlen($data)-6));
        $for_count = strlen($data);
        $key = md5($key);
        $char_code = 0;
        for ($i=0;$i<32;$i++){
            $char_code += intval(substr($key,$i,1));
        }
        $char_code += $for_count;
        $char_code %= 360;
        $char_code = intval(10*sin($char_code));
        for ($i=0;$i<$for_count;$i++){
            $char_ascii = ord(substr($data,$i,1));
            $change = intval(tan($for_count+$i)*$lastkey);
            if ($i%4==3){
                $char_ascii -= $char_code - $change;
            }elseif($i%4==2){
                $char_ascii += $char_code + $change;
            }elseif($i%4==1){
                $char_ascii -= $char_code + $change;
            }else{
                $char_ascii += $change;
            }
            $result .= chr($char_ascii);
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * 判断是否该模块的密码文本
     * @access public
     * @param String $code
     * @return Boolen
     * @author zxing Thu Jul 09 03:22:54 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public static function isEncode($code){
        $result = false;
        $key = substr($data,0,3);
        $data = substr($data,3);
        $lastkey = substr($data,strlen($data)-3);
        $check = substr(md5($data),16,3);
        if ($key==$check && is_numeric($lastkey)) {
            $result = true;
        }
        return $result;
    }
}