<?php
/**
 +---------------------------------------------------------
 * IP处理类
 +---------------------------------------------------------
 * @name      MDIP.class.php
 * @copyright http://www.97md.net 
 * @access    MyDream
 * @author    zxing@97md.net  Sun Jul 19 10:47:52 GMT+08:00 2009
 * @version   Sun Jul 19 10:47:52 GMT+08:00 2009
 +---------------------------------------------------------
 * @example
 */
defined('MyDream') or exit('Error: Access Denied!');

class MDIP {
    /**
     +-----------------------------------------------------
     * 取得客户端IP
     * @access public
     * @param  Void
     * @return String
     * @author zxing@97md.net Sun Jul 19 11:32:06 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public static function getIp() {
        if (isset ( $_SERVER ['HTTP_X_FORWARDED_FOR'] )) {
            $onlineip = $_SERVER ['HTTP_X_FORWARDED_FOR'];
        } elseif (isset ( $_SERVER ['HTTP_CLIENT_IP'] )) {
            $onlineip = $_SERVER ['HTTP_CLIENT_IP'];
        } else {
            $onlineip = $_SERVER ['REMOTE_ADDR'];
            $c_agentip = 0;
        }
        $onlineip = preg_match ( '/^([0-9]{1,3}\.){3}[0-9]{1,3}$/', $onlineip ) ? $onlineip : 'Unknown';
        return $onlineip;
    }
    /**
     +-----------------------------------------------------
     * 将字符串描述的IP地址转换成无符号的整形
     * @access public
     * @param String $ip
     * @return int
     * @author zxing@97md.net Sun Jul 19 12:12:45 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public static function ip2num($ip=null){
        if (empty($ip)){
            $ip = self::getIp();
        }
        $result = 0;
        $ip_array = explode('.', $ip);
        if (count($ip_array) != 4){
            return $result;
        }
        foreach ($ip_array as $key => $value){
            $result += (int)$value * pow(256, 3 - $key);
        }
        return $result;
    }
}