<?php
/**
 * String对象即字符串处理方法
 * @name      MDString.class.php
 * @copyright http://www.97md.net
 * @access    97MD
 * @author    zxing  Sun Jun 07 19:55:14 GMT+08:00 2009
 * @version   Sun Jun 07 19:55:14 GMT+08:00 2009
 */
defined('MyDream') or exit('Error: Access Denied!');

class MDString extends Base {
    /**
     +-----------------------------------------------------
     * 对UTF8编码的支付传进行截取
     * @access public
     * @param String $string 要截取的字符串,Int $length 截取长度, String $dot='…' 被截取时填充符
     * @return String
     * @author zxing@97md.net Sun Jul 19 10:35:32 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public static function cutUtf($string,$length,$dot='…') {
        if(strlen($string) <= $length) {
            return $string;
        }
        $strcut = '';
        $n = $tn = $noc = 0;
        while ($n < strlen($string)) {
            $t = ord($string[$n]);
            if($t == 9 || $t == 10 || (32 <= $t && $t <= 126)) {
                $tn = 1;
                $n++;
                $noc++;
            }elseif(194 <= $t && $t <= 223) {
                $tn = 2;
                $n += 2;
                $noc += 2;
            }elseif(224 <= $t && $t < 239) {
                $tn = 3;
                $n += 3;
                $noc += 2;
            }elseif(240 <= $t && $t <= 247) {
                $tn = 4;
                $n += 4;
                $noc += 2;
            }elseif(248 <= $t && $t <= 251) {
                $tn = 5;
                $n += 5;
                $noc += 2;
            }elseif($t == 252 || $t == 253) {
                $tn = 6;
                $n += 6;
                $noc += 2;
            }else {
                $n++;
            }
            if ($noc >= $length)   break;
        }
        if ($noc > $length)  $n -= $tn;
        $strcut = substr($string, 0, $n);
        if ( strlen($strcut) < $length ) {
            $strcut = $strcut.$dot;
        }
        return $strcut;
    }
    /**
     +-----------------------------------------------------
     *  转码SCAPE编码 -- %u6B66%u6C49
     * @access public
     * @param String $str
     * @return String
     * @author zxing@97md.net Sun Jul 19 10:40:06 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     * echo unescape(base64_decode('JXU2QjY2JXU2QzQ5'));//武汉
     * echo unescape('%u6B66%u6C49');//武汉
     */
    public static function unescape($str) {
        $str = rawurldecode($str);
        preg_match_all('/(?:%u.{4})|&#x.{4};|&#\d+;|.+/U',$str,$r);
        $ar = $r[0];
        foreach($ar as $k=>$v) {
            if(substr($v,0,2) == '%u')
                $ar[$k] = iconv('UCS-2','UTF-8',pack('H4',substr($v,-4)));
            elseif(substr($v,0,3) == '&#x')
                $ar[$k] = iconv('UCS-2','UTF-8',pack('H4',substr($v,3,-1)));
            elseif(substr($v,0,2) == '&#') {
                $ar[$k] = iconv('UCS-2','UTF-8',pack('n',substr($v,2,-1)));
            }
        }
        return join('',$ar);
    }
    /**
     +-----------------------------------------------------
     * 得到首字母(当要求支持汉字任意编码要求加载 mbstring 模块)
     * @access public
     * @param String $input
     * @return String
     * @author zxing@97md.net Sun Jul 19 10:42:24 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     * 使用示例以及输出内容
     * echo MDString::getLetter('中');// Z
     * echo MDString::getLetter('国');// G
     * echo MDString::getLetter('万岁');// W
     * echo MDString::getLetter('c');// c
     * echo MDString::getLetter('PRC');// P
     */
    public static function getLetter($input) {
        $dict = array(
                'A'=>0xB0C4,'B'=>0xB2C0,'C'=>0xB4ED,'D'=>0xB6E9,'E'=>0xB7A1,
                'F'=>0xB8C0,'G'=>0xB9FD,'H'=>0xBBF6,'J'=>0xBFA5,'K'=>0xC0AB,
                'L'=>0xC2E7,'M'=>0xC4C2,'N'=>0xC5B5,'O'=>0xC5BD,'P'=>0xC6D9,
                'Q'=>0xC8BA,'R'=>0xC8F5,'S'=>0xCBF9,'T'=>0xCDD9,'W'=>0xCEF3,
                'X'=>0xD188,'Y'=>0xD4D0,'Z'=>0xD7F9,
        );
        if (function_exists('mb_detect_encoding')) {
            $input = mb_convert_encoding($input,'GBK',mb_detect_encoding($input));
        }
        $str_1 = substr($input, 0, 1);
        if ($str_1 >= chr(0x81) && $str_1 <= chr(0xfe)) {
            $num = hexdec(bin2hex(substr($input, 0, 2)));
            foreach ($dict as $k=>$v) {
                if($v>=$num)  break;
            }
            return $k;
        }else {
            return $str_1;
        }
    }
    /**
     +-----------------------------------------------------
     * 普通加密函数
     * @access  public
     * @param String $date
     * @return Void
     * @author zxing@97md.net  2010年1月14日 11:46:30
     +-----------------------------------------------------
     * @example
     */
    public static function passwordEncode($date) {
        $result = md5($date.md5($date).base64_decode($date));
        return $result;
    }
}
