<?php
/**
 * 浏览器缓存
 * @name      BrowserCache.class.php
 * @copyright http://www.97md.com 
 * @access    97MD
 * @author    zxing  Wed Jun 17 23:19:29 GMT+08:00 2009
 * @version   Wed Jun 17 23:19:29 GMT+08:00 2009
 */
defined('MyDream') or exit('Error: Access Denied!');

class BrowserCache {
    /**
     * 启动和检查浏览器缓存
     * @name isCached
     * @param Int $time_out 缓存时间(单位秒)
     * @return Boolen 是否存在客户端缓存
     * @author zxing Wed Jun 17 23:21:00 GMT+08:00 2009
     * @version  Wed Jun 17 23:21:00 GMT+08:00 2009
     * @example 
     * 这个函数是一个非常有效的减少客户端请求的操作
     * 
     * // 检查是否存在客户端缓存数据如果不存在则执行操作取得数据
     * // 如果存在客户端数据则不再执行
     * if (!BrowserCache::isCached(3600)){
     *     // 把返回数据的代码放在这个里面
     * }
     */
    public static function isCached($time_out=1800){
        $is_cahced = false;
        if ( isset($_SERVER['HTTP_IF_MODIFIED_SINCE'])){
            if ( strtotime($_SERVER['HTTP_IF_MODIFIED_SINCE']) > time() ){
                $is_cahced = true;
            }
            header(__CLASS__."Debug: ".$_SERVER['HTTP_IF_MODIFIED_SINCE']);
        }
        // 使用HTTP缓存的公共头
        header("Cache-Control: max-age=$time_out");
        header("Pragma: public");
        if (!$is_cahced){
            // 无客户端缓存
            header("Last-Modified:".date( 'r',time() + $time_out ));
            header("Expires: ".date( 'r',time() + $time_out ));
        }else{
            // 有客户端缓存
            header ("HTTP/1.0 304 Not Modified");
            header("Expires: ".$_SERVER['HTTP_IF_MODIFIED_SINCE']);
        }
        return $is_cahced;
    }
}