<?php
/**
 +---------------------------------------------------------
 * 客户端信息采集类
 +---------------------------------------------------------
 * @name      BrowserMsg.class.php
 * @copyright http://www.97md.net 
 * @access    MyDream
 * @author    zxing@97md.net  Wed Oct 14 09:53:04 CST 2009
 * @version   Wed Oct 14 09:53:04 CST 2009
 +---------------------------------------------------------
 * @example
 */
defined('MyDream') or exit('Error: Access Denied!');

class BrowserMsg {
    /**
     +-----------------------------------------------------
     * 取得客户端IP
     * @access public static
     * @param String $type num/string 数字或者字符串类型的信息
     * @return Int/String
     * @author zxing@97md.net Wed Oct 14 09:53:37 CST 2009
     +-----------------------------------------------------
     * @example
     */
    public static function getIP($type='num'){
        if (getenv('HTTP_CLIENT_IP') && strcasecmp(getenv('HTTP_CLIENT_IP'), 'unknown')){
            $ip = getenv('HTTP_CLIENT_IP');
        }elseif (getenv('HTTP_X_FORWARDED_FOR') && strcasecmp(getenv('HTTP_X_FORWARDED_FOR'), 'unknown')){
            $ip = getenv('HTTP_X_FORWARDED_FOR');
        }elseif (getenv('REMOTE_ADDR') && strcasecmp(getenv('REMOTE_ADDR'), 'unknown')){
            $ip = getenv('REMOTE_ADDR');
        }elseif(isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] && strcasecmp($_SERVER['REMOTE_ADDR'], 'unknown')){
            $ip = $_SERVER['REMOTE_ADDR'];
        }else{
            $ip = 'unknown';
        }
        // 将IP转换成十进制数
        if ($type=='num'){
            $ip = self::IptoNum($ip);
        }
        return($ip);
    }
    /**
     +-----------------------------------------------------
     * 将IP地址转换成数字
     * @access public
     * @param String $ip
     * @return Void
     * @author zxing@97md.net Thu Oct 29 15:17:07 CST 2009
     +-----------------------------------------------------
     * @example
     */
    public static function IptoNum($ip){
        if ($ip == 'unknown'){
            return 0;
        }        
        return bindec(decbin(ip2long($ip)));
    }
    /**
     +-----------------------------------------------------
     * 根据给出的数字类型的IP给出字符串类型的用于展示的IP
     * @access public
     * @param Int $num
     * @param Int $limit
     * @return String
     * @author zxing@97md.net Fri Oct 30 10:20:44 CST 2009
     +-----------------------------------------------------
     * @example
     */
    public function ShowIP($num,$limit=1){
    	$ip = long2ip($num);
    	if ($limit>0){
    	    $array = explode('.',$ip);
    	    $do = 0;
    	    while ($do<$limit){
    	        $array[3-$do] = '*';
    	        $do ++ ;
    	    }
    	    $ip = implode('.',$array);
    	}
    	return $ip;
    }
}