<?php
/**
 +---------------------------------------------------------
 * 数据分页类
 +---------------------------------------------------------
 * @name      Paging.class.php
 * @copyright http://www.97md.net 
 * @access    MyDream
 * @author    zxing@97md.net  Mon Aug 10 14:53:57 GMT+08:00 2009
 * @version   Mon Aug 10 14:53:57 GMT+08:00 2009
 +---------------------------------------------------------
 * @example
 *  声明对象 
 * -> 给出总条数(数字/数组) 
 * -> 给出当前页数 
 * －> 取得SQL的limit 
 * -> 取得分页链接
 */
defined('MyDream') or exit('Error: Access Denied!');

class Paging {
    private $_total_num = 0;           // 分页信息总数
    private $_limit = 20;              // 一页多少条信息
    private $_page  = 0;               // 总共页数
    private $_page_now = 1;            //当前页数
    private $number;
    /**
     +-----------------------------------------------------
     * 构造和系构函数
     * @access public
     * @param Int $limit 每页数据条数
     * @return Void
     * @author zxing@97md.net Mon Aug 10 14:55:20 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function __construct($limit){
        $this->_limit = $limit;
    }
    /**
     +-----------------------------------------------------
     * 设置分页数据总数
     * @access public
     * @param Int/Array $number 
     * @return Void
     * @author zxing@97md.net Mon Aug 10 14:56:04 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function totalNum($number){
        if (is_numeric($number)){
            // 如果是数字则直接赋值给信息总数
            $this->_total_num = $number;
        }else{
            // 如果是数组则计算数组各项和后赋值
            $this->_total_num = array_sum( $number );
        }
        $this->number = $number;
        $this->_page = ($this->_total_num==0)?0:ceil($this->_total_num/$this->_limit);
    }
    /**
     +-----------------------------------------------------
     * 设置当前页数 分页数从1开始
     * @access public
     * @param Int $page 当前页数
     * @return Void
     * @author zxing@97md.net Mon Aug 10 14:56:51 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function pageNow($page){
        $page = intval($page);
        $this->_page_now = ($page<1)?1:$page;
        $this->_page_now = min($this->_page_now,$this->_page);
    }
    /**
     +-----------------------------------------------------
     * 取得个个项目的分页 限制
     * @access public
     * @param Void
     * @return String/Array
     * @author zxing@97md.net Mon Aug 10 16:11:52 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function getLimit(){
        // 所有信息的开始
        $limit_beg = ($this->_page_now-1)*$this->_limit;
        // 所有信息的结束
        $limit_end = $this->_page_now*$this->_limit;
        if ($limit_end>$this->_total_num){
            $limit_end = $this->_total_num;
        }
        if (!is_array($this->number)){
            // 如果不涉及多数据分页 就是它了
            $result = $limit_beg.','.$this->_limit;
        }else{// 多数据源分页
            $result = array();
            $result_limit = array();
            $total_number = 0;
            foreach ($this->number as $key=>$value){
                $total_number += $value;
                if ( $limit_beg > $total_number ){
                    $result[] = '0,0';
                }elseif ( $limit_end < $total_number-$value ){
                    $result[] = '0,0';
                }else{
                    $_beg = $limit_beg - ( $total_number - $value );
                    if ($_beg<0){
                        $_beg = 0;
                    }
                    $_end = $this->_limit - array_sum($result_limit);
                    if ( $_end > $value ) {
                        $_end = $value;
                    }
                    $result_limit[] = $_end;
                    $result[] = $_beg.','.$_end;
                }
            }
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * 取得当前分页链接
     * @access public
     * @param Void
     * @return Array
     * @author zxing@97md.net Mon Aug 10 16:12:38 GMT+08:00 2009
     +-----------------------------------------------------
     * @example
     */
    public function getPageLink(){
        $result = array();
        $result['prev']  = ($this->_page_now - 1);
        $result['next']  = ($this->_page_now + 1);
        $result['first'] = 1;
        $result['end']   = $this->_page;
        $result['now']   = $this->_page_now;
        if ($result['prev']<1){
            $result['prev'] = 0;
        }
        if ($result['next'] > $this->_page){
            $result['next'] = $this->_page;
        }
        $first = $this->_page_now-5;
        $end   = $this->_page_now+5;
        if ( $first<1 ){
            $first = 1;
            $end   = 11;
        }
        if ($end>$this->_page) {
            $first = $this->_page-10;
            $end   = $this->_page;
        }
        if ( $first<1 ) $first = 1;
        if ( $end>$this->_page )  $end   = $this->_page;

        for ($i=$first;$i<=$end;$i++){
            $result[$i] = $i;
        }
        return $result;
    }
}