<?php
/**
 +---------------------------------------------------------
 *  百度搜索引擎处理
 +---------------------------------------------------------
 * @name      BaiduEngine.class.php [UTF-8]
 * @copyright http://www.97md.net
 * @access    MyDream
 * @author    zxing@97md.net
 * @version   2010-8-5 11:14:19
 +---------------------------------------------------------
 * @example
 * 可以一次性取得全部搜索结果
 */
defined('MyDream') or exit('Error: Access Denied!');
class BaiduEngine extends EngineBase {
    public function  __construct() {
        $this->base_url = 'http://www.baidu.com/';
        $this->char_set = 'gb2312';
        global $_CONFIG;
        $this->engine_weight = $_CONFIG['SearchEngine'][__CLASS__] ;
    }
    /**
     +-----------------------------------------------------
     * getUrl--得到URL
     * @access public
     * @param Int $id
     * @return Boolen
     * @author zxing@97md.net 2010-08-05 11:15:23
     +-----------------------------------------------------
     * @example
     */
    public function getUrl($keywords,$start=1) {
        $result = false;
        $this->start_id = $start;
        $this->search_url = $result;
        if(empty($keywords)) {
            $result = $this->base_url;
        }else {
            $keywords = iconv('utf-8', 'gb2312', $keywords);
            $result = $this->base_url . 's?wd=' . urlencode($keywords) . '&rn=100&pn=' . $start;
            $this->search_url = $result;
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * resolve--解析HTML
     * @access public
     * @param Int $id 返回结果编号
     * @return Boolen
     * @author zxing@97md.net 2010-08-06 15:56:12
     +-----------------------------------------------------
     * @example
     */
    public function resolve($id) {
        $result = array();
        if( $id <0 )  $id = 0;
        if( $id >49 )  $id = 49;
        if(empty($this->item)) {
            $this->item = $this->getContents();
        }
        $temp = '';
        if(isset($this->item[$id])) {
            $temp = $this->item[$id];
            if($this->char_set != 'utf-8' ) {
                $temp = iconv($this->char_set, 'utf-8', $temp);
            }
            $cut_top = 'href="';
            $cut_sec = '"  target="_blank" >';
            $temp = substr($temp, strpos($temp,  $cut_top ) + strlen( $cut_top ));
            $result['link'] =substr($temp, 0 , strpos($temp, $cut_sec));
            $temp = substr($temp, strpos($temp, $cut_sec) + strlen($cut_sec));
            $temp = explode('<br>', $temp);
            $result['title'] = isset ($temp[0])? strip_tags(trim($temp[0])):'';
            $result['description'] = isset ($temp[1])? strip_tags(trim($temp[1])):'';
            $result['rank'] = (100-$id) * $this->engine_weight;
            if( strstr($result['link'], '.baidu.com') ||  substr($result['link'],0,7)!='http://' ||  substr($result['link'],0,strlen($_SERVER['HTTP_HOST'])+8)=='http://'.$_SERVER['HTTP_HOST'].'/'  || empty($result['link']) || empty($result['title']) ){
                $result = array();
            }
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * getContents--返回检索结果的各条信息
     * @access public
     * @param Int $id
     * @return Boolen
     * @author zxing@97md.net 2010-08-06 16:25:36
     +-----------------------------------------------------
     * @example
     */
    public function getContents() {
        $result = array();
        parent::getContents($string);
        $cut = array(
                '<body link="#0000cc">',
                '</div>
<br>
</td></tr></table>',
        );
        foreach( $cut as $value ) {
            $string = substr( $string, strpos($string, $value ) + strlen($value) );
        }
        $end = '<script>(function(){var b=1,c,a,q,p,o,l,k,d,r,g,j,u';
        $string = substr( $string, 0, strpos($string, $end ));
        $string = explode('<br></font></td></tr></table><br>', trim($string) );
        foreach ($string as $key=>$value) {
            if(!empty($value)) {
                $result[] = $value;
            }
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * Related--获取相关关键词
     * @access public
     * @return Boolen
     * @author zxing@97md.net 2010-08-06 17:17:01
     +-----------------------------------------------------
     * @example
     */
    public function Related() {
        parent::getContents($contents);
        return parent::Related (
                $contents,
                array( '</td><td rowspan="2" valign="middle">'),
                '</a></td></tr></table></td></tr><tr><td>&nbsp;</td></tr></table></div><br>',
                '</td>'
        );
    }
   /**
    +-----------------------------------------------------
    * getAll--取得全部结果
    * @access public
    * @param String $kw = 关键词
    * @return Boolen
    * @author zxing@m148.com 2010-08-31 09:23:47
    +-----------------------------------------------------
    * @example
    */
   public function getAll($kw) {
       $result = array();
       $this->getUrl($kw);
      $b = $this->getContents();
       foreach($b as $key=>$value){
          $temp = $this->resolve($key);
          if( !empty($temp) ){
          $result[] = $temp;
          }
       }
       return $result;
   }
}