<?php
/**
 +---------------------------------------------------------
 *  SearchEngine 基础类 提供搜索引擎的基础服务
 +---------------------------------------------------------
 * @name      EngineBase.class.php [UTF-8]
 * @copyright http://www.97md.net
 * @access    MyDream
 * @author    zxing@97md.net
 * @version   2010-8-5 11:10:58
 +---------------------------------------------------------
 * @example
 */
defined('MyDream') or exit('Error: Access Denied!');

abstract class EngineBase extends Base {
    public $search_url = '';     // 搜索结果URL
    public $engine_weight = 1;     // 搜索引擎权重
    public $base_url   = '';     // 搜索引擎首页
    public $char_set = 'utf-8'; //搜索引擎编码
    public $start_id  = 10;   //开始ID
    public $contents  = null;   //内容
    public $item       = array();
    // 取得UTF编码的搜索结果URL
    abstract public function getUrl($keywords,$start=10);
    /**
     +-----------------------------------------------------
     * getContents--取得搜索结果内容
     * @access public
     * @param Object $dom 给出 一个 DOMDocument  的对象
     * @return Bollen
     * @author zxing@97md.net 2010-08-06 14:55:50
     +-----------------------------------------------------
     * @example
     */
    public function getContents(&$string) {
        // ini_set('memory_limit','256M');
        if( empty( $this->contents ) ) {
            try {
                if( empty ( $_ENV['snoopy_obj'] ) ) {
                    $snoopy = new Snoopy();
                    $snoopy->agent = 'MyDream(http://' .$_SERVER['HTTP_HOST']. '/ )';
                    $snoopy->headers['Accept-Language'] = 'zh-cn,zh;q=0.5';
                    $snoopy->headers['Accept-Charset'] = 'utf-8;q=0.7';
                    $snoopy->accept = 'text/html;q=0.9,*/*;q=0.8';
                    $snoopy->timed_out = 5;
                    $_ENV['snoopy_obj'] = $snoopy;
                }else{
                    $snoopy = $_ENV['snoopy_obj'] ;
                }
                $snoopy->referer = $this->base_url;
                if( empty($this->search_url) ) throw new Exception('NO SeachURL', 0);
                $snoopy->fetch($this->search_url);
                $string = $snoopy->results;
                $this->contents = $string ;
                return true;
            }catch(Exception $e) {
                return false;
            }
        }else {
            $string =  $this->contents;
            return true;
        }
    }
    /**
     +-----------------------------------------------------
     * Related--获取相关关键词
     * @access public
     * @return Boolen
     * @author zxing@97md.net 2010-08-06 17:17:01
     +-----------------------------------------------------
     * @example
     */
    public function Related($string,$cut_tops,$cut_end,$explode) {
        header('URL: ' . $this->search_url );
        ob_flush();
        flush();
        $result = array();
        foreach( $cut_tops as $value ) {
            if( !strpos($string, $value ) ){
                return false;
            }
            $string = substr( $string, strpos($string, $value ) + strlen($value) );
        }
        $cut_len = strpos($string, $cut_end );
        if( $cut_len ) {
            $string = substr( $string, 0, $cut_len);
        }else {
            return false;
        }
        if($this->char_set != 'utf-8' ) {
            $string = iconv($this->char_set, 'utf-8', $string);
        }
        $string = str_replace(array('&nbsp;'), '', $string);
        $string = explode($explode, trim($string) );
        foreach ($string as $key=>$value) {
            $value = trim(strip_tags($value));
            if(!empty($value)) {
                $result[] = $value;
            }
        }
        $result = implode(',', $result);
        return $result;
    }
    /**
     +-----------------------------------------------------
     * getAll--得到所有条目
     * @access public
     * @param String $kw = 关键词
     * @return Boolen
     * @author zxing@m148.com 2010-08-31 09:21:15
     +-----------------------------------------------------
     * @example
     */
    abstract public function getAll($kw);
}