<?php
/**
 +---------------------------------------------------------
 * Google搜索引擎 类
 +---------------------------------------------------------
 * @name      GoogleEngine.class.php [UTF-8]
 * @copyright http://www.97md.net
 * @access    MyDream
 * @author    zxing@97md.net
 * @version   2010-8-5 11:50:00
 +---------------------------------------------------------
 * @example
 * 可以一次性取得全部搜索结果
 */
defined('MyDream') or exit('Error: Access Denied!');
// 注意 类名字为 不包含 class 
class GoogleEngine  extends EngineBase {
    public function  __construct() {
        $this->base_url = 'http://www.google.com/';
        $this->char_set = 'utf-8';
        global $_CONFIG;
        $this->engine_weight = $_CONFIG['SearchEngine'][__CLASS__] ;
    }
    /**
     +-----------------------------------------------------
     * getUrl--得到搜索结果URL
     * @access public
     * @param Int $id
     * @return Boolen
     * @author zxing@97md.net 2010-08-05 11:50:44
     +-----------------------------------------------------
     * @example
     */
    public function getUrl($keywords,$start=0) {
        $result = false;
        $this->search_url = $result;
        if(empty($keywords)) {
            $result = $this->base_url;
        }else {
            $keywords = iconv('utf-8', 'gb2312', $keywords);
            $result = $this->base_url . 'search?q=' . urlencode($keywords) . '&oe=utf-8&hl=zh-CN&num=100&start=' . $start ;
            $this->search_url = $result;
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * resolve--解析HTML
     * @access public
     * @param Int $id 返回结果编号
     * @return Boolen
     * @author zxing@97md.net 2010-08-06 15:56:12
     +-----------------------------------------------------
     * @example
     */
    public function resolve($id) {
        $result = array();
        if( $id <0 )  $id = 0;
        if( $id >49 )  $id = 49;
        if(empty($this->item)) {
            $this->item = $this->getContents();
        }
        $temp = '';
        if(isset($this->item[$id])) {
            $temp = $this->item[$id];
            if($this->char_set != 'utf-8' ) {
                $temp = iconv($this->char_set, 'utf-8', $temp);
            }
            $cut_top = 'href="';
            $cut_sec = '"';
            $temp = substr($temp, strpos($temp,  $cut_top ) + strlen( $cut_top ));
            $result['link'] =substr($temp, 0 , strpos($temp, $cut_sec));
            $temp = substr($temp, strpos($temp, $cut_sec) + strlen($cut_sec));
            $cut_sec = '>';
            $temp = substr($temp, strpos($temp, $cut_sec) + strlen($cut_sec));
            $cut_tit = '</h3>';
            $result['title'] = strip_tags(trim(substr($temp, 0, strpos($temp, $cut_tit) ))) ;
            $result['title'] = str_replace( array('翻译此页',']','[','-',' '), '', $result['title']);
            $temp = substr($temp, strpos($temp, $cut_tit) + strlen($cut_tit));
            $cut_des = '<cite>';
            $result['description'] = strip_tags(trim(substr($temp, 0 , strpos($temp, $cut_des) ))) ;
            $result['rank'] = (100-$id) * $this->engine_weight;
            if( strstr($result['link'], '.google.')
                    ||  substr($result['link'],0,7)!='http://'
                    ||  substr($result['link'],0,strlen($_SERVER['HTTP_HOST'])+8)=='http://'.$_SERVER['HTTP_HOST'].'/'
                    || empty($result['link'])
                    || empty($result['title']) ) {
                $result = array();
            }
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * getContents--返回检索结果的各条信息
     * @access public
     * @param Int $id
     * @return Boolen
     * @author zxing@97md.net 2010-08-06 16:25:36
     +-----------------------------------------------------
     * @example
     */
    public function getContents() {
        $result = array();
        parent::getContents($string);
         $cut = array(
                '<ol>'
        );
        foreach( $cut as $value ) {
            $string = substr( $string, strpos($string, $value ) + strlen($value) );
        }
        $end = '</ol>';
        $string = substr( $string, 0, strpos($string, $end ));
        $string = explode('<li class=g>', trim($string) );
        foreach ($string as $key=>$value) {
            if(!empty($value)) {
                $result[] = $value;
            }
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * Related--获取相关关键词
     * @access public
     * @return Boolen
     * @author zxing@97md.net 2010-08-06 17:17:01
     +-----------------------------------------------------
     * @example
     */
    public function Related() {
        parent::getContents($contents);
        return parent::Related (
                $contents,
                array( '的相关搜索</div><div class=brs_col>'),
                '</div></div></div> </div>',
                '</p>'
        );
    }
    /**
     +-----------------------------------------------------
     * getAll--取得全部结果
     * @access public
     * @param String $kw = 关键词
     * @return Boolen
     * @author zxing@m148.com 2010-09-03 20:10:00
     +-----------------------------------------------------
     * @example
     */
    public function getAll($kw) {
        $result = array();
        $this->getUrl($kw);
        $b = $this->getContents();
        foreach($b as $key=>$value) {
            $temp = $this->resolve($key);
            if( !empty($temp) ) {
                $result[] = $temp;
            }
        }
        return $result;
    }
}