<?php
/**
 +---------------------------------------------------------
 * Yahoo 搜索引擎 类
 +---------------------------------------------------------
 * @name      YahooEngine.class.php [UTF-8]
 * @copyright http://www.97md.net
 * @access    MyDream
 * @author    zxing@97md.net
 * @version   2010-8-5 11:50:00
 +---------------------------------------------------------
 * @example
 * 必须多次访问以取得全部搜索结果
 */
defined('MyDream') or exit('Error: Access Denied!');

class YahooEngine  extends EngineBase {
    public function  __construct() {
        $this->base_url = 'http://one.cn.yahoo.com/';
        global $_CONFIG;
        $this->engine_weight = $_CONFIG['SearchEngine'][__CLASS__] ;
    }
    /**
     +-----------------------------------------------------
     * getUrl--得到搜索结果URL
     * @access public
     * @param Int $id
     * @return Boolen
     * @author zxing@97md.net 2010-08-05 11:50:44
     +-----------------------------------------------------
     * @example
     */
    public function getUrl($keywords,$start=0) {
        if(empty($keywords)) {
            $this->search_url = $this->base_url;
        }else {
            // $keywords = iconv('utf-8', 'gbk', $keywords);
            // http://one.cn.yahoo.com/s?p=%E6%AD%A6%E6%B1%89&v=web&pid=hp
            $this->search_url = $this->base_url . 's?p=' . urlencode($keywords) . '&pid=hp&v=web&b=' . $start ;
        }
        return $this->search_url;
    }
    /**
     +-----------------------------------------------------
     * resolve--解析HTML
     * @access public
     * @param Int $id 返回结果编号
     * @param Int $i   修正结果号码
     * @return Boolen
     * @author zxing@97md.net 2010-08-06 15:56:12
     +-----------------------------------------------------
     * @example
     */
    public function resolve($id , $limit_i) {
        $result = array();
        if( $id <0 )  $id = 0;
        if( $id >49 )  $id = 49;
        if(empty($this->item)) {
            $this->item = $this->getContents();
        }
        $temp = '';
        if(isset($this->item[$id])) {
            $temp = $this->item[$id];
            if($this->char_set != 'utf-8' ) {
                $temp = iconv($this->char_set, 'utf-8', $temp);
            }
            $cut_top = 'href="';
            $cut_sec = '"';
            $temp = substr($temp, strpos($temp,  $cut_top ) + strlen( $cut_top ));
            $result['link'] =substr($temp, 0 , strpos($temp, $cut_sec));
            $temp = substr($temp, strpos($temp, $cut_sec) + strlen($cut_sec));
            $cut_sec = '>';
            $temp = substr($temp, strpos($temp, $cut_sec) + strlen($cut_sec));
            $cut_tit = '</h3>';
            $result['title'] = strip_tags(trim(substr($temp, 0, strpos($temp, $cut_tit) ))) ;
            $temp = substr($temp, strpos($temp, $cut_tit) + strlen($cut_tit));
            $cut_des = '<em>';
            $result['description'] = strip_tags(trim(substr($temp, 0 , strpos($temp, $cut_des) ))) ;
            $result['rank'] = ( 50- $id - $limit_i ) * $this->engine_weight;
            if( strstr($result['link'], '.yahoo.') ||  substr($result['link'],0,7)!='http://' ||  substr($result['link'],0,strlen($_SERVER['HTTP_HOST'])+8)=='http://'.$_SERVER['HTTP_HOST'].'/' || empty($result['link']) || empty($result['title']) ){
                $result = array();
            }
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * getContents--返回检索结果的各条信息
     * @access public
     * @param Int $id
     * @return Boolen
     * @author zxing@97md.net 2010-08-06 16:25:36
     +-----------------------------------------------------
     * @example
     */
    public function getContents() {
        $result = array();
        parent::getContents($string);
        $cut = array(
                '<div class="yst-web">'
        );
        foreach( $cut as $value ) {
            $string = substr( $string, strpos($string, $value ) + strlen($value) );
        }
        $end = '<!--}}end:yst web -->';
        $string = substr( $string, 0, strpos($string, $end ));
        $string = explode('</li><li>', trim($string) );
        foreach ($string as $key=>$value) {
            if(!empty($value)) {
                $result[] = $value;
            }
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * Related--获取相关关键词
     * @access public
     * @return Boolen
     * @author zxing@97md.net 2010-08-06 17:17:01
     +-----------------------------------------------------
     * @example
     */
    public function Related() {
        parent::getContents($contents);
        return parent::Related (
                $contents,
                array( '<tr><th colspan="4">相关搜索</th></tr>'),
                '</a></td></tr>	</table>',
                '</td>'
        );
    }
    /**
     +-----------------------------------------------------
     * getAll--取得全部结果
     * @access public
     * @param String $kw = 关键词
     * @return Boolen
     * @author zxing@m148.com 2010-09-03 20:10:00
     +-----------------------------------------------------
     * @example
     */
    public function getAll($kw) {
        $result = array();
        global $_CONFIG;
        $get_number = 10;
        if($_CONFIG['get_all']){
            $get_number = 50;
        }
        for($i=0;$i<$get_number;$i=$i+10) {
            $this->contents = null;
            $this->item = array();
            $this->getUrl($kw , $i);
            $b = array();
            $b = $this->getContents();
            foreach($b as $key=>$value) {
                $temp = $this->resolve($key , $i );
                if( !empty($temp) ) {
                    $result[] = $temp;
                }
            }
        }
        
        return $result;
    }
}