<?php
/**
 +---------------------------------------------------------
 * 使用内存缓存SESSION信息
 +---------------------------------------------------------
 * @name      MemSession.class.php
 * @copyright http://www.97md.net
 * @access    MyDream
 * @author    zxing@97md.net  Thu Sep 03 12:15:20 CST 2009
 * @version   Thu Sep 03 12:15:20 CST 2009
 +---------------------------------------------------------
 * @example
 */
defined('MyDream') or exit('Error: Access Denied!');

class MemSession extends SesBase {
    private static  $_memcache ;                     // 保存一个内存缓存连接对象
    private static  $_header = 'SESSION_';
    /**
     +-----------------------------------------------------
     * 构造和析构函数
     * @access public
     * @param String $INDEX2
     * @return Void
     * @author zxing@97md.net Thu Sep 03 22:50:42 CST 2009
     +-----------------------------------------------------
     * @example
     */
    public function __construct($doman=null,$mem_server='localhost') {
        global $_MEM;
        self::$_memcache = $_MEM;
        parent::__construct(__CLASS__,$doman);
    }
    /**
     +-----------------------------------------------------
     * 开启SESSION时执行，创建数据
     * @access public
     * @return Void
     * @author zxing@97md.net Thu Sep 03 22:51:46 CST 2009
     +-----------------------------------------------------
     * @example
     */
    public static function open() {

    }
    /**
     +-----------------------------------------------------
     * 关闭SESSION
     * @access public
     * @return Void
     * @author zxing@97md.net Thu Sep 03 22:52:50 CST 2009
     +-----------------------------------------------------
     * @example
     */
    public static function close() {

    }
    /**
     +-----------------------------------------------------
     * 读取SESSION时执行
     * @access public
     * @param String $s_id
     * @return String
     * @author zxing@97md.net Thu Sep 03 22:53:38 CST 2009
     +-----------------------------------------------------
     * @example
     */
    public static function read($s_id) {
        // 取得指定ID的session数据
        return self::$_memcache->get(self::$_header.$s_id);
    }
    /**
     +-----------------------------------------------------
     * 	写入SESSION值
     * @access public static
     * @param String $s_id
     * @param String $s_data
     * @return Void
     * @author zxing@97md.net Thu Sep 03 22:54:48 CST 2009
     +-----------------------------------------------------
     * @example
     */
    public static function write($s_id, $s_data) {
        // 更新SESSION数据
        return self::$_memcache->set(self::$_header.$s_id,$s_data,ini_get('session.gc_maxlifetime'));
    }
    /**
     +-----------------------------------------------------
     * 销毁SESSION
     * @access public static
     * @param String $s_id
     * @return Void
     * @author zxing@97md.net Thu Sep 03 22:55:24 CST 2009
     +-----------------------------------------------------
     * @example
     */
    public static function destroy($s_id) {
        // 删除指定的SESSION数据
        return self::$_memcache->delete(self::$_header.$s_id);
    }
    /**
     +-----------------------------------------------------
     * 清理过期SESSION 数据
     * @access public static
     * @return Void
     * @author zxing@97md.net Thu Sep 03 22:56:00 CST 2009
     +-----------------------------------------------------
     * @example
     */
    public static  function gc() {

    }
}