<?php
/**
 +---------------------------------------------------------
 * SESSION 处理类基类
 +---------------------------------------------------------
 * @name      SesBase.class.php
 * @copyright http://www.97md.net 
 * @access    MyDream
 * @author    zxing@m148.org  Thu Sep 03 22:43:00 CST 2009
 * @version   Thu Sep 03 22:43:00 CST 2009
 +---------------------------------------------------------
 * @example
 */
defined('MyDream') or exit('{Error_Access_Denied}');

abstract class SesBase{
    protected $_name = 'Zxing_SID';// COOKIE id
    private static $__CLASS__;
    /**
     * 构造函数
     * @name __construct
     * @param $__CLASS__ 类名称 调用时给出自己的类名称即可 String $doman SESSION 共享域名
     * @return String
     * @author zxing Thu Jan 08 22:31:19 CST 2009
     * @version  Thu Jan 08 22:31:19 CST 2009
     * @example 
     */
    public function __construct($__CLASS__,$doman = null){
        ini_set('session.use_trans_sid',0);
        ini_set('session.gc_maxlifetime',3600*6);
        ini_set('session.use_cookies',1);
        ini_set('session.use_only_cookies',1);
        ini_set('session.name',$this->_name);
        ini_set('session.gc_probability',1);// 执行销毁函数的机率分子
        ini_set('session.gc_divisor',100);// 执行销毁函数的机率分母
        if (!empty($doman)){
            ini_set('session.cookie_domain',$doman);//域名
        }
        self::$__CLASS__ = $__CLASS__;
        session_set_save_handler(
        array($__CLASS__,'open'),
        array($__CLASS__,'close'),
        array($__CLASS__,'read'),
        array($__CLASS__,'write'),
        array($__CLASS__,'destroy'),
        array($__CLASS__,'gc')
        );
        session_id($this->_get_session_id());
    }
    function __destruct(){
        if (rand(0,ini_get('session.gc_divisor')) <= ini_get('session.gc_probability')){
            // 执行清理函数
            call_user_func(array(self::$__CLASS__,'gc'));
        }
    }
    /**
     * 得到SESSION编号
     * @name _get_session_id
     * @param Void
     * @return String
     * @author zxing Thu Jan 08 22:55:33 CST 2009
     * @version  Thu Jan 08 22:55:33 CST 2009
     * @example 
     */
    protected final function _get_session_id(){
        $result = false;
        if (isset($_COOKIE[$this->_name])) {
            //如果存在 _COOKIE 则读取信息
            $result = $this->_get_sid($_COOKIE[$this->_name]);
        }else{
            $result = $this->_set_sid();
        }
        return $result;
    }
    /**
     * 编码 COOKIES 中保存的信息内容
     * @name _set_sid
     * @param Void
     * @return String
     * @author zxing Thu Jan 08 23:09:08 CST 2009
     * @version  Thu Jan 08 23:09:08 CST 2009
     * @example 
     */
    protected final function _set_sid(){
        $result = '';
        // 取得浏览器信息
        $user_msg = ( isset ($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT']:'' ).ceil(time()/(3600*24*30));
        // 取得服务器信息
        $server = ip2long($_SERVER['SERVER_ADDR']);
        //-------构建一个安全的SESSION编码
        // 0-9位 先给个随机数，防止重复了
        $result = substr(md5(microtime()),rand(0,21),10);
        // 10-19位 给出第一个检校码为浏览器信息
        $result .= substr(md5($user_msg),10,10);
        // 20-29位 给出第三组检校码 服务器IP
        $result .= substr(md5($server),rand(0,21),10);
        // 30-31位 是自身的检校码
        $result .= substr(md5($result),25,2);
        return $result;
    }
    /**
     * 解析SESSION里面的内容
     * @name _get_sid
     * @param  String $SNS_sid SESSION ID
     * @return String
     * @author zxing Thu Jan 08 23:08:28 CST 2009
     * @version  Thu Jan 08 23:08:28 CST 2009
     * @example 
     */
    protected final function _get_sid($SNS_sid){
        $result = false;
        $check_id = substr($SNS_sid,-2);
        $SNS_sid_msg = substr($SNS_sid,0,-2);
        $check_user_msg = substr($SNS_sid,10,10);
        $check_server = substr($SNS_sid,20,10);
        //检验 $SNS_sid 完整性
        if ( substr(md5($SNS_sid_msg),25,2) == $check_id ) {
            $user_msg =  ( isset ($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT']:'' ).ceil(time()/(3600*24*30));
            if ($check_user_msg == substr(md5($user_msg),10,10) ){
                // 校验浏览器信息通过
                $result = $SNS_sid;
            }
        }
        if ( false === $result ){
            $result = $this->_set_sid();
        }
        return $result;
    }
}