<?php
/**
 +---------------------------------------------------------
 *  RSS 生成类
 +---------------------------------------------------------
 * @name      Rss.class.php [UTF-8]
 * @copyright http://www.97md.net
 * @access    MyDream
 * @author    zxing@97md.net
 * @version   2010-7-26 17:23:41
 +---------------------------------------------------------
 * @example
 * // 声明对象时候必须提供 标题 首页地址和描述三个 channel必须参数
 * $rss_obj = new Rss($title,$link,$description);
 * // $rss_obj->title = '飞跃梦想'; // 其他属性(RSS092标准属性)可以这样直接添加和修改
 * // $rss_obj->link = 'http://www.97md.net';
 * ......
 * $item = array('title'=>'','description'=>'','link'=>'');// 这三个是必选参数，其他的可以查阅下面的代码
 * $rss_obj->add($item);
 * ......
 * $rss_obj->display(); // 抛出header并直接向浏览器输出内容
 * $rss_obj->display($file_name); // 将 RSS 内容写入指定的文件
 * 输出的XML文件
 <?xml version="1.0" encoding="UTF-8"?>
 <rss version="0.92">
 <channel>
 <title>飞跃梦想</title>
 <link>http://www.97md.net</link>
 <description><![CDATA[24岁，中国的本命年，更像是佛教的禅，朦胧，但已经暗藏了积分天机在内，大道将成，隐隐若现，只是这其中的一份辛苦会如炼狱般难熬，度过了，将会豁然开朗，别有洞天...... 或许，生命就是一种不停的选择和行走，但在24岁这一年，所有的一切都会分外的凸显......]]></description>
 <lastBuildDate>Thu, 17 Jun 2010 07:10:43 +0000</lastBuildDate>
 <docs>http://backend.userland.com/rss092</docs>
 <language>zh-cn</language>
 <item>
 <title>《酒干倘卖无》有多少人知道它的意思</title>
 <description><![CDATA[小女孩的童年就在那一堆堆如山的空酒瓶中成长，天生的好嗓子让她成为聋哑老人的传话机和一根拐仗，在每个清晨，女孩牵着爸爸，拐杖在石头上敲出美妙的音符，女孩大声地喊着，“酒干倘卖无？”“酒干倘卖无”？]]></description>
 <link>http://www.97md.net/20100617/449/</link>
 </item>
 </channel>
 </rss>
 */
defined('MyDream') or exit('Error: Access Denied!');
// 注意 类名字为 不包含 class 
class Rss extends Base {
    private $_channel = array();
    private $_items     = array();
    /**
     +-----------------------------------------------------
     * 构造函数
     * @access public
     * @return Void
     * @author zxing@97md.net
     * @version   2010-7-26 17:23:41
     +-----------------------------------------------------
     * @example
     */
    public function __construct($title,$link,$description) {
        $this->_channel['title']                 = $title;
        $this->_channel['link']                  = $link;
        $this->_channel['description']    = '<![CDATA[' . $description .']]>';
        $this->_channel['docs']                = 'http://backend.userland.com/rss092';
        $this->_channel['language']        = 'zh-cn';
        $this->_channel['lastBuildDate'] = date(DATE_W3C);
    }
    /**
     +-----------------------------------------------------
     * __set--魔法函数设置成员变量
     * @access public
     * @param String $name 变量名
     * @param String $value  变量值
     * @return Boolen
     * @author zxing@97md.net 2010-07-26 17:29:36
     +-----------------------------------------------------
     * @example
     */
    public function __set($name,$value) {
        $result = false;
        $channel_elements = array(
                'language','copyright','managingEditor','webMaster','pubDate','lastBuildDate',
                'category','generator','docs','ttl','image','rating','textInput','skipHours','skipDays'
        );
        if( in_array($name,$channel_elements) ) {
            $this->_channel[$name] = $value;
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * add--添加一条RSS记录
     * @access public
     * @param Array $item
     * @return Boolen
     * @author zxing@97md.net 2010-07-26 17:40:46
     +-----------------------------------------------------
     * @example
     */
    public function add($item) {
        $result = false;
        // 可选的元素集合
        $item_elements = array(
                'title','link','description','author','category',
                'comments','enclosure','guid','pubDate'
        );
        // 必须包含的元素
        $item_elements_mast  = array('title'=>'','link'=>'','description'=>'');
        // 要进行CDATA注释的元素
        $item_elements_cdata = array('description','author','category');
        // 过滤处理
        foreach( $item as $key=>$value ) {
            if( !in_array($key, $item_elements) ) {
                unset ($item[$key]);
            }
            if( isset( $item_elements_mast[$key] ) ) {
                unset ( $item_elements_mast[$key] );
            }
            if( in_array($key, $item_elements_cdata) ) {
                $item[$key] = '<![CDATA[' . $value . ']]>';
            }
        }
        // 对包含了全部必选元素的子项
        if( empty ($item_elements_mast) ) {
            $this->_items[] = $item;
            $result = true;
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * display--输出XML文件
     * @access public
     * @param String $file_name 要生成的文件名 留空则输出xml文件
     * @return Boolen
     * @author zxing@97md.net 2010-07-26 17:59:03
     +-----------------------------------------------------
     * @example
     */
    public function  display($file_name='') {
        $result = false;
        $file_name = trim($file_name);
        // 组合XML内容
        $rss_xml = '<?xml version="1.0" encoding="UTF-8"?><rss version="0.92"></channel>';
        foreach ( $this->_channel as $key=>$value) {
            $rss_xml .= '<' . $key . '>' . $value . '</' . $key . '>';
        }
        foreach ( $this->_items as $item) {
            foreach ( $item as $key=>$value) {
                $rss_xml .= '<' . $key . '>' . $value . '</' . $key . '>';
            }
        }
        $rss_xml .= '</channel></rss>';
        // 输出
        if( !empty($file_name)) {
            // 生成XML格式的存文本文件
            $handle = fopen($file_name, 'w');
            if($handle) {
                $result = fwrite($handle, $rss_xml);
                fclose($handle);
            }
        }else {
            // ob_clean();
            header('Content-Type: text/xml;charset=UTF-8');
            echo $rss_xml;
            $result = true;
        }
        return $result;
    }
}