<?php
/**
 * Google SiteMaps 应用类用于创建sitemaps地图文件
 * @name      SiteMpas.class.php
 * @copyright http://www.97md.net
 * @access    MyDream
 * @author    zxing
 * @version   2010-04-20 16:43:22
 +-----------------------------------------------------
 * 调用方法：
 * // 生成对象
 * $sitemaps = new SiteMaps();
 * // 逐个加入URL
 * $sitemaps->add($loc,$lastmod,$changefreq,$priority);
 * // 输出地图可选参数
 * $sitemaps->display(); // 抛出header并直接向浏览器输出内容
 * $sitemaps->display($file_name); // 将Sitempas内容写入指定的文件
 +-----------------------------------------------------
 * 得到的Sitemaps文件内容:
 <?xml version="1.0" encoding="UTF-8"?>
 <urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
 <url>
 <loc>http://www.example.com/</loc>
 <lastmod>2005-01-01</lastmod>
 <changefreq>monthly</changefreq>
 <priority>0.8</priority>
 </url>
 </urlset>
 索引文件
<?xml version="1.0" encoding="UTF-8"?>
<sitemapindex xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
   <sitemap>
      <loc>http://www.example.com/sitemap1.xml.gz</loc>
      <lastmod>2004-10-01T18:23:17+00:00</lastmod>
   </sitemap>
   <sitemap>
      <loc>http://www.example.com/sitemap2.xml.gz</loc>
      <lastmod>2005-01-01</lastmod>
   </sitemap>
</sitemapindex>

 */
defined('MyDream') or exit('{Error_Access_Denied}');

class SiteMaps {
    private $_url = array();
    /**
     +-----------------------------------------------------
     * 向地图文件中插入一条网址数据
     * @access public
     * @param String $loc  网址 必须提供带有 http:// 的URL
     * @param Float $lastmod 更新时间 必须为UNIX时间戳 留空则补全为当前时间
     * @param String $changefreq 更新周期 默认为每周更新 可用参数下面注释
     * @param Int $priority 网页权重 默认为 0.5(首页为1，栏目列表页为 0.8，列表分页为 0.6， 最终页面为 0.5 )
     * @return boolen
     * @author zxing 2010-04-20 16:53:22
     +-----------------------------------------------------
     * @example
     * $sitemaps = new SiteMaps();
     * $sitemaps->add('http://www.163.com/');
     +-----------------------------------------------------
     * $changefreq 可选参数：
     * always hourly daily weekly mothly yearly never
     */
    public function add($loc,$lastmod=0,$changefreq='weekly',$priority=0.5) {
        // 补全和检查URL地址
        if(substr($loc, 0,1) == '/' ) {// 检查是否以斜线开头
            $loc = 'http://'.$_SERVER['HTTP_HOST'].$loc;
        }elseif( substr($loc, 0,7) !='http://' ) { // 检查是否以 http:// 开头
            // 抛出错误
            return false;
        }
        // 检查给出的最后更新时间
        $lastmod = intval($lastmod);
        if(empty($lastmod)) {
            $lastmod = time();
        }
        // 检查更新周期
        if (!in_array($changefreq, array('always','hourly','daily','weekly','mothly','yearly','never'))) {
            $changefreq = 'weekly';
        }
        // 检查给定的权重
        if(!is_numeric($priority) || $priority>1 || $priority<0) {
            $priority = 0.5;
        }
        // 整理完成保存这条合格的信息
        $this->_url[] = array('loc'=>$loc,'lastmod'=>date(DATE_W3C,$lastmod),'changefreq'=>$changefreq,'priority'=>$priority);
        return true;
    }
    /**
     +-----------------------------------------------------
     * 输出地图文件
     * @access public
     * @param String $file_name  要生成的文件名 留空则输出xml文件 后缀可以是 .xml 和.gz 两种 如果是 .gz则自动生成压缩文件
     * @return boolen
     * @author zxing 2010-04-20 17:23:09
     +-----------------------------------------------------
     * @example
     * $sitemaps->display('/web/sitemaps.xml');
     */
    public function display($file_name='') {
        $result = FALSE;
        $file_name = trim($file_name);
        // 组合XML内容
        $sitemaps = '<?xml version="1.0" encoding="UTF-8"?><urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';
        foreach ($this->_url as $url){
            $sitemaps .= '<url>';
            foreach($url as $key=>$value){
                $sitemaps .= '<'.$key.'>'.$value.'</'.$key.'>';
            }
            $sitemaps .= '</url>';
        }
        $sitemaps .= '</urlset>';
        // 输出
        if( !empty($file_name)) {
            if(substr($file_name, -3)=='.gz') {
                // 如果要求生成GZIP格式的压缩文件
                $handle = gzopen($file_name, 'w');
                if($handle) {
                    $result = gzwrite($handle, $sitemaps);
                    gzclose($handle);
                }
            }else {
                // 否则生成XML格式的存文本文件
                $handle = fopen($file_name, 'w');
                if($handle) {
                    $result = fwrite($handle, $sitemaps);
                    fclose($handle);
                }
            }
        }else {
            // ob_clean();
            header('Content-Type: text/xml;charset=UTF-8');
            echo $sitemaps;
            $result = true;
        }
        return $result;
    }
}