<?php
/**
 +---------------------------------------------------------
 * 图片水印类 提供为jpg格式的图片添加png图片的水印，并保持png的透明状态 
 +---------------------------------------------------------
 * @name      Watermark.class.php
 * @copyright http://www.97md.net 
 * @access    MyDream
 * @author    zxing@m148.org  Thu Oct 22 22:56:18 CST 2009
 * @version   Thu Oct 22 22:56:18 CST 2009
 +---------------------------------------------------------
 * @example
 */
defined('MyDream') or exit('{Error_Access_Denied}');

class Watermark{
    private $_png_mark;
    private $_mark_w;
    private $_mark_h;
    /**
     +-----------------------------------------------------
     * 加载PNG格式的水印图片
     * @access public
     * @param String $png_mark_path 水印图片的地址
     * @param Int $mark_w 水印图片宽度
     * @param Int $mark_h 水印图片高度
     * @return Void
     * @author zxing@m148.org Thu Oct 22 23:30:08 CST 2009
     +-----------------------------------------------------
     * @example
     */
    public function __construct($png_mark_path){
       $this->_png_mark = imagecreatefrompng($png_mark_path);
       imagesavealpha($this->_png_mark, true);
       // 取得水印图片的宽高
       $this->_mark_w = imagesx($this->_png_mark);
       $this->_mark_h = imagesy($this->_png_mark);
    }
    public function __destruct(){
        if ($this->_png_mark){
            imagedestroy($this->_png_mark);
        }
    }
    /**
     +-----------------------------------------------------
     * 为制定的图片添加水印 仅支持 jpg格式 其他格式请自己转换
     * @access public
     * @param String $file
     * @return Void
     * @author zxing@m148.org Thu Oct 22 23:31:31 CST 2009
     +-----------------------------------------------------
     * @example
     * 
     */
    public function mark($file){
        $im = imagecreatefromjpeg($file);
        $img_w = imagesx($im);
        $img_h = imagesy($im);
        // 添加水印
        imagecopy($im, $this->_png_mark, rand(1,intval($img_w - $this->_mark_w)), rand(max(0,$img_h-2*$this->_mark_h),max(0,$img_h-$this->_mark_h)), 0, 0, $this->_mark_w, $this->_mark_h); 
        imagejpeg($im,$file);
        imagedestroy($im);
    }
}