<?php
/**
 +---------------------------------------------------------
 * 验证码类 用来输出四个字母或者数字
 +---------------------------------------------------------
 * @name      captcha.class.php
 * @copyright http://www.97md.net 
 * @access    MyDream
 * @author    zxing@m148.org  Thu Oct 08 17:01:34 CST 2009
 * @version   Thu Oct 08 17:01:34 CST 2009
 +---------------------------------------------------------
 * @example
 * // 类初始化并设置存储方式 
 * $captcha = new captcha();
 * $captcha->set('save_mode','session');
 * // 输出验证码图片 参数为内容组成 9数字 a小写字母 A大写字母
 * $captcha->ShowImg('9aA');
 * // 验证用户输入的验证码是否正确，如果正确则销毁之下次再请求验证则验证码是错误的
 * $captcha->Check('input_value');
 */
defined('MyDream') or exit('{Error_Access_Denied}');

defined('CAPTCHA_FONT_TYPE') or define('CAPTCHA_FONT_TYPE',MD_ROOT.DATA_ROOT.'/Common/mriam.ttf');

class captcha {
    private $_seting = array();
    private $_im = null;
    private $scode = null;
    function __construct(){
        $seting = array();
        $seting['key_name'] = __CLASS__.'_session_key';
        $seting['save_mode'] = 'session'; //存储方法 可选 cookie
        $this->_seting = $seting;
    }
    /**
     +-----------------------------------------------------
     * 设置验证码信息
     * @access public
     * @param String $var
     * @param String $value
     * @return Void
     * @author zxing@m148.org Thu Oct 08 17:03:11 CST 2009
     +-----------------------------------------------------
     * @example
     */
    public function set($var,$value){
        $result = false;
        if (isset($this->_seting[$var])){
            $this->_seting[$var] = $value;
            $result = true;
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * 检查验证码是否正确 如果正确将销毁原来的验证码信息
     * @access public
     * @param String $input_value
     * @return Void
     * @author zxing@m148.org Thu Oct 08 17:03:59 CST 2009
     +-----------------------------------------------------
     * @example
     */
    public function Check($input_value){
        $result = false;
        try {
            $input_value = md5(strtolower($input_value).'zxing');
            $server_valur = '';
            $key = $this->_seting['key_name'];
            if ($this->_seting['save_mode']=='cookie'){
                if (!isset($_COOKIE[$key])){
                    throw new Exception('error');                    
                }
                $server_valur = $_COOKIE[$key];
            }else{
                if (!isset($_SESSION)){
                    session_start();
                }
                if (!isset($_SESSION[$key])){
                    throw new Exception('error');
                }
                $server_valur = $_SESSION[$key];
            }
            if ($input_value!=$server_valur){
                throw new Exception('error');
            }
            $result = true;
            // 销毁已经存在的验证码
            if ($this->_seting['save_mode']=='cookie'){
                setcookie($this->_seting['key_name'],md5('zxing'),time()-3600,'/');
            }else{
                $_SESSION[$this->_seting['key_name']] = '';
            }
        }catch (Exception $e){
            $result = false;
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * 展示图片
     * @access public
     * @param String $type
     * @return Void
     * @author zxing@m148.org Thu Oct 08 17:05:23 CST 2009
     +-----------------------------------------------------
     * @example
     */
    public function ShowImg($type=9){
        $result = false;
        if (function_exists('imagecreate')){//检查GD支持
            $this->_im = imagecreate(80,30); //图片大小
            $font_type = CAPTCHA_FONT_TYPE; //字体
            if (!is_file($font_type) || !file_exists($font_type)){
                $type = str_replace('c','A',$type);//中文显示必须使用字体
            }
            $c_1 =  mt_rand(184,204);
            $c_2 =  mt_rand(226,246);
            $c_3 =  mt_rand(157,177);
            $bgcolor = ImageColorAllocate($this->_im, $c_1 , $c_2 , $c_3 ); //背景颜色
            $iborder = ImageColorAllocate($this->_im, 113,118,103); //边框颜色
            $fontColor2 = ImageColorAllocate($this->_im, mt_rand(0,80),mt_rand(0,80),mt_rand(0,80));//字体颜色 支持 imagettftext
            $fontColor1 = ImageColorAllocate($this->_im, 189,192,184);//阴影
            $bgcolor_img = ImageColorAllocate($this->_im, $c_1-mt_rand(40,80),$c_2-mt_rand(40,80),$c_3-mt_rand(40,80)); //干扰物颜色
            //绘制干扰物
            for ($i=0;$i<100;$i++){//稀疏点群 100个点
                imagesetpixel($this->_im, mt_rand(0,80) , mt_rand(0,30) , $bgcolor_img);
            }
            $x = mt_rand(10,55); $y = mt_rand(5,25);
            for ($i=0;$i<400;$i++){//密集点群 300个点
                imagesetpixel($this->_im, mt_rand($x-15,$x+15) , mt_rand($y-10,$y+10) , $bgcolor_img);
            }
            $x = mt_rand(0,4); $y = mt_rand(0,4);
            for ($i=0;$i<30;$i++){//网格
                imageline($this->_im, $x + 5*$i , mt_rand(0,20) , $x + 5*$i , mt_rand(20,40), $bgcolor_img);
                if ($i%3==0){
                    imageline($this->_im,mt_rand(0,40),$y + $i + 2, mt_rand(40,80),$y + $i + 2, $bgcolor_img);
                }
            }
            imagerectangle($this->_im, 0, 0, 79, 29, $iborder); //边框
            $this->RandString($type);//取得一个随即数
            $rndcodelen = strlen($this->scode);//计算随机数的长度
            $rndstring = array();
            for ($i=0;$i<$rndcodelen;$i++){
                $rndstring[] = substr($this->scode,$i,1);
            }
            $strposs = array();
            for($i = 0; $i < $rndcodelen; $i ++){ //文字
                if(is_file($font_type) && file_exists($font_type)){
                    $strposs[$i][0] = $i * 18 + rand(-5,5)+8;
                    $strposs[$i][1] = mt_rand(20,25);
                    $strposs[$i][2] = mt_rand(-20,20);
                    //阴影
                    imagettftext($this->_im, 18, $strposs[$i][2], $strposs[$i][0] + 1, $strposs[$i][1] + 1, $fontColor1, $font_type, $rndstring[$i]);
                    //文字
                    imagettftext($this->_im, 18, $strposs[$i][2], $strposs[$i][0] - 1, $strposs[$i][1] - 1, $fontColor2, $font_type, $rndstring[$i]);
                }else{
                    imagestring($this->_im, rand(1,5), $i*10+6, mt_rand(13,19), $rndstring[$i], $fontColor1);
                }
            }
            header("Pragma:no-cache\r\n");
            header("Cache-Control:no-cache\r\n");
            header("Expires:0\r\n");
            if(function_exists("imagepng")){
                header("content-type:image/png\r\n");
                imagepng($this->_im);
            }else{
                header("content-type:image/gif\r\n");
                imagecolortransparent($this->_im);
                imagejpeg($this->_im);
            }
            ImageDestroy($this->_im);
        }else{
            header("content-type:image/jpeg\r\n");
            header("Pragma:no-cache\r\n");
            header("Cache-Control:no-cache\r\n");
            header("Expires:0\r\n");
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * 取得一个随机数 并写入到SESSION里面
     * @access private
     * @param String $type
     * @return Void
     * @author zxing@m148.org Thu Oct 08 17:51:34 CST 2009
     +-----------------------------------------------------
     * @example
     */
    private function RandString($type){
        $result = '';
        $base = array(
        '23456789',
        'abcdefghjkmnpqrstuvwxyz',
        'ABCDEFGHJKMNPQRSTUVWXYZ',
        );
        $rand = '';
        if (strstr($type,'9')) $rand .= $base[0];
        if (strstr($type,'a')) $rand .= $base[1];
        if (strstr($type,'A')) $rand .= $base[2];
        for ($i=0;$i<4;$i++){
            $result .= substr($rand,rand(0,strlen($rand)-1),1);
        }
        $this->scode = $result;
        if ($this->_seting['save_mode']=='cookie'){
            setcookie($this->_seting['key_name'],md5(strtolower($this->scode).'zxing'),time()+3600,'/');
        }else{
            if (!isset($_SESSION)){
                session_start();
            }
            $_SESSION[$this->_seting['key_name']] = md5(strtolower($this->scode).'zxing');
        }
        return $result;
    }
}