<?php
/**
 +---------------------------------------------------------
 * 图片缩放类
 +---------------------------------------------------------
 * @name      reSizeImage.class.php
 * @copyright http://www.97md.net 
 * @access    MyDream
 * @author    zxing@m148.org  Wed Oct 21 11:21:01 CST 2009
 * @version   Wed Oct 21 11:21:01 CST 2009
 +---------------------------------------------------------
 * @example
 */
defined('MyDream') or exit('{Error_Access_Denied}');

class reSizeImage{
	//图片类型
	private $type;
	//实际宽度
	private $width;
	//实际高度
	private $height;
	//改变后的宽度
	private $resize_width;
	//改变后的高度
	private $resize_height;
	//源图象
	private $srcimg;
	//目标图象地址[separator]
	private $dstimg;
	//临时创建的图象
	private $im;
	// 是否重命名裁剪后的文件  否则删除原文件重建之
	private $re_name;
	public function __construct($img, $wid=128, $hei=128,$re_name=false){
		$this->srcimg = $img;
		$this->resize_width = $wid;
		$this->resize_height = $hei;
		$this->re_name = $re_name;
		//图片的类型
		$this->type = substr(strrchr($this->srcimg,"."),1);
		//初始化图象
		$this->initi_img();
		//目标图象地址
		$this -> dst_img();
		//--
		$this->width = imagesx($this->im);
		$this->height = imagesy($this->im);
		if ( $this->width >$this->resize_width || $this->height > $this->resize_height){
			//生成图象
			$this->newimg();			
		}
		ImageDestroy ($this->im);
	}
	private function newimg(){
		if (!$this->re_name){
			unlink($this->srcimg);
		}
		//改变后的图象的比例
		$resize_ratio = ($this->resize_width)/($this->resize_height);
		//实际图象的比例
		$ratio = ($this->width)/($this->height);
		//裁图
		if($ratio>=$resize_ratio){
			//高度优先  裁宽度 x轴的值
			$newimg = imagecreatetruecolor($this->resize_width,$this->resize_height);
			imagecopyresampled($newimg, $this->im, 0, 0, ( $this->width - (($this->height)*$resize_ratio))/2, 0, $this->resize_width,$this->resize_height, (($this->height)*$resize_ratio), $this->height);
			ImageJpeg ($newimg,$this->dstimg);
		}
		if($ratio<$resize_ratio){
			//宽度优先 裁高度 y轴的值
			$newimg = imagecreatetruecolor($this->resize_width,$this->resize_height);
			imagecopyresampled($newimg, $this->im, 0, 0, 0, ($this->height -(($this->width)/$resize_ratio))/2, $this->resize_width, $this->resize_height, $this->width, (($this->width)/$resize_ratio));
			ImageJpeg ($newimg,$this->dstimg);
		}
	}
	//初始化图象
	private function initi_img(){
		switch (strtolower($this->type)){
			case 'jpg':
				$this->im = imagecreatefromjpeg($this->srcimg);
				break;
			case 'gif':
				$this->im = imagecreatefromgif($this->srcimg);
				break;
			case 'png':
				$this->im = imagecreatefrompng($this->srcimg);
				break;
		}		
	}
	//图象目标地址
	private function dst_img(){
		if ($this->re_name){
			$this->dstimg = dirname($this->srcimg);
			$this->dstimg = str_replace('\\','/',$this->dstimg);
			if (substr($this->dstimg,-1) == '/'){
				$this->dstimg = substr($this->dstimg,0,-1);
			}
			$name = substr($this->srcimg,strlen($this->dstimg)+1);
			$this->dstimg .= '/'.$this->re_name;
		}else{
			$this->dstimg = $this->srcimg;
		}
	}
}