<?php
/**
 +---------------------------------------------------------
 *  SMTP 邮件发送类
 +---------------------------------------------------------
 * @name      smtp.class.php
 * @copyright http://www.97md.net
 * @access    MyDream
 * @author    zxing@97md.net
 * @version   2010-07-16 14:20:46
 +---------------------------------------------------------
 * @example
 * $smtp_cfg = array('host'=>'localhost','port'=>25,'auth'=>true,'user'=>'zxing@97md.net','pass'=>'123456')
 * $smtp_obj = new smtp($smtp_cfg);
 * // 参数 收件人 发件人显示名 邮件标题  邮件内容 回复邮箱(点击回复邮件时的收件箱)
 * $smtp_obj -> sendmail(  'zx860106@163.com',  '纵横网','邮件标题','邮件内容','zxing@97md.net');
 */
defined('MyDream') or exit('Error: Access Denied!');

class smtp {
    public $smtp_host;//smtp服务器，例如 smtp.163.com
    public $smtp_port = 25;//smtp服务器端口，默认为25
    public $auth = TRUE;//smtp服务器是否需要认证
    public $user;//邮件帐号，例如 zx860106@163.com
    public $pass;//邮箱密码
    public $debug = FALSE;//是否显示调试信息
    private $_time_out;//超时时间
    private $_isCMailServer = false;// 是否 CMailServer 服务器
    private $_host_name;//主机名
    private $_log_file;//日志文件
    private $_sock;//_socket 句柄

    /**
     * 功能描述： 构造函数，连接smtp服务器
     * 函数名称： __construct
     * 参数列表：
     *          string $host smtp服务器
     *          int $port smtp服务器端口
     *          bool $auth smtp服务器是否需要认证
     *          string $user smtp 服务器邮件帐号
     *          string $pass smtp服务器邮件密码
     * 返回类型： true
     * 创建时间： Mon Aug 25 09:50:28 CST 2008
     */
    public function __construct($smtp=array('host'=>'localhost','port'=>25,'auth'=>false,'user'=>'','pass'=>'')) {
        $this->debug = false;
        $this->smtp_port = trim($smtp['port']);
        $this->smtp_host = trim($smtp['host']);
        $this->_time_out = 30; //is used in f_sockopen()
        $this->auth = trim($smtp['auth']);//auth
        $this->user = trim($smtp['user']);
        $this->pass = trim($smtp['pass']);
        $this->_host_name = $_SERVER['HTTP_HOST']; //is used in HELO command
        $this->_log_file = '';
        $this->_sock = false;
        return true;
    }

    /**
     * 功能描述： 发送邮件的主函数
     * 函数名称： sendmail
     * 参数列表：
     *          string $to  收件人
     *          string $mail_from 发件人名称 网站名字自定义等
     *          string $subject 邮件主题
     *          string $body 邮件正文 UTF-8编码将使用
     *          string $mailtype 邮件类型，可选项为 HTML 、TEXT
     *          string $cc 抄送邮件
     *          string $bcc 暗送邮件
     *          string $additional_headers 附件
     * 返回类型： bool
     * 创建时间： Mon Aug 25 10:45:19 CST 2008  zxing
     */
    public function sendmail($to, $mail_from,  $subject = '', $body = '', $reply ='' ,  $mailtype = "HTML", $cc = '', $bcc = '', $additional_headers = '') {
        $to = trim($to);
        $from = $this->user;
        $body =  str_replace("\r\n.", " \r\n..", str_replace("\n", "\r\n", str_replace("\r", "\n", str_replace("\r\n", "\n", str_replace("\n\r", "\r", $body)))));
        $header = "MIME-Version:1.0\r\n";
        if(strtoupper($mailtype) == "HTML") {
            $header .= "Content-Type:text/html;charset=utf-8\r\n";
        }
        $header .= "To: ".$to."\r\n";
        if ($cc != '') {
            $header .= "Cc: ".$cc."\r\n";
        }
        $header .= "From: ".$this->get_mailfrom($from, $mail_from)."\r\n";
        $header .= "Subject: =?utf-8?B?"  . base64_encode( str_replace(  array("\r","\n") , '' , $subject ) ) .  "?=\r\n";
        $header .= $additional_headers;
        $header .= "Date: ".date("r")."\r\n";
        $header .= "X-Mailer:By PHP ".phpversion()." / zxing@97md.net \r\n";
        list($msec, $sec) = explode(' ', microtime());
        $header .= "Message-ID: <".date('YmdHis', $sec).".".($msec*1000000).".".substr($from,strpos($from,'@')).">\r\n";
        if( empty($reply) ){
            $reply = $from;
        }
        $header .= "Reply-To: =?utf-8?B?" . base64_encode($mail_from) . "?= <" . $reply . ">\r\n";
        $TO = explode(',', $this->strip_comment($to));
        if ($cc != '') {
            $TO = array_merge($TO, explode(',', $this->strip_comment($cc)));
        }
        if ($bcc != '') {
            $TO = array_merge($TO, explode(',', $this->strip_comment($bcc)));
        }
        $sent = TRUE;

        foreach ($TO as $rcpt_to) {
            $rcpt_to = $this->get_address($rcpt_to);
            if (!$this->smtp__sockopen($rcpt_to)) {
                $this->log_write("Error: Cannot send email to ".$rcpt_to."\n");
                $sent = FALSE;
                continue;
            }
            if ($this->smtp_send($this->_host_name, $from, $rcpt_to, $header, $body)) {
                $this->log_write("E-mail has been sent to <".$rcpt_to.">\n");
            }else {
                $this->log_write("Error: Cannot send email to <".$rcpt_to.">\n");
                $sent = FALSE;
            }
            fclose($this->_sock);
            $this->log_write("Disconnected from remote host\n");
        }
        return $sent;
    }

    private function smtp_send($helo, $from, $to, $header, $body = '') {
        if(!$this->smtp_putcmd("HELO", $helo)) {
            return $this->smtp_error("sending HELO command");
        }
        if($this->auth) {
            if (!$this->smtp_putcmd("AUTH LOGIN", base64_encode($this->user))) {
                return $this->smtp_error("sending HELO command");
            }
            if ($this->_isCMailServer) {
                if (!$this->smtp_putcmd("", base64_encode($this->user))) {
                    return $this->smtp_error("sending HELO command");
                }
            }
            if (!$this->smtp_putcmd('', base64_encode($this->pass))) {
                return $this->smtp_error("sending HELO command");
            }
        }
        if (!$this->smtp_putcmd("MAIL", "FROM:<".$from.">")) {
            return $this->smtp_error("sending MAIL FROM command");
        }
        if (!$this->smtp_putcmd("RCPT", "TO:<".$to.">")) {
            return $this->smtp_error("sending RCPT TO command");
        }
        if (!$this->smtp_putcmd("DATA")) {
            return $this->smtp_error("sending DATA command");
        }
        if (!$this->smtp_message($header, $body)) {
            return $this->smtp_error("sending message");
        }
        if (!$this->smtp_eom()) {
            return $this->smtp_error("sending <CR><LF>.<CR><LF> [EOM]");
        }
        if (!$this->smtp_putcmd("QUIT")) {
            return $this->smtp_error("sending QUIT command");
        }
        return TRUE;
    }

    private function smtp__sockopen($address) {
        if ($this->smtp_host == '') {
            return $this->smtp__sockopen_mx($address);
        }else {
            return $this->smtp__sockopen_relay();
        }
    }

    private function smtp__sockopen_relay() {
        $this->log_write("Trying to ".$this->smtp_host.":".$this->smtp_port."\n");
        $this->_sock = @fsockopen($this->smtp_host, $this->smtp_port, $errno, $errstr, $this->_time_out);
        if (!($this->_sock && $this->smtp_ok())) {
            $this->log_write("Error: Cannot connenct to relay host ".$this->smtp_host."\n");
            $this->log_write("Error: ".$errstr." (".$errno.")\n");
            return FALSE;
        }
        $this->log_write("Connected to relay host ".$this->smtp_host."\n");
        return TRUE;
    }

    private function smtp__sockopen_mx($address) {
        $domain = preg_replace("/^.+@([^@]+)$/", "\\1", $address);
        if (!@getmxrr($domain, $MXHOSTS)) {
            $this->log_write("Error: Cannot resolve MX \"".$domain."\"\n");
            return FALSE;
        }
        foreach ($MXHOSTS as $host) {
            $this->log_write("Trying to ".$host.":".$this->smtp_port."\n");
            $this->_sock = @fsockopen($host, $this->smtp_port, $errno, $errstr, $this->_time_out);
            if (!($this->_sock && $this->smtp_ok())) {
                $this->log_write("Warning: Cannot connect to mx host ".$host."\n");
                $this->log_write("Error: ".$errstr." (".$errno.")\n");
                continue;
            }
            $this->log_write("Connected to mx host ".$host."\n");
            return TRUE;
        }
        $this->log_write("Error: Cannot connect to any mx hosts (".implode(", ", $MXHOSTS).")\n");
        return FALSE;
    }

    private function smtp_message($header, $body) {
        fputs($this->_sock, $header."\r\n".$body);
        $this->smtp_debug("> ".str_replace("\r\n", "\n"."> ", $header."\n> ".$body."\n> "));
        return TRUE;
    }

    private function smtp_eom() {
        fputs($this->_sock, "\r\n.\r\n");
        $this->smtp_debug(". [EOM]\n");
        return $this->smtp_ok();
    }

    private function smtp_ok() {
        $response = str_replace("\r\n", '', fgets($this->_sock, 512));
        if (strstr($response,'CMailServer')) {
            $this->_isCMailServer = true;
        }
        $this->smtp_debug($response."\n");
        if (!preg_match("/^[23](.+?)$/", $response)) {
            fputs($this->_sock, "QUIT\r\n");
            fgets($this->_sock, 512);
            $this->log_write("Error: Remote host returned \"".$response."\"\n");
            return FALSE;
        }
        return TRUE;
    }

    private function smtp_putcmd($cmd, $arg = '') {
        if ($arg != '') {
            if($cmd=='') {
                $cmd = $arg;
            }else {
                $cmd = $cmd." ".$arg;
            }
        }
        fputs($this->_sock, $cmd."\r\n");
        $this->smtp_debug("> ".$cmd."\n");
        return $this->smtp_ok();
    }


    private function smtp_error($string) {
        $this->log_write("Error: Error occurred while ".$string.".\n");
        return FALSE;
    }

    private function log_write($message) {
        $this->smtp_debug($message);
        if ($this->_log_file == '') {
            return TRUE;
        }
        $message = date("M d H:i:s ").get_current_user()."[".getmypid()."]: ".$message;
        if (!@file_exists($this->_log_file) || !($fp = @fopen($this->_log_file, "a"))) {
            $this->smtp_debug("Warning: Cannot open log file \"".$this->_log_file."\"\n");
            return FALSE;
        }
        flock($fp, LOCK_EX);
        fputs($fp, $message);
        fclose($fp);
        return TRUE;
    }

    private function strip_comment($address) {
        $address = preg_replace("/.*\<(.+?)\>.*/", "\\1", $address);
        return $address;
    }

    private function get_address($address) {
        return trim(preg_replace("/(.*[<])?([^<>]+)[>]?/i", "$2", $address));
    }

    private function get_mailfrom($address, $mail_from) {
        return '=?utf-8?B?'.base64_encode($mail_from)."?= <".$address.">";
        // return strpos($address, '@') ? trim(preg_replace("/^([^<]*?)<([^>]+)>$/i", "$1<".$mail_from.">", $address)) : $address."<$mail_from>";
    }

    public function smtp_debug($message) {
        if ($this->debug) {
            echo $message;
        }
    }
}
