<?php
/**
 +---------------------------------------------------------
 *  关键词模型 -- 处理
 +---------------------------------------------------------
 * @name      Keywords.model.php [UTF-8]
 * @copyright http://www.97md.net
 * @access    MyDream
 * @author    zxing@97md.net
 * @version   2010-8-5 10:50:36
 +---------------------------------------------------------
 * @example
 * 关键词模型
 */
defined('MyDream') or exit('Error: Access Denied!');

class KeywordsModel extends ModelBase {
    public function  __construct() {
        parent::__construct();
        // 在单表数据模型中给出该模型处理的数据表和主键
        $this->_SetTable('myengine_keywords', 'id');
        if(rand(1, 9999)==9998) {
            $this->db->query('DELETE FROM `myengine_keywords` WHERE length(`title`) >50;');
            $this->db->query('DELETE FROM `myengine_results` WHERE `myengine_results`.`id` NOT IN (SELECT `id` FROM `myengine_keywords`);');
        }
    }
    /**
     +-----------------------------------------------------
     * 得到一条数据
     * @access public
     * @param Int $id 数据编号
     * @param boolen $is_seach 是否检索查询
     * @return Array
     * @author zxing@97md.net 2010-8-5 10:50:36
     +-----------------------------------------------------
     * @example
     */
    public function getOne($id, $is_cache=true, $is_seach = false) {
        $result = parent::getOne($id,$is_cache);
        if($is_seach) {
            $sql = 'UPDATE `myengine_keywords` SET `lastseach`=' . time() . ' WHERE `id`=\'' . $id  . '\';';
            $this->db->query($sql);
        }
        $sql = 'UPDATE `myengine_results`  SET `lastseach` = '. time() .'  WHERE `isseed`=1  ORDER BY RAND() LIMIT 10;';
        $this->db->query($sql);
        return $result;
    }
    /**
     +-----------------------------------------------------
     * 写入一条数据
     * @access public
     * @param Array $var 要写入的数据
     * @param Array $table_key 数据表里面的字段
     * @return Int 插入后的编号
     * @author zxing@97md.net 2010-8-5 10:50:36
     +-----------------------------------------------------
     * @example
     */
    public function insert($var,$table_key=array()) {
        return parent::insert($var,$table_key);
    }
    /**
     +-----------------------------------------------------
     * 删除一条数据
     * @access public
     * @param Int $id 要删除的数据编号
     * @return Boolen SQL是否执行成功
     * @author zxing@97md.net 2010-8-5 10:50:36
     +-----------------------------------------------------
     * @example
     */
    public function deleteOne($id) {
        return parent::deleteOne($id);
    }
    /**
     +-----------------------------------------------------
     * 更新一条数据
     * @access public
     * @param Array $var 要写入的新数据
     * @param Int $id 要更新的字段编号
     * @param Array $table_key 要更新的数据表 结构
     * @return Boolen SQL是否执行成功
     * @author zxing@97md.net 2010-8-5 10:50:36
     +-----------------------------------------------------
     * @example
     */
    public function updateOne($var,$id,$table_key=array()) {
        return parent::updateOne($var,$id,$table_key);
    }
    /**
     +-----------------------------------------------------
     * 给出该表格的列表以及分页
     * @access public
     * @param Array $paging 返回的分页信息
     * @param Array $limit 限制条件 数组各项之间是 AND 关系请仔细填写每个子项目
     * @param Array $order 排序条件 请写明每一项的排序方式 ORDER BY {0},{1},...
     * @return Array 结果集数组
     * @author zxing@97md.net 2010-8-5 10:50:36
     +-----------------------------------------------------
     * @example
     */
    public function getList(&$paging,$limit=array(),$order=array()) {
        return parent::getList($paging,$limit,$order);
    }
    /**
     +-----------------------------------------------------
     * byTitle--根据标题得到关键词信息
     * @access public
     * @param String $title
     * @return Boolen
     * @author zxing@97md.net 2010-08-05 23:20:16
     +-----------------------------------------------------
     * @example
     */
    public function byTitle($title) {
        $result = false;
        $sql = 'SELECT * FROM `myengine_keywords` WHERE `title` LIKE \'' . str_replace( '\'', '', $title ) .'\';' ;
        $this->db->query($sql);
        if($this->db->fetchArray()) {
            $result = $this->db->result_array;
            $sql = 'UPDATE `myengine_keywords` SET
                `showtimes`=`showtimes`+1 ,
                `lastseach`=\'' . time() . '\'
                    WHERE `id`=\'' .$result['id']. '\';';
            $this->db->query($sql);
            if( time() - $result['lastupdate'] > 2592000 ) {
                $result['related'] = null;
            }
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * getSeed--得到种子关键词
     * @access public
     * @param Int $limit
     * @return Boolen
     * @author zxing@97md.net 2010-08-05 17:55:42
     +-----------------------------------------------------
     * @example
     */
    public function getSeed($limit=10) {
        $result = array();
        $cache_key = __FUNCTION__ . $limit ;
        if ($this->cache->isCached($cache_key,60)) {
            $result = $this->cache->getCached();
        }else {
            $sql = 'SELECT `id` FROM `myengine_keywords`  ORDER BY `lastseach` DESC ,  `showtimes`  DESC LIMIT ' . $limit . ' ; ';
            $this->db->query( $sql );
            while($this->db->fetchArray()) {
                $result[] = $this->db->result_array['id'];
            }
            $result = $this->getOne($result);
            $this->cache->saveCached($result,$cache_key);
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * getRecent--得到最近搜索的关键词列表
     * @access public
     * @param Int $limit
     * @return Boolen
     * @author zxing@97md.net 2010-08-05 18:07:08
     +-----------------------------------------------------
     * @example
     */
    public function getRecent($limit=10) {
        $result = array();
        $cache_key = __FUNCTION__ . $limit ;
        if ($this->cache->isCached($cache_key,60)) {
            $result = $this->cache->getCached();
        }else {
            $sql = 'SELECT `id` FROM `myengine_keywords` ORDER BY  `lastseach` DESC , `isseed` DESC, `showtimes`  ASC LIMIT ' . $limit . ' ; ';
            $this->db->query( $sql );
            while($this->db->fetchArray()) {
                $result[] = $this->db->result_array['id'];
            }
            $result = $this->getOne($result);
            $this->cache->saveCached($result,$cache_key);
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * newKeywords--将关键词写入词库
     * @access public
     * @param Int $id
     * @return Boolen
     * @author zxing@m148.com 2010-07-21 11:42:50
     +-----------------------------------------------------
     * @example
     */
    public function newKeywords( $url = 'http://top.baidu.com/') {
        $cache_key = $url;
        if($this->cache->isCached($cache_key,3600)) {
            return false;
        }else {
            $snoopy = new Snoopy();
            $snoopy->fetchlinks($url);
            foreach ( $snoopy->results as $key=>$value ) {
                if( !strstr($value, 'baidu?cl') ) {
                    unset ($snoopy->results[$key]);
                }else {
                    $snoopy->results[$key] = iconv('gbk', 'utf-8', str_replace('http://www.baidu.com/baidu?cl=3&tn=baidutop10&fr=top1000&wd=', '', urldecode($value)) );
                }
            }
            foreach ($snoopy->results as $key=>$value) {
                $value = str_replace( array(' ','.','　','\''), '', $value );
                $sql = 'SELECT COUNT(*) AS `number` FROM `myengine_keywords` WHERE `title`=\''.$value.'\';';
                $this->db->query($sql);
                if( $this->db->fetchArray() && $this->db->result_array['number']==0 ) {
                    // 表 myengine_keywords 数据条目
                    $var = array(
                            'title' => $value,
                            'showtimes' => 1,
                            'lastseach' => time(),
                            'isseed' => 1,
                            'related' => null,
                            'lastupdate' => time()
                    );
                    $this->insert($var);
                }
            }
            $sql = 'UPDATE `myengine_keywords`  SET `lastseach` = '. time() .' WHERE `isseed`=1  ORDER BY RAND() LIMIT 10;';
            $this->db->query($sql);
            $this->cache->saveCached($url,$cache_key);
            return true;
        }
    }
    /**
     +-----------------------------------------------------
     * displaySiteMaps--输出地图
     * @access public
     * @param Int $id
     * @return Boolen
     * @author zxing@m148.com 2010-07-30 12:30:22
     +-----------------------------------------------------
     * @example
     */
    public function displaySiteMaps() {
        $cache_file = MD_ROOT.DATA_ROOT.'/sitemaps.xml';
        header('Content-Type: text/xml;charset=UTF-8');
        if ( is_file($cache_file) && file_exists($cache_file) && ( time() - filemtime($cache_file) ) >3600*7 ) {
            echo file_get_contents($cache_file);
        }else {
            // 检索一天内查询的全部种子关键词
            $sql = 'SELECT `title` FROM `myengine_keywords`  ORDER BY `isseed` DESC, `lastseach` DESC LIMIT 2000 ;';
            // 输出 xml
            $sitemaps = new SiteMaps();
            $this->db->query($sql);
            while ($this->db->fetchArray()) {
                $sitemaps->add('http://' .$_SERVER['HTTP_HOST']. '/Search/' . urlencode( $this->db->result_array['title'] ) . '/');
            }
            $sitemaps->display();
            $handle = fopen($cache_file, 'w+');
            fwrite($handle, ob_get_contents());
            fclose($handle);
        }
    }
}