<?php
/**
 +---------------------------------------------------------
 *  搜索结果模型 -- 处理某一关键词的搜索结果
 +---------------------------------------------------------
 * @name      Results.moel.php [UTF-8]
 * @copyright http://www.97md.net
 * @access    MyDream
 * @author    zxing@97md.net
 * @version   2010-8-5 18:19:16
 +---------------------------------------------------------
 * @example
 */
defined('MyDream') or exit('Error: Access Denied!');

class ResultsModel extends ModelBase {
    public function  __construct() {
        parent::__construct();
        // 在单表数据模型中给出该模型处理的数据表和主键
        $this->_SetTable('myengine_results', 'id');
        if(rand(1, 999)==998) {
            $this->db->query('DELETE FROM `myengine_results` WHERE `num` < 10;');
        }
    }
    /**
     +-----------------------------------------------------
     * 得到一条数据
     * @access public
     * @param Int $id 数据编号
     * @return Array
     * @author zxing@97md.net 2010-8-5 18:19:16
     +-----------------------------------------------------
     * @example
     */
    public function getOne($id,$is_cache=true) {
        if( is_numeric($id) ) {
            $sql = 'SELECT UNCOMPRESS(`results`) AS `results`, `lastupdate`, `id`, `islock`,`all`,`num`   FROM `myengine_results` WHERE `id` = '.$id;
        }elseif( is_array($id) ) {
            $sql = 'SELECT UNCOMPRESS(`results`) AS `results`, `lastupdate`, `id`, `islock`,`all`,`num`  FROM `myengine_results` WHERE `id` IN (' . implode(',', $id ) . ');';
        }elseif( is_string($id) ) {
            $sql = 'SELECT UNCOMPRESS(`results`) AS `results`, `lastupdate`, `id`, `islock`,`all`,`num`  FROM `myengine_results` WHERE '. $id . ';';
        }
        $this->db->query($sql);
        while ($this->db->fetchArray()) {
            if( is_numeric($id) ) {
                $result = $this->db->result_array;
            }else {
                $result[ $this->db->result_array[$this->_table_id] ] = $this->db->result_array;
            }
        }
        if( time() - $result['lastupdate'] > 604800 ) {
            $result = false;
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * 写入一条数据
     * @access public
     * @param Array $var 要写入的数据
     * @param Array $table_key 数据表里面的字段
     * @return Int 插入后的编号
     * @author zxing@97md.net 2010-8-5 18:19:16
     +-----------------------------------------------------
     * @example
     */
    public function insert($var,$table_key=array()) {
        if ( !empty($var) ) {
            $sql    = 'INSERT INTO `myengine_results` SET ';
            foreach ($var as $key=>$value) {
                if (!empty($table_key) && !in_array($key,$table_key)) {
                    continue;
                }
                if($key=='results') {
                    $sql .= '  `results` = COMPRESS(\''.$value.'\'),';
                }elseif ($value===null) {
                    $sql .= '  `'.$key.'` = null ,';
                }else {
                    $sql .= ' `'.$key.'` = \''.$value.'\',';
                }
            }
            $sql = substr($sql,0,-1);

            // 执行SQL语句
            $result = $this->db->query($sql);
            if ($result) {
                $result = $this->db->getInsertId();
                if (!$result) {
                    $result = true;
                }
            }else {
                $_ENV['ERROR'] = $sql;
                header ('SQLERROR: ' . $this->db->getError());
            }
        }
        return $result;
    }
    /**
     +-----------------------------------------------------
     * 删除一条数据
     * @access public
     * @param Int $id 要删除的数据编号
     * @return Boolen SQL是否执行成功
     * @author zxing@97md.net 2010-8-5 18:19:16
     +-----------------------------------------------------
     * @example
     */
    public function deleteOne($id) {
        return parent::deleteOne($id);
    }
    /**
     +-----------------------------------------------------
     * 更新一条数据
     * @access public
     * @param Array $var 要写入的新数据
     * @param Int $id 要更新的字段编号
     * @param Array $table_key 要更新的数据表 结构
     * @return Boolen SQL是否执行成功
     * @author zxing@97md.net 2010-8-5 18:19:16
     +-----------------------------------------------------
     * @example
     */
    public function updateOne($var,$id,$table_key=array()) {
        return parent::updateOne($var,$id,$table_key);
    }
    /**
     +-----------------------------------------------------
     * 给出该表格的列表以及分页
     * @access public
     * @param Array $paging 返回的分页信息
     * @param Array $limit 限制条件 数组各项之间是 AND 关系请仔细填写每个子项目
     * @param Array $order 排序条件 请写明每一项的排序方式 ORDER BY {0},{1},...
     * @return Array 结果集数组
     * @author zxing@97md.net 2010-8-5 18:19:16
     +-----------------------------------------------------
     * @example
     */
    public function getList(&$paging,$limit=array(),$order=array()) {
        return parent::getList($paging,$limit,$order);
    }
}