<?php
/*
┌──╮╭╮╭╮╭──╮╭──╮╭──╮╭╮╭╮╭╮　　╭──╮╭╮╭╮╭──╮
│╭╮││╰╮││╭─╯╰╮╭╯│╭╮││╰╮│││　　╰╮╭╯│╰╮││╭─╯
│││││　　││╰─╮　││　│││││　　│││　　　││　│　　││╰─╮
│││││　　││╭─╯　││　│││││　　│││　　　││　│　　││╭─╯
│╰╯││╰╮││╰─╮　││　│╰╯││╰╮││╰─╮╭╯╰╮│╰╮││╰─╮
└──╯╰╯╰╯╰──╯　╰╯　╰──╯╰╯╰╯╰──╯╰──╯╰╯╰╯╰──╯

┏┣━━┣┓┣━━━━┓┏┏━┳━╯┏━┓┏━┓
┏　┏┣━╮╯━━┳━┓┓┏┳┣┳┓┃　┃┃　┃
┃　┃┃　　┃　　┃　┃┃┏┳━━┓┃　┃┣━┫
╰　╰┣━┛┃　　┃　┃┃　┃　　╮┣━┫┃　┃
┏━┳━┳┓┣━━┻━╯┃┗╯　┗┛┃　┃┣━┫
┻━┻━┻┻╰━━━━╯┗━━━━╯┗━╯╯━┛
*/
if (!defined('DNETONLINE')){
   exit(header("HTTP/1.1 403 Forbidden"));
}
function decode_header ( $str ) 
{ 
    $part = preg_split ( "/\r?\n/", $str, -1, PREG_SPLIT_NO_EMPTY ); 

    $out = array (); 

    for ( $h = 0; $h < sizeof ( $part ); $h++ ) 
    {
        if ( $h != 0 ) 
        {
            $pos = strpos ( $part[$h], ':' ); 

            $k = strtolower ( str_replace ( ' ', '', substr ( $part[$h], 0, $pos ) ) ); 

            $v = trim ( substr ( $part[$h], ( $pos + 1 ) ) ); 
        } 
        else 
        { 
            $k = 'status'; 

            $v = explode ( ' ', $part[$h] ); 

            $v = $v[1]; 
        } 

        if ( $k == 'set-cookie' ) 
        { 
                $out['cookies'][] = $v; 
        } 
        else if ( $k == 'content-type' ) 
        { 
            if ( ( $cs = strpos ( $v, ';' ) ) !== false ) 
            { 
                $out[$k] = substr ( $v, 0, $cs ); 
            } 
            else 
            { 
                $out[$k] = $v; 
            } 
        } 
        else 
        { 
            $out[$k] = $v; 
        } 
    } 

    return $out; 
}
function decode_body ( $info, $str, $eol = "\r\n" )
{
  $tmp = $str; 
  $add = strlen ( $eol ); 
  $str = ''; 
  if ( isset ( $info['transfer-encoding'] ) && $info['transfer-encoding'] == 'chunked' ) 
  { 
    do 
    { 
      $tmp = ltrim ( $tmp ); 
      $pos = strpos ( $tmp, $eol ); 
      $len = hexdec ( substr ( $tmp, 0, $pos ) );
      if ( isset ( $info['content-encoding'] ) )
      { 
        $str .= gzinflate ( substr ( $tmp, ( $pos + $add + 10 ), $len ) ); 
      } 
      else
      { 
        $str .= substr ( $tmp, ( $pos + $add ), $len ); 
      } 
     
      $tmp = substr ( $tmp, ( $len + $pos + $add ) ); 
      $check = trim ( $tmp ); 
    } 
    while ( ! empty ( $check ) ); 
  } 
  else if ( isset ( $info['content-encoding'] ) ) 
  { 
    $str = gzinflate ( substr ( $tmp, 10 ) ); 
  } 
  else { 
    $str = $tmp;
  } 
  return $str;
}
function get_file_html($url,$get='/',$port=80,$iconvs,$iconve){
	if ( ( $io = fsockopen( $url, $port, $errno, $errstr, 5 ) ) !== false )
	{
	    $send  = "GET $get HTTP/1.1\r\n";
	    $send .= "Accept: */*\r\n";
		$send .= 'Cache-Control: no-cache'."\r\n";
	    $send .= "Host: $url\r\n";
		$send .= 'Pragma: no-cache'."\r\n";
		$send .= 'Referer: http://book.qq.com/'."\r\n";
		$send .= 'User-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 1.1.4322; .NET CLR 2.0.50727)'."\r\n";
	    $send .= "Connection: Close\r\n\r\n";
		fputs ( $io, $send );
	    $send = ''; 
	    do
	    {
	        $send .= fgets ( $io, 4096 );
	
	    } while ( strpos ( $send, "\r\n\r\n" ) === false ); 

	    $info = decode_header ( $send ); 

	    $send = ''; 
	    while ( ! feof ( $io ) ) 
	    { 
	        $send .= fread ( $io, 8192 ); 
	    }
	    fclose ( $io );
	    $send = decode_body ( $info, $send );
	    //$send = preg_replace("/[\s]+/",' ',$send);
	    $replace = array("\t",'lianzaiindex/');
	    $send = str_replace($replace,'',&$send);
	    $send = str_replace('gb2312','utf-8',&$send);
	    $send = str_replace('book.qq.com','book.dnetonline.cn',&$send);
	    $send = str_replace('.htm','.html',&$send);
	    $send = str_replace('/s/book/0/15','/book',&$send);
	    $send = str_replace('.shtml','.html',&$send);
	    //V1.1增加内容 对列表中 /s/book/0/XX/YYYY/index.html 的列表处理
	    //为了不影响之前的地址 将增加一个新模块 地址变为 /book/YYYY_XX/index.html
	    $send = preg_replace('/\/s\/book\/0\/([^\/]+)\/([^\/]+)\//','/book/$2_$1/',&$send);
	    if ($iconvs) {
	    	//iconv 遇到GB2312 字符串 — 的时候会有BUG
	    	$send = iconv($iconvs,$iconve."//IGNORE",$send);
	    	return $send;
	    }else {
	    	return $send;
	    }
    }
}


function get_cookies_file($url,$get='/',$port=80,$iconvs,$iconve){
	if ( ( $io = fsockopen( $url, $port, $errno, $errstr, 5 ) ) !== false )
	{
		$send = "GET $get HTTP/1.1"."\r\n";
		$send .= 'Accept: */*'."\r\n";
		$send .= 'Cache-Control: no-cache'."\r\n";
		$send .= 'Cookie: 你的COOKIES'."\r\n";
		$send .= 'Host: bookapp.book.qq.com'."\r\n";
		$send .= 'Pragma: no-cache'."\r\n";
		$send .= "Referer: http://".$url.$get."\r\n";
		$send .= 'User-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 1.1.4322; .NET CLR 2.0.50727)'."\r\n";
		$send .= "Connection: Close\r\n\r\n";
		fputs ( $io, $send );
	    $send = ''; 
	    do
	    {
	        $send .= fgets ( $io, 4096 );
	
	    } while ( strpos ( $send, "\r\n\r\n" ) === false ); 

	    $info = decode_header ( $send ); 

	    $send = ''; 
	    while ( ! feof ( $io ) ) 
	    { 
	        $send .= fread ( $io, 8192 ); 
	    }
	    fclose ( $io );
	    $send = decode_body ( $info, $send );
	    $replace = array("\t",'lianzaiindex/');
	    $send = str_replace($replace,'',&$send);
	    $send = str_replace('gb2312','utf-8',&$send);
	    $send = str_replace('book.qq.com','book.dnetonline.cn',&$send);
	    $send = str_replace('.htm','.html',&$send);
	    $send = str_replace('/s/book/0/15','/book',&$send);
	    $send = str_replace('.shtml','.html',&$send);
	    if ($iconvs) {
	    	//iconv 遇到GB2312 字符串 — 的时候会有BUG
	    	$send = iconv($iconvs,$iconve."//IGNORE",$send);
	    	return $send;
	    }else {
	    	return $send;
	    }
    }
}

function get_gif($url,$get='/',$port=80){
	if ( ( $io = fsockopen( $url, $port, $errno, $errstr, 5 ) ) !== false )
	{
		$send = "GET $get HTTP/1.1"."\r\n";
		$send .= 'Accept: */*'."\r\n";
		$send .= 'Cache-Control: no-cache'."\r\n";
		$send .= 'Cookie: 你的COOKIES'."\r\n";
		$send .= 'Host: bookapp.book.qq.com'."\r\n";
		$send .= 'Pragma: no-cache'."\r\n";
		$send .= "Referer: http://".$url.$get."\r\n";
		$send .= 'User-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 1.1.4322; .NET CLR 2.0.50727)'."\r\n";
		$send .= "Connection: Close\r\n\r\n";
		fputs ( $io, $send );
	    $send = ''; 
	    do
	    {
	        $send .= fgets ( $io, 4096 );
	
	    } while ( strpos ( $send, "\r\n\r\n" ) === false ); 

	    $info = decode_header ( $send ); 

	    $send = ''; 
	    while ( ! feof ( $io ) ) 
	    { 
	        $send .= fread ( $io, 8192 ); 
	    }
	    fclose ( $io );
	    $send = decode_body ( $info, $send );
	    	return $send;
    }
}
function Cache($cachename){
		if (file_exists('htmlcache/'.$cachename)) {
			return file_get_contents('htmlcache/'.$cachename);			
		}else {
			return false;
		}
}
function cutstr($start,$end,&$htmlfile,$id){
	$tempstr = explode($start,$htmlfile);
	if ($id) {
		$tempstr1 = explode($end,$tempstr[$id]);
	}else {
		$tempstr1 = explode($end,$tempstr[1]);		
	}
	return $tempstr1[0];
}

function cutstrarr($start,$end,&$htmlfile){
	$tempstr = explode($start,$htmlfile);
	//return the array more
	$cutnum = count($tempstr);//if >2 is the more
	for ($i=1;$i<$cutnum;$i++){
		$thetemp = explode($end,$tempstr[$i]);
		$thestr[] = $thetemp[0];
	}
	return $thestr;
}
function dnet_tpl(&$cachename,$tplname,$strarrar=array()){
	if (!file_exists($tplname)) {
		echo $tplname.'not found';
		exit;
	}else {
		$tplfile = file_get_contents($tplname);
		$tphead = file_get_contents('tpl/head.html');
		$tpfoot = file_get_contents('tpl/foot.html');
		foreach($strarrar as $_key => $_value) {
			$tplfile = ereg_replace("\{".$_key."\}",$_value,$tplfile);
		}
		$tplfile = str_replace('{head}',$tphead,$tplfile);
		$tplfile = str_replace('{foot}',$tpfoot,$tplfile);
		$fp = fopen('htmlcache/'.$cachename,'w+');
		fwrite($fp,$tplfile);
		fclose($fp);
		return $tplfile;
	}

}
function showpage($add,$patt,$now,$allpage){
	$str = '';
	if ($now>1) {
		$str .= "<a href=\"/".$add."/".$patt."index_".($now-1).".html\" class=\"fclblack\">上一页</a>";
	}
	if (($allpage-$now)>16) {
		for ($i=$now;$i<($now+15);$i++){
			$str .= " |<a href=\"/$add/".$patt."index_$i.html\" class=\"fclblack\">$i</a>| ";
		}
	}else {
		for ($i=$now;$i<=$allpage;$i++){
			$str .= " |<a href=\"/$add/".$patt."index_".$i.".html\" class=\"fclblack\">$i</a>| ";
		}
	}
	if ($allpage > $now) {
		$str .= "<a href=\"/$add/".$patt."index_".($now+1).".html\" class=\"fclblack\">下一页</a> ";
	}
	return $str;
}