<?php
/*
+-----------------------------------------------------------------------------+
| $Id: *.php,v 1.* 2005/07/01 06:15:08 Bleakwind Exp $
| SnowStats
|         --- A Web Statistics Analysis for multiuser
| Copyright (c) 2003-2005 Weaverdream.com By Bleakwind
| http://www.weaverdream.com
+-----------------------------------------------------------------------------+
*/

include_once 'include/include.php';
include_once 'include/header.php';
?>

<table width="760" border="0" cellpadding="0" cellspacing="0" bgcolor="#5E94DD" align="center">
  <tr bgcolor="#5E94DD">
    <td width="200" align="center" valign="top" class="left_bg">
      <?include_once 'include/menu.php';?>
    </td>
    <td width="560" bgcolor="#FFFFFF" valign="top">

<?php
if( if_userlogin() != "y" && if_adminlogin() != "y" ){
    header("location:prompt.php?act=failed&url=login.php?act=login&ret=".htmlentities(urlencode($LANGUAGE['amend_login']))."&mes=".htmlentities(urlencode($LANGUAGE['amend_need_login'])));
    exit;
}
if( if_adminlogin() == "y" && if_selectuser() != "y" ){
    header("location:prompt.php?act=failed&url=login.php?act=select&ret=".htmlentities(urlencode($LANGUAGE['amend_select']))."&mes=".htmlentities(urlencode($LANGUAGE['amend_need_select'])));
    exit;
}

$user        = $_SESSION['sess_username'] ? $_SESSION['sess_username'] : $_SESSION['sess_select'];
$userdir     = $SETTING['dir_data'].$user;

$file_config = $userdir."/".$SETTING['file_config'];

include $file_config;

if(empty($_GET['act'])) {

// $CONFIGUSER['js_style'] = text
$js_text_fontfamily       = str_replace("font-family:","",$CONFIGUSER['js_text_fontfamily']);
$js_text_fontfamily       = trim(str_replace(";","",$js_text_fontfamily));

$js_text_fontsize         = str_replace("font-size:","",$CONFIGUSER['js_text_fontsize']);
$js_text_fontsize         = trim(str_replace(";","",$js_text_fontsize));
                          
$js_text_fontcolor        = str_replace("color:#","",$CONFIGUSER['js_text_fontcolor']);
$js_text_fontcolor        = trim(str_replace(";","",$js_text_fontcolor));
                          
$js_text_fontborder       = str_replace("border:","",$CONFIGUSER['js_text_fontborder']);
$js_text_fontborder       = trim(str_replace("px","",$js_text_fontborder));
                          
$js_text_fontborder_style = trim($js_text_fontborder_style);
                          
$js_text_fontborder_color = str_replace("#","",$CONFIGUSER['js_text_fontborder_color']);
$js_text_fontborder_color = trim(str_replace(";","",$js_text_fontborder_color));
                          
$js_text_fontbg_color     = str_replace("background-color:#","",$CONFIGUSER['js_text_fontbg_color']);
$js_text_fontbg_color     = trim(str_replace(";","",$js_text_fontbg_color));

// Decode 
$total_ip_text   = str_decode($CONFIGUSER['total_ip_text']);
$total_pv_text   = str_decode($CONFIGUSER['total_pv_text']);
$year_ip_text    = str_decode($CONFIGUSER['year_ip_text']);
$year_pv_text    = str_decode($CONFIGUSER['year_pv_text']);
$month_ip_text   = str_decode($CONFIGUSER['month_ip_text']);
$month_pv_text   = str_decode($CONFIGUSER['month_pv_text']);
$day_ip_text     = str_decode($CONFIGUSER['day_ip_text']);
$day_pv_text     = str_decode($CONFIGUSER['day_pv_text']);
$online_text     = str_decode($CONFIGUSER['online_text']);

$website         = str_decode($CONFIGUSER['website']);
$weburl          = str_decode($CONFIGUSER['weburl']);
$webintro        = str_decode($CONFIGUSER['webintro']);

if($CONFIGUSER['ifview'] == "y")      {$ifview_y = " checked";}else{$ifview_n = " checked";}
if($CONFIGUSER['ifadd0'] == "y")      {$ifadd0_y = " checked";}else{$ifadd0_n = " checked";}
                                                
if($CONFIGUSER['total_ip_if'] == "y") {$total_ip_if_y = " checked";}else{$total_ip_if_n = " checked";}
if($CONFIGUSER['total_pv_if'] == "y") {$total_pv_if_y = " checked";}else{$total_pv_if_n = " checked";}
if($CONFIGUSER['year_ip_if']  == "y") {$year_ip_if_y  = " checked";}else{$year_ip_if_n  = " checked";}
if($CONFIGUSER['year_pv_if']  == "y") {$year_pv_if_y  = " checked";}else{$year_pv_if_n  = " checked";}
if($CONFIGUSER['month_ip_if'] == "y") {$month_ip_if_y = " checked";}else{$month_ip_if_n = " checked";}
if($CONFIGUSER['month_pv_if'] == "y") {$month_pv_if_y = " checked";}else{$month_pv_if_n = " checked";}
if($CONFIGUSER['day_ip_if']   == "y") {$day_ip_if_y   = " checked";}else{$day_ip_if_n   = " checked";}
if($CONFIGUSER['day_pv_if']   == "y") {$day_pv_if_y   = " checked";}else{$day_pv_if_n   = " checked";}
if($CONFIGUSER['online_if']   == "y") {$online_if_y   = " checked";}else{$online_if_n   = " checked";}

switch($CONFIGUSER['mode']){
   case "js":    $mode_value['js']    = " selected";$mode_display['image'] = " style='display:none'";break;
   case "image": $mode_value['image'] = " selected";$mode_display['js']    = " style='display:none'";break;
   default:      $mode_value['js']    = " selected";$mode_display['image'] = " style='display:none'";break;
}

switch($CONFIGUSER['js_style']){
   case "js_text":    $js_style_value['js_text']    = " selected";$js_style_display['js_picture'] = $js_style_display['js_icon']    = $js_style_display['js_hidden'] = " style='display:none'";break;
   case "js_picture": $js_style_value['js_picture'] = " selected";$js_style_display['js_text']    = $js_style_display['js_icon']    = $js_style_display['js_hidden'] = " style='display:none'";break;
   case "js_icon":    $js_style_value['js_icon']    = " selected";$js_style_display['js_text']    = $js_style_display['js_picture'] = $js_style_display['js_hidden'] = " style='display:none'";break;
   case "js_hidden":  $js_style_value['js_hidden']  = " selected";$js_style_display['js_text']    = $js_style_display['js_picture'] = $js_style_display['js_icon']   = " style='display:none'";break;
   default:           $js_style_value['js_text']    = " selected";$js_style_display['js_picture'] = $js_style_display['js_icon']    = $js_style_display['js_hidden'] = " style='display:none'";break;
}

switch($CONFIGUSER['image_style']){
   case "image_custom": $image_style_value['image_custom'] = " selected";$image_style_display['image_hidden'] = " style='display:none'";break;
   case "image_hidden": $image_style_value['image_hidden'] = " selected";$image_style_display['image_custom'] = " style='display:none'";break;
   default:             $image_style_value['image_custom'] = " selected";$image_style_display['image_hidden'] = " style='display:none'";break;
}

switch($js_text_fontfamily){
   case "Arial":           $js_text_fontfamily_value['Arial']           = " selected";break;
   case "Book Antiqua":    $js_text_fontfamily_value['Book Antiqua']    = " selected";break;
   case "Century Gothic":  $js_text_fontfamily_value['Century Gothic']  = " selected";break;
   case "Courier New":     $js_text_fontfamily_value['Courier New']     = " selected";break;
   case "Courier":         $js_text_fontfamily_value['Courier']         = " selected";break;
   case "Geneva":          $js_text_fontfamily_value['Geneva']          = " selected";break;
   case "Georgia":         $js_text_fontfamily_value['Georgia']         = " selected";break;
   case "Helvetica":       $js_text_fontfamily_value['Helvetica']       = " selected";break;
   case "Impact":          $js_text_fontfamily_value['Impact']          = " selected";break;
   case "mono":            $js_text_fontfamily_value['mono']            = " selected";break;
   case "sans-serif":      $js_text_fontfamily_value['sans-serif']      = " selected";break;
   case "serif":           $js_text_fontfamily_value['serif']           = " selected";break;
   case "Tahoma":          $js_text_fontfamily_value['Tahoma']          = " selected";break;
   case "Times New Roman": $js_text_fontfamily_value['Times New Roman'] = " selected";break;
   case "Times":           $js_text_fontfamily_value['Times']           = " selected";break;
   case "Verdana":         $js_text_fontfamily_value['Verdana']         = " selected";break;
   default:                $js_text_fontfamily_value['Arial']           = " selected";break;
}

switch($js_text_fontborder_style){
   case "solid":           $js_text_fontborder_style_value['solid']     = " selected";break;
   case "dotted":          $js_text_fontborder_style_value['dotted']    = " selected";break;
   case "dashed":          $js_text_fontborder_style_value['dashed']    = " selected";break;
   case "double":          $js_text_fontborder_style_value['double']    = " selected";break;
   case "groove":          $js_text_fontborder_style_value['groove']    = " selected";break;
   case "ridge":           $js_text_fontborder_style_value['ridge']     = " selected";break;
   case "inset":           $js_text_fontborder_style_value['inset']     = " selected";break;
   case "outset":          $js_text_fontborder_style_value['outset']    = " selected";break;
   default:                $js_text_fontborder_style_value['solid']     = " selected";break;
}

?>

<table width="100%" border="0" cellspacing="0" cellpadding="3" align="center" bgcolor="#EBE9ED"><tr><td><img src="images/arrowright.gif" border=0 align="absmiddle"> <a href="index.php" target="_self"><font style="color:#000000;"><?php echo CONFIG_WEBSITE;?></font></a> &raquo; <?php echo $LANGUAGE['amend_placedir'];?> &raquo; <?php echo $LANGUAGE['amend_place'];?></td></tr></table>
<br>
<table width="95%" border="0" cellspacing="0" cellpadding="0" align="center">
<form action="amend.php?act=save" method="post" name="form">
<tr><td>

<table width="100%" border="0" cellspacing="1" cellpadding="3" align="center" bgcolor="#FFFFFF">
  <tr><td colspan="3" class="right_title"><?php echo $LANGUAGE['amend_profileinfo'];?></td></tr>
  <tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['amend_username'];?></td><td width="40%" class="right_content"><?php echo $CONFIGUSER['username'];?></td><td width="40%" class="right_content"><?php echo $LANGUAGE['amend_username_explain'];?></td></tr>
  <tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['amend_current_password'];?></td><td width="40%" class="right_content"><input type="password" name="password1" size="26" maxlength="60" class="input"></td><td width="40%" class="right_content"><?php echo $LANGUAGE['amend_current_password_explain'];?></td></tr>
  <tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['amend_new_password'];?></td><td width="40%" class="right_content"><input type="password" name="password2" size="26" maxlength="60" class="input"></td><td width="40%" class="right_content"><?php echo $LANGUAGE['amend_new_password_explain'];?></td></tr>
  <tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['amend_confirm_password'];?></td><td width="40%" class="right_content"><input type="password" name="password3" size="26" maxlength="60" class="input"></td><td width="40%" class="right_content"><?php echo $LANGUAGE['amend_confirm_password_explain'];?></td></tr>
  <tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['amend_email'];?></td><td width="40%" class="right_content"><input type="text" name="email" size="26" maxlength="160" value="<?php echo $CONFIGUSER['email'];?>" class="input"></td><td width="40%" class="right_content"></td></tr>
  <tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['amend_website'];?></td><td width="40%" class="right_content"><input type="text" name="website" size="26" maxlength="160" value="<?php echo $website;?>" class="input"></td><td width="40%" class="right_content"></td></tr>
  <tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['amend_weburl'];?></td><td width="40%" class="right_content"><input type="text" name="weburl" size="26" maxlength="160" value="<?php echo $weburl;?>" value="http://" class="input"></td><td width="40%" class="right_content"></td></tr>
  <tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['amend_webintro'];?></td><td width="40%" class="right_content"><textarea name="webintro" rows="6" cols="26" class="textarea"><?php echo $webintro;?></textarea></td><td width="40%" class="right_content"><?php echo sprintf($LANGUAGE['amend_webintro_explain'],CONFIG_WEBINTRO_LONG);?></td></tr>
</table>

<table width="100%" border="0" cellspacing="1" cellpadding="3" align="center" bgcolor="#FFFFFF">
  <tr><td colspan="3" class="right_title"><?php echo $LANGUAGE['amend_config'];?></td></tr>
  <tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['amend_length'];?></td><td width="40%" class="right_content"><input type="text" name="length" size="26" maxlength="2" value="<?php echo $CONFIGUSER['length'];?>" class="input"></td><td width="40%" class="right_content"><?php echo $LANGUAGE['amend_length_explain'];?></td></tr>
  <tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['amend_timediff'];?></td><td width="40%" class="right_content"><input type="text" name="timediff" size="26" maxlength="2" value="<?php echo $CONFIGUSER['timediff']/3600;?>" class="input"> hr.</td><td width="40%" class="right_content"><?php echo sprintf($LANGUAGE['amend_timediff_explain'],date('Y-m-d H'));?></td></tr>
  <tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['amend_ifview'];?></td><td width="40%" class="right_content"><input type="radio" name="ifview" value="y" <?php echo $ifview_y;?> class="radio_y">&nbsp;<?php echo $LANGUAGE['amend_yes'];?>&nbsp;<input type="radio" name="ifview" value="n" <?php echo $ifview_n;?> class="radio_n">&nbsp;<?php echo $LANGUAGE['amend_no'];?></td><td width="40%" class="right_content"><?php echo $LANGUAGE['amend_ifview_explain'];?></td></tr>
  <tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['amend_ifadd0'];?></td><td width="40%" class="right_content"><input type="radio" name="ifadd0" value="y" <?php echo $ifadd0_y;?> class="radio_y">&nbsp;<?php echo $LANGUAGE['amend_yes'];?>&nbsp;<input type="radio" name="ifadd0" value="n" <?php echo $ifadd0_n;?> class="radio_n">&nbsp;<?php echo $LANGUAGE['amend_no'];?></td><td width="40%" class="right_content"><?php echo $LANGUAGE['amend_ifadd0_explain'];?></td></tr>
  <tr>
    <td width="20%" class="right_subject"><?php echo $LANGUAGE['amend_language'];?></td>
    <td width="40%" class="right_content">
<?php
$file_list     = return_dir("language/");
$total_record = count($file_list);
echo "<select name='language' class='select' size=1>";
$selected = ($CONFIGUSER['language'] == CONFIG_LANGUAGE) ? " selected" : "";
echo "<option value='".CONFIG_LANGUAGE."' ".$selected.">".CONFIG_LANGUAGE."</option>";
for($i=0;$i<$total_record;$i++){
  if(trim($file_list[$i]) != CONFIG_LANGUAGE){
      $selected = ($CONFIGUSER['language'] == trim($file_list[$i])) ? " selected" : "";
      echo "<option value='".$file_list[$i]."' ".$selected.">".$file_list[$i]."</option>";
  }
}
echo "</select>";
?>
    </td>
    <td width="40%" class="right_content"><?php echo $LANGUAGE['amend_language_explain'];?></td>
  </tr>
</table>

<table width="100%" border="0" cellspacing="1" cellpadding="3" align="center" bgcolor="#FFFFFF">
  <tr><td colspan="6" align="center" class="right_title"><?php echo $LANGUAGE['amend_output_format'];?></td></tr>
  <tr align="center">
    <td width="15%" rowspan="2" class="right_subject"><?php echo $LANGUAGE['amend_output_total'];?></td>
    <td width="10%" class="right_subject"><?php echo $LANGUAGE['amend_output_ip'];?></td>
    <td width="15%" class="right_subject2"><?php echo $LANGUAGE['amend_output_ifshow'];?></td>
    <td width="25%" class="right_content"><input type="radio" name="total_ip_if" value="y" <?php echo $total_ip_if_y;?> class="radio_y"> <?php echo $LANGUAGE['amend_output_show'];?> <input type="radio" name="total_ip_if" value="n" <?php echo $total_ip_if_n;?> class="radio_n"> <?php echo $LANGUAGE['amend_output_hidden'];?></td>
    <td width="10%" class="right_subject2"><?php echo $LANGUAGE['amend_output_prefix'];?></td>
    <td width="25%" class="right_content"><textarea name="total_ip_text" rows="2" cols="20" class="textarea"><?php echo "\n".$total_ip_text;?></textarea></td>
  </tr>
  <tr align="center">
    <td width="10%" class="right_subject"><?php echo $LANGUAGE['amend_output_pv'];?></td>
    <td width="15%" class="right_subject2"><?php echo $LANGUAGE['amend_output_ifshow'];?></td>
    <td width="25%" class="right_content"><input type="radio" name="total_pv_if" value="y" <?php echo $total_pv_if_y;?> class="radio_y"> <?php echo $LANGUAGE['amend_output_show'];?> <input type="radio" name="total_pv_if" value="n" <?php echo $total_pv_if_n;?> class="radio_n"> <?php echo $LANGUAGE['amend_output_hidden'];?></td>
    <td width="10%" class="right_subject2"><?php echo $LANGUAGE['amend_output_prefix'];?></td>
    <td width="25%" class="right_content"><textarea name="total_pv_text" rows="2" cols="20" class="textarea"><?php echo "\n".$total_pv_text;?></textarea></td>
  </tr>
  <tr align="center">
    <td width="15%" rowspan="2" class="right_subject"><?php echo $LANGUAGE['amend_output_year'];?></td>
    <td width="10%" class="right_subject"><?php echo $LANGUAGE['amend_output_ip'];?></td>
    <td width="15%" class="right_subject2"><?php echo $LANGUAGE['amend_output_ifshow'];?></td>
    <td width="25%" class="right_content"><input type="radio" name="year_ip_if" value="y" <?php echo $year_ip_if_y;?> class="radio_y"> <?php echo $LANGUAGE['amend_output_show'];?> <input type="radio" name="year_ip_if" value="n" <?php echo $year_ip_if_n;?> class="radio_n"> <?php echo $LANGUAGE['amend_output_hidden'];?></td>
    <td width="10%" class="right_subject2"><?php echo $LANGUAGE['amend_output_prefix'];?></td>
    <td width="25%" class="right_content"><textarea name="year_ip_text" rows="2" cols="20" class="textarea"><?php echo "\n".$year_ip_text;?></textarea></td>
  </tr>
  <tr align="center">
    <td width="10%" class="right_subject"><?php echo $LANGUAGE['amend_output_pv'];?></td>
    <td width="15%" class="right_subject2"><?php echo $LANGUAGE['amend_output_ifshow'];?></td>
    <td width="25%" class="right_content"><input type="radio" name="year_pv_if" value="y" <?php echo $year_pv_if_y;?> class="radio_y"> <?php echo $LANGUAGE['amend_output_show'];?> <input type="radio" name="year_pv_if" value="n" <?php echo $year_pv_if_n;?> class="radio_n"> <?php echo $LANGUAGE['amend_output_hidden'];?></td>
    <td width="10%" class="right_subject2"><?php echo $LANGUAGE['amend_output_prefix'];?></td>
    <td width="25%" class="right_content"><textarea name="year_pv_text" rows="2" cols="20" class="textarea"><?php echo "\n".$year_pv_text;?></textarea></td>
  </tr>
  <tr align="center">
    <td width="15%" rowspan="2" class="right_subject"><?php echo $LANGUAGE['amend_output_month'];?></td>
    <td width="10%" class="right_subject"><?php echo $LANGUAGE['amend_output_ip'];?></td>
    <td width="15%" class="right_subject2"><?php echo $LANGUAGE['amend_output_ifshow'];?></td>
    <td width="25%" class="right_content"><input type="radio" name="month_ip_if" value="y" <?php echo $month_ip_if_y;?> class="radio_y"> <?php echo $LANGUAGE['amend_output_show'];?> <input type="radio" name="month_ip_if" value="n" <?php echo $month_ip_if_n;?> class="radio_n"> <?php echo $LANGUAGE['amend_output_hidden'];?></td>
    <td width="10%" class="right_subject2"><?php echo $LANGUAGE['amend_output_prefix'];?></td>
    <td width="25%" class="right_content"><textarea name="month_ip_text" rows="2" cols="20" class="textarea"><?php echo "\n".$month_ip_text;?></textarea></td>
  </tr>
  <tr align="center">
    <td width="10%" class="right_subject"><?php echo $LANGUAGE['amend_output_pv'];?></td>
    <td width="15%" class="right_subject2"><?php echo $LANGUAGE['amend_output_ifshow'];?></td>
    <td width="25%" class="right_content"><input type="radio" name="month_pv_if" value="y" <?php echo $month_pv_if_y;?> class="radio_y"> <?php echo $LANGUAGE['amend_output_show'];?> <input type="radio" name="month_pv_if" value="n" <?php echo $month_pv_if_n;?> class="radio_n"> <?php echo $LANGUAGE['amend_output_hidden'];?></td>
    <td width="10%" class="right_subject2"><?php echo $LANGUAGE['amend_output_prefix'];?></td>
    <td width="25%" class="right_content"><textarea name="month_pv_text" rows="2" cols="20" class="textarea"><?php echo "\n".$month_pv_text;?></textarea></td>
  </tr>
  <tr align="center">
    <td width="15%" rowspan="2" class="right_subject"><?php echo $LANGUAGE['amend_output_day'];?></td>
    <td width="10%" class="right_subject"><?php echo $LANGUAGE['amend_output_ip'];?></td>
    <td width="15%" class="right_subject2"><?php echo $LANGUAGE['amend_output_ifshow'];?></td>
    <td width="25%" class="right_content"><input type="radio" name="day_ip_if" value="y" <?php echo $day_ip_if_y;?> class="radio_y"> <?php echo $LANGUAGE['amend_output_show'];?> <input type="radio" name="day_ip_if" value="n" <?php echo $day_ip_if_n;?> class="radio_n"> <?php echo $LANGUAGE['amend_output_hidden'];?></td>
    <td width="10%" class="right_subject2"><?php echo $LANGUAGE['amend_output_prefix'];?></td>
    <td width="25%" class="right_content"><textarea name="day_ip_text" rows="2" cols="20" class="textarea"><?php echo "\n".$day_ip_text;?></textarea></td>
  </tr>
  <tr align="center">
    <td width="10%" class="right_subject"><?php echo $LANGUAGE['amend_output_pv'];?></td>
    <td width="15%" class="right_subject2"><?php echo $LANGUAGE['amend_output_ifshow'];?></td>
    <td width="25%" class="right_content"><input type="radio" name="day_pv_if" value="y" <?php echo $day_pv_if_y;?> class="radio_y"> <?php echo $LANGUAGE['amend_output_show'];?> <input type="radio" name="day_pv_if" value="n" <?php echo $day_pv_if_n;?> class="radio_n"> <?php echo $LANGUAGE['amend_output_hidden'];?></td>
    <td width="10%" class="right_subject2"><?php echo $LANGUAGE['amend_output_prefix'];?></td>
    <td width="25%" class="right_content"><textarea name="day_pv_text" rows="2" cols="20" class="textarea"><?php echo "\n".$day_pv_text;?></textarea></td>
  </tr>
  <tr align="center">
    <td colspan="2" class="right_subject"><?php echo $LANGUAGE['amend_output_online'];?></td>
    <td width="15%" class="right_subject2"><?php echo $LANGUAGE['amend_output_ifshow'];?></td>
    <td width="25%" class="right_content"><input type="radio" name="online_if" value="y" <?php echo $online_if_y;?> class="radio_y"> <?php echo $LANGUAGE['amend_output_show'];?> <input type="radio" name="online_if" value="n" <?php echo $online_if_n;?> class="radio_n"> <?php echo $LANGUAGE['amend_output_hidden'];?></td>
    <td width="10%" class="right_subject2"><?php echo $LANGUAGE['amend_output_prefix'];?></td>
    <td width="25%" class="right_content"><textarea name="online_text" rows="2" cols="20" class="textarea"><?php echo "\n".$online_text;?></textarea></td>
  </tr>
</table>

<table width="100%" border="0" cellspacing="1" cellpadding="3" align="center" bgcolor="#FFFFFF">
  <tr><td colspan="3" align="center" class="right_title"><?php echo $LANGUAGE['amend_mode_style'];?></td></tr>
  <tr>
    <td width="20%" class="right_subject"><?php echo $LANGUAGE['amend_mode_select'];?></td>
    <td width="40%" class="right_content">
      <select name="mode" class="select"  onChange="for(var i=0; i<options.length; i++){eval(options[i].value).style.display=value==options[i].value?'':'none'}">
      <option value="js" <?php echo $mode_value['js'];?>><?php echo $LANGUAGE['amend_mode_js'];?></option>
      <option value="image" <?php echo $mode_value['image'];?>><?php echo $LANGUAGE['amend_mode_image'];?></option>
      </select>
    </td>
    <td width="40%" class="right_content"><?php echo $LANGUAGE['amend_mode_select_explain'];?></td>
  </tr>
</table>

<!-- begin js mode -->
<div id="js" <?php echo $mode_display['js'];?>>

<table width="100%" border="0" cellspacing="1" cellpadding="3" align="center" bgcolor="#FFFFFF">
  <tr>
    <td width="20%" class="right_subject2"><?php echo $LANGUAGE['amend_js_select'];?></td>
    <td width="40%" class="right_content">
      <select name="js_style" class="select"  onChange="for(var i=0; i<options.length; i++){eval(options[i].value).style.display=value==options[i].value?'':'none'}">
      <option value="js_text" <?php echo $js_style_value['js_text'];?>><?php echo $LANGUAGE['amend_js_text'];?></option>
      <option value="js_picture" <?php echo $js_style_value['js_picture'];?>><?php echo $LANGUAGE['amend_js_picture'];?></option>
      <option value="js_icon" <?php echo $js_style_value['js_icon'];?>><?php echo $LANGUAGE['amend_js_icon'];?></option>
      <option value="js_hidden" <?php echo $js_style_value['js_hidden'];?>><?php echo $LANGUAGE['amend_js_hidden'];?></option>
      </select>
    </td>
    <td width="40%" class="right_content"><?php echo $LANGUAGE['amend_js_select_explain'];?></td>
  </tr>
</table>

<table width="100%" border="0" cellspacing="1" cellpadding="3" align="center" bgcolor="#FFFFFF" id="js_text" <?php echo $js_style_display['js_text'];?>>
  <tr>
    <td width="20%" class="right_subject2"><?php echo $LANGUAGE['amend_js_text_fontfamily'];?></td>
    <td width="40%" class="right_content">
      <select name="js_text_fontfamily" class="select">
      <option value="Arial" <?php echo $js_text_fontfamily_value['Arial'];?>>Arial</option>
      <option value="Book Antiqua" <?php echo $js_text_fontfamily_value['Book Antiqua'];?>>Book Antiqua</option>
      <option value="Century Gothic" <?php echo $js_text_fontfamily_value['Century Gothic'];?>>Century Gothic</option>
      <option value="Courier New" <?php echo $js_text_fontfamily_value['Courier New'];?>>Courier New</option>
      <option value="Courier" <?php echo $js_text_fontfamily_value['Courier'];?>>Courier</option>
      <option value="Geneva" <?php echo $js_text_fontfamily_value['Geneva'];?>>Geneva</option>
      <option value="Georgia" <?php echo $js_text_fontfamily_value['Georgia'];?>>Georgia</option>
      <option value="Helvetica" <?php echo $js_text_fontfamily_value['Helvetica'];?>>Helvetica</option>
      <option value="Impact" <?php echo $js_text_fontfamily_value['Impact'];?>>Impact</option>
      <option value="mono" <?php echo $js_text_fontfamily_value['mono'];?>>mono</option>
      <option value="sans-serif" <?php echo $js_text_fontfamily_value['sans-serif'];?>>sans-serif</option>
      <option value="serif" <?php echo $js_text_fontfamily_value['serif'];?>>serif</option>
      <option value="Tahoma" <?php echo $js_text_fontfamily_value['Tahoma'];?>>Tahoma</option>
      <option value="Times New Roman" <?php echo $js_text_fontfamily_value['Times New Roman'];?>>Times New Roman</option>
      <option value="Times" <?php echo $js_text_fontfamily_value['Times'];?>>Times</option>
      <option value="Verdana" <?php echo $js_text_fontfamily_value['Verdana'];?>>Verdana</option>
      </select>
    </td>
    <td width="40%" class="right_content"></td>
  </tr>
  <tr>
    <td width="20%" class="right_subject2"><?php echo $LANGUAGE['amend_js_text_fontsize'];?></td>
    <td width="40%" class="right_content"><input type="text" name="js_text_fontsize" size="26" maxlength="6" value="<?php echo $js_text_fontsize;?>" class="input"> px</td>
    <td width="40%" class="right_content"></td>
  </tr>
  <tr>
    <td width="20%" class="right_subject2"><?php echo $LANGUAGE['amend_js_text_fontcolor'];?></td>
    <td width="40%" class="right_content"><input type="text" name="js_text_fontcolor" size="26" maxlength="6" value="<?php echo $js_text_fontcolor;?>" class="input"></td>
    <td width="40%" class="right_content"><table width="30" height="18" border="0" cellpadding="0" cellspacing="0" bgcolor="#<?php echo $js_text_fontcolor;?>"><tr><td></td></tr></table></td>
  </tr>
  <tr>
    <td width="20%" class="right_subject2"><?php echo $LANGUAGE['amend_js_text_fontborder'];?></td>
    <td width="40%" class="right_content"><input type="text" name="js_text_fontborder" size="26" maxlength="6" value="<?php echo $js_text_fontborder;?>" class="input"> px</td>
    <td width="40%" class="right_content"></td>
  </tr>
  <tr>
    <td width="20%" class="right_subject2"><?php echo $LANGUAGE['amend_js_text_fontborder_style'];?></td>
    <td width="40%" class="right_content">
      <select name="js_text_fontborder_style" class="select">
      <option value="solid" <?php echo $js_text_fontborder_style_value['solid'];?>><?php echo $LANGUAGE['amend_js_text_fontborder_style_solid'];?></option>
      <option value="dotted" <?php echo $js_text_fontborder_style_value['dotted'];?>><?php echo $LANGUAGE['amend_js_text_fontborder_style_dotted'];?></option>
      <option value="dashed" <?php echo $js_text_fontborder_style_value['dashed'];?>><?php echo $LANGUAGE['amend_js_text_fontborder_style_dashed'];?></option>
      <option value="double" <?php echo $js_text_fontborder_style_value['double'];?>><?php echo $LANGUAGE['amend_js_text_fontborder_style_double'];?></option>
      <option value="groove" <?php echo $js_text_fontborder_style_value['groove'];?>><?php echo $LANGUAGE['amend_js_text_fontborder_style_groove'];?></option>
      <option value="ridge" <?php echo $js_text_fontborder_style_value['ridge'];?>><?php echo $LANGUAGE['amend_js_text_fontborder_style_ridge'];?></option>
      <option value="inset" <?php echo $js_text_fontborder_style_value['inset'];?>><?php echo $LANGUAGE['amend_js_text_fontborder_style_inset'];?></option>
      <option value="outset" <?php echo $js_text_fontborder_style_value['outset'];?>><?php echo $LANGUAGE['amend_js_text_fontborder_style_outset'];?></option>
      </select>
    </td>
    <td width="40%" class="right_content"></td>
  </tr>
  <tr>
    <td width="20%" class="right_subject2"><?php echo $LANGUAGE['amend_js_text_fontborder_color'];?></td>
    <td width="40%" class="right_content"><input type="text" name="js_text_fontborder_color" size="26" maxlength="6" value="<?php echo $js_text_fontborder_color;?>" class="input"></td>
    <td width="40%" class="right_content"><table width="30" height="18" border="0" cellpadding="0" cellspacing="0" bgcolor="#<?php echo $js_text_fontborder_color;?>"><tr><td></td></tr></table></td>
  </tr>
  <tr>
    <td width="20%" class="right_subject2"><?php echo $LANGUAGE['amend_js_text_fontbg_color'];?></td>
    <td width="40%" class="right_content"><input type="text" name="js_text_fontbg_color" size="26" maxlength="6" value="<?php echo $js_text_fontbg_color;?>" class="input"></td>
    <td width="40%" class="right_content"><table width="30" height="18" border="0" cellpadding="0" cellspacing="0" bgcolor="#<?php echo $js_text_fontbg_color;?>"><tr><td></td></tr></table></td>
  </tr>
</table>

<table width="100%" border="0" cellspacing="1" cellpadding="3" align="center" bgcolor="#FFFFFF" id="js_picture" <?php echo $js_style_display['js_picture'];?>>
  <tr>
    <td width="20%" class="right_subject2"><?php echo $LANGUAGE['amend_js_picture_style'];?></td>
    <td width="40%" class="right_content">
<?php
$file_list     = return_dir("images/js_picture/");
$total_record = count($file_list);
echo "<select name='js_picture_style' class='select' size=1 onChange='ShowJsPicture()'>";
$selected = ($CONFIGUSER['js_picture_style'] == "default") ? " selected" : "";
echo "<option value='default' ".$selected.">default</option>";
for($i=0;$i<$total_record;$i++){
   if(trim($file_list[$i]) != "default"){
       $selected = ($CONFIGUSER['js_picture_style'] == trim($file_list[$i])) ? " selected" : "";
       echo "<option value='".$file_list[$i]."' ".$selected.">".$file_list[$i]."</option>";
   }
}
echo "</select>";
?>
    </td>
    <td width="40%" class="right_content"><?php echo sprintf($LANGUAGE['amend_js_picture_style_explain'],$SETTING['dir_js_picture']);?><br><a href="JavaScript:New('image.php?act=js_picture')"><?php echo $LANGUAGE['amend_js_picture_style_view'];?></a></td>
  </tr>
  <tr>
    <td colspan="3" align="center" class="right_content">
      <img src="images/js_picture/<?php echo $CONFIGUSER['js_picture_style'];?>/1.gif" name="js_picture_style_1" border=0><img src="images/js_picture/<?php echo $CONFIGUSER['js_picture_style'];?>/2.gif" name="js_picture_style_2" border=0><img src="images/js_picture/<?php echo $CONFIGUSER['js_picture_style'];?>/3.gif" name="js_picture_style_3" border=0><img src="images/js_picture/<?php echo $CONFIGUSER['js_picture_style'];?>/4.gif" name="js_picture_style_4" border=0><img src="images/js_picture/<?php echo $CONFIGUSER['js_picture_style'];?>/5.gif" name="js_picture_style_5" border=0><img src="images/js_picture/<?php echo $CONFIGUSER['js_picture_style'];?>/6.gif" name="js_picture_style_6" border=0><img src="images/js_picture/<?php echo $CONFIGUSER['js_picture_style'];?>/7.gif" name="js_picture_style_7" border=0><img src="images/js_picture/<?php echo $CONFIGUSER['js_picture_style'];?>/8.gif" name="js_picture_style_8" border=0><img src="images/js_picture/<?php echo $CONFIGUSER['js_picture_style'];?>/9.gif" name="js_picture_style_9" border=0><img src="images/js_picture/<?php echo $CONFIGUSER['js_picture_style'];?>/0.gif" name="js_picture_style_0" border=0>
    </td>
  </tr>
</table>

<table width="100%" border="0" cellspacing="1" cellpadding="3" align="center" bgcolor="#FFFFFF" id="js_icon" <?php echo $js_style_display['js_icon'];?>>
  <tr>
    <td width="20%" class="right_subject2"><?php echo $LANGUAGE['amend_js_icon_style'];?></td>
    <td width="40%" class="right_content">
<?php
$file_list     = return_dir("images/js_icon/");
$total_record = count($file_list);
echo "<select name='js_icon_style' class='select' size=1 onChange='ShowJsIcon()'>";
$selected = ($CONFIGUSER['js_icon_style'] == "default.gif") ? " selected" : "";
echo "<option value='default.gif' ".$selected.">default.gif</option>";
for($i=0;$i<$total_record;$i++){
   if(trim($file_list[$i]) != "default.gif"){
       $selected = ($CONFIGUSER['js_icon_style'] == trim($file_list[$i])) ? " selected" : "";
       echo "<option value='".$file_list[$i]."' ".$selected.">".$file_list[$i]."</option>";
   }
}
echo "</select>";
?>
    </td>
    <td width="40%" class="right_content"><?php echo sprintf($LANGUAGE['amend_js_icon_style_explain'],$SETTING['dir_js_icon']);?><br><a href="JavaScript:New('image.php?act=js_icon')"><?php echo $LANGUAGE['amend_js_icon_style_view'];?></a></td>
  </tr>
  <tr>
    <td colspan="3" align="center" class="right_content">
      <img src="images/js_icon/<?php echo $CONFIGUSER['js_icon_style'];?>" name="js_icon_style" border="0">
    </td>
  </tr>
</table>

<table width="100%" border="0" cellspacing="1" cellpadding="3" align="center" bgcolor="#FFFFFF" id="js_hidden" <?php echo $js_style_display['js_hidden'];?>>
  <tr>
    <td align="center" class="right_content">
      <?php echo $LANGUAGE['amend_js_hidden_style'];?>
    </td>
  </tr>
</table>

</div>
<!-- end js mode -->

<!-- begin image mode -->
<div id="image" <?php echo $mode_display['image'];?>>
<table width="100%" border="0" cellspacing="1" cellpadding="3" align="center" bgcolor="#FFFFFF">
  <tr>
    <td width="20%" class="right_subject2"><?php echo $LANGUAGE['amend_image_select'];?></td>
    <td width="40%" class="right_content">
      <select name="image_style" class="select"  onChange="for(var i=0; i<options.length; i++){eval(options[i].value).style.display=value==options[i].value?'':'none'}">
      <option value="image_custom" <?php echo $image_style_value['image_custom'];?>><?php echo $LANGUAGE['amend_image_custom'];?></option>
      <option value="image_hidden" <?php echo $image_style_value['image_hidden'];?>><?php echo $LANGUAGE['amend_image_hidden'];?></option>
      </select>
    </td>
    <td width="40%" class="right_content"><?php echo $LANGUAGE['amend_image_hidden'];?></td>
  </tr>
</table>

<table width="100%" border="0" cellspacing="1" cellpadding="3" align="center" bgcolor="#FFFFFF" id="image_custom" <?php echo $image_style_display['image_custom'];?>>
  <tr>
    <td width="20%" class="right_subject2"><?php echo $LANGUAGE['amend_image_custom_background'];?></td>
    <td width="40%" class="right_content">
<?php
$file_list    = return_dir("images/image_custom/");
$total_record = count($file_list);
echo "<select name='image_custom_background' class='select' size=1 onChange='ShowImageCustom()'>";
$selected = ($CONFIGUSER['image_custom_background'] == "default.png") ? " selected" : "";
echo "<option value='default.png' ".$selected.">default.png</option>";
for($i=0;$i<$total_record;$i++){
   if(trim($file_list[$i]) != "default.png"){
       $selected = ($CONFIGUSER['image_custom_background'] == trim($file_list[$i])) ? " selected" : "";
       echo "<option value='".$file_list[$i]."' ".$selected.">".$file_list[$i]."</option>";
   }
}
echo "</select>";
?>
    </td>
    <td width="40%" class="right_content"><?php echo sprintf($LANGUAGE['amend_image_custom_background_explain'],$SETTING['dir_image_custom']);?><br><a href="JavaScript:New('image.php?act=image_custom')"><?php echo $LANGUAGE['amend_image_custom_background_view'];?></a></td>
  </tr>
  <tr>
    <td colspan="3" align="center" class="right_content">
      <img src="images/image_custom/<?php echo $CONFIGUSER['image_custom_background'];?>" name="image_custom_background" border="0">
    </td>
  </tr>
  <tr>
    <td width="20%" class="right_subject2"><?php echo $LANGUAGE['amend_image_custom_font'];?></td>
    <td width="40%" class="right_content">
<?php
$file_list    = return_dir("fonts/");
$total_record = count($file_list);
echo "<select name='image_custom_font' class='select' size=1>";
for($i=1;$i<=5;$i++){
   $selected = ($CONFIGUSER['image_custom_font'] == $i) ? " selected" : "";
   echo "<option value='".$i."' ".$selected.">".$i."</option>";
}
for($i=0;$i<$total_record;$i++){
   $selected = ($CONFIGUSER['image_custom_font'] == trim($file_list[$i])) ? " selected" : "";
   echo "<option value='".$file_list[$i]."' ".$selected.">".$file_list[$i]."</option>";
}
echo "</select>";
?>
    </td>
    <td width="40%" class="right_content"><?php echo sprintf($LANGUAGE['amend_image_custom_font_explain'],$SETTING['dir_fonts']);?></td>
  </tr>
  <tr>
    <td width="20%" class="right_subject2"><?php echo $LANGUAGE['amend_image_custom_color'];?></td>
    <td width="40%" class="right_content"><input type="text" name="image_custom_color" size="26" maxlength="6" value="<?php echo $CONFIGUSER['image_custom_color'];?>" class="input"></td>
    <td width="40%" class="right_content"><table width="30" height="18" border="0" cellpadding="0" cellspacing="0" bgcolor="#<?php echo $CONFIGUSER['image_custom_color'];?>"><tr><td></td></tr></table></td>
  </tr>
  <tr>
    <td width="20%" class="right_subject2"><?php echo $LANGUAGE['amend_image_custom_size'];?></td>
    <td width="40%" class="right_content"><input type="text" name="image_custom_size" size="26" maxlength="3" value="<?php echo $CONFIGUSER['image_custom_size'];?>" class="input"> pt</td>
    <td width="40%" class="right_content"><?php echo $LANGUAGE['amend_image_custom_size_explain'];?></td>
  </tr>
  <tr>
    <td width="20%" class="right_subject2"><?php echo $LANGUAGE['amend_image_custom_top'];?></td>
    <td width="40%" class="right_content"><input type="text" name="image_custom_top" size="26" maxlength="3" value="<?php echo $CONFIGUSER['image_custom_top'];?>" class="input"></td>
    <td width="40%" class="right_content"></td>
  </tr>
  <tr>
    <td width="20%" class="right_subject2"><?php echo $LANGUAGE['amend_image_custom_left'];?></td>
    <td width="40%" class="right_content"><input type="text" name="image_custom_left" size="26" maxlength="3" value="<?php echo $CONFIGUSER['image_custom_left'];?>" class="input"></td>
    <td width="40%" class="right_content"></td>
  </tr>
  <tr>
    <td width="20%" class="right_subject2"><?php echo $LANGUAGE['amend_image_custom_rowspacing'];?></td>
    <td width="40%" class="right_content"><input type="text" name="image_custom_rowspacing" size="26" maxlength="3" value="<?php echo $CONFIGUSER['image_custom_rowspacing'];?>" class="input"></td>
    <td width="40%" class="right_content"><?php echo $LANGUAGE['amend_image_custom_rowspacing_explain'];?></td>
  </tr>
  <tr>
    <td width="20%" class="right_subject2"><?php echo $LANGUAGE['amend_image_custom_width'];?></td>
    <td width="40%" class="right_content"><input type="text" name="image_custom_width" size="26" maxlength="3" value="<?php echo $CONFIGUSER['image_custom_width'];?>" class="input"></td>
    <td width="40%" class="right_content"></td>
  </tr>
  <tr>
    <td width="20%" class="right_subject2"><?php echo $LANGUAGE['amend_image_custom_height'];?></td>
    <td width="40%" class="right_content"><input type="text" name="image_custom_height" size="26" maxlength="3" value="<?php echo $CONFIGUSER['image_custom_height'];?>" class="input"></td>
    <td width="40%" class="right_content"></td>
  </tr>
</table>

<table width="100%" border="0" cellspacing="1" cellpadding="3" align="center" bgcolor="#FFFFFF" id="image_hidden" <?php echo $image_style_display['image_hidden'];?>>
  <tr>
    <td align="center" class="right_content">
      <?php echo $LANGUAGE['amend_image_hidden_style'];?>
    </td>
  </tr>
</table>

</div>
<!-- end image mode -->

<table width="100%" border="0" cellspacing="1" cellpadding="3" align="center" bgcolor="#FFFFFF">
<tr><td align="center" class="right_footer"><input type="submit" value="<?php echo $LANGUAGE['amend_image_submit'];?>" name="submit" class="submit"> <input type="reset" value="<?php echo $LANGUAGE['amend_image_reset'];?>" name="reset" class="submit"></td></tr>
</table>

</td></tr></form></table>

<?php
}elseif($_GET['act'] == "save") {

$user               = $_SESSION['sess_username'] ? $_SESSION['sess_username'] : $_SESSION['sess_select'];
$userdir            = $SETTING['dir_data'].$user;

$file_config        = $userdir."/".$SETTING['file_config'];
$file_ipsame        = $userdir."/".$SETTING['file_ipsame'];

$file_click         = $userdir."/".$SETTING['file_click'];

$file_totalmonth    = $userdir."/".$SETTING['file_totalmonth'];
$file_totalday      = $userdir."/".$SETTING['file_totalday'];
$file_totalhour     = $userdir."/".$SETTING['file_totalhour'];

$file_year          = $userdir."/".$SETTING['file_year'];
$file_month         = $userdir."/".$SETTING['file_month'];
$file_day           = $userdir."/".$SETTING['file_day'];
$file_hour          = $userdir."/".$SETTING['file_hour'];

$file_online        = $userdir."/".$SETTING['file_online'];
$file_visitor       = $userdir."/".$SETTING['file_visitor'];

$file_os            = $userdir."/".$SETTING['file_os'];
$file_browser       = $userdir."/".$SETTING['file_browser'];
$file_language      = $userdir."/".$SETTING['file_language'];
$file_colordepth    = $userdir."/".$SETTING['file_colordepth'];
$file_screensize    = $userdir."/".$SETTING['file_screensize'];
$file_timezone      = $userdir."/".$SETTING['file_timezone'];

$file_searchfrom    = $userdir."/".$SETTING['file_searchfrom'];
$file_searchkeyword = $userdir."/".$SETTING['file_searchkeyword'];

if($_POST['email'] == "" || $_POST['website'] == "" || $_POST['weburl'] == "" || $_POST['weburl'] == "http://" || $_POST['webintro'] == "" || $_POST['length'] == "" || $_POST['ifview'] == "" || $_POST['ifadd0'] == "" || $_POST['language'] == ""){
   header("location:prompt.php?act=failed&mes=".htmlentities(urlencode($LANGUAGE['amend_warning_empty'])));
   exit;
}
if($_POST['password2'] != $_POST['password3']){
   header("location:prompt.php?act=failed&mes=".htmlentities(urlencode($LANGUAGE['amend_warning_pass_differ'])));
   exit;
}
if(!preg_match("/^[_.0-9a-z-]+@([0-9a-z][0-9a-z-]+\.)+[a-z]{2,3}$/i",$_POST['email'])){
   header("location:prompt.php?act=failed&mes=".htmlentities(urlencode($LANGUAGE['amend_warning_email_error'])));
   exit;
}
if(strlen($_POST['webintro']) > CONFIG_WEBINTRO_LONG){
   header("location:prompt.php?act=failed&mes=".htmlentities(urlencode(sprintf($LANGUAGE['amend_warning_webintro_error'],CONFIG_WEBINTRO_LONG))));
   exit;
}
if(!preg_match("/^[0-9]{1,2}$/",$_POST['length'])){
   header("location:prompt.php?act=failed&mes=".htmlentities(urlencode($LANGUAGE['amend_warning_length_error'])));
   exit;
}
if(($_POST['timediff'] <= -24) || ($_POST['timediff'] >= 24)){
   header("location:prompt.php?act=failed&mes=".htmlentities(urlencode($LANGUAGE['amend_warning_timediff_error'])));
   exit;
}

if(!empty($_POST['password2']) || !empty($_POST['password3'])){
   if( ($CONFIGUSER['password'] != str_encrypt($_POST['password1'])) && if_adminlogin() != "y"){
       header("location:prompt.php?act=failed&mes=".htmlentities(urlencode($LANGUAGE['amend_warning_current_password_error'])));
       exit;
   }
   if(!preg_match("/^[0-9a-z_]{3,60}$/i",$_POST['password2'])){
       header("location:prompt.php?act=failed&mes=".htmlentities(urlencode($LANGUAGE['amend_warning_new_password_error'])));
       exit;
   }
   $password = str_encrypt($_POST['password2']);
}else{
   $password = $CONFIGUSER['password'];
}

if( ($_POST['mode'] == "js") && ($_POST['js_style'] == "text") ){
   if(!preg_match("/^[0-9]{1,6}$/",$_POST['js_text_fontsize'])){
      header("location:prompt.php?act=failed&mes=".htmlentities(urlencode($LANGUAGE['amend_warning_js_text_fontsize_error'])));
      exit;
   }
   if(!preg_match("/^[0-9a-f]{6,6}$/i",$_POST['js_text_fontcolor'])){
      header("location:prompt.php?act=failed&mes=".htmlentities(urlencode($LANGUAGE['amend_warning_js_text_fontcolor_error'])));
      exit;
   }
   if(!preg_match("/^[0-9]{1,6}$/",$_POST['js_text_fontborder'])){
      header("location:prompt.php?act=failed&mes=".htmlentities(urlencode($LANGUAGE['amend_warning_js_text_fontborder_error'])));
      exit;
   }
   if(!preg_match("/^[0-9a-f]{6,6}$/i",$_POST['js_text_fontborder_color'])){
      header("location:prompt.php?act=failed&mes=".htmlentities(urlencode($LANGUAGE['amend_warning_js_text_fontborder_color_error'])));
      exit;
   }
   if(!preg_match("/^[0-9a-f]{6,6}$/i",$_POST['js_text_fontbg_color'])){
      header("location:prompt.php?act=failed&mes=".htmlentities(urlencode($LANGUAGE['amend_warning_js_text_fontbg_color_error'])));
      exit;
   }
}

if( ($_POST['mode'] == "image") && ($_POST['image_style'] == "custom") ){
   if(!preg_match("/^[0-9a-z_.]{4,60}$/i",$_POST['image_custom_font'])){
      header("location:prompt.php?act=failed&mes=".htmlentities(urlencode($LANGUAGE['amend_warning_image_custom_font_error'])));
      exit;
   }
   if(!preg_match("/^[0-9a-f]{6,6}$/i",$_POST['image_custom_color'])){
      header("location:prompt.php?act=failed&mes=".htmlentities(urlencode($LANGUAGE['amend_warning_image_custom_color_error'])));
      exit;
   }
   if(!preg_match("/^[0-9]{1,3}$/",$_POST['image_custom_size'])){
      header("location:prompt.php?act=failed&mes=".htmlentities(urlencode($LANGUAGE['amend_warning_image_custom_size_error'])));
      exit;
   }
   if(!preg_match("/^[0-9]{1,3}$/",$_POST['image_custom_top'])){
      header("location:prompt.php?act=failed&mes=".htmlentities(urlencode($LANGUAGE['amend_warning_image_custom_top_error'])));
      exit;
   }
   if(!preg_match("/^[0-9]{1,3}$/",$_POST['image_custom_left'])){
      header("location:prompt.php?act=failed&mes=".htmlentities(urlencode($LANGUAGE['amend_warning_image_custom_left_error'])));
      exit;
   }
   if(!preg_match("/^[0-9]{1,3}$/",$_POST['image_custom_rowspacing'])){
      header("location:prompt.php?act=failed&mes=".htmlentities(urlencode($LANGUAGE['amend_warning_image_custom_rowspacing_error'])));
      exit;
   }
   if(!preg_match("/^[0-9]{1,3}$/",$_POST['image_custom_width'])){
      header("location:prompt.php?act=failed&mes=".htmlentities(urlencode($LANGUAGE['amend_warning_image_custom_width_error'])));
      exit;
   }
   if(!preg_match("/^[0-9]{1,3}$/",$_POST['image_custom_height'])){
      header("location:prompt.php?act=failed&mes=".htmlentities(urlencode($LANGUAGE['amend_warning_image_custom_height_error'])));
      exit;
   }
}

$timediff        = $_POST['timediff']*3600;

$website         = str_encode($_POST['website']);
$weburl          = str_encode($_POST['weburl']);
$webintro        = str_encode($_POST['webintro']);

$total_ip_text   = str_encode($_POST['total_ip_text']);
$total_pv_text   = str_encode($_POST['total_pv_text']);
$year_ip_text    = str_encode($_POST['year_ip_text']);
$year_pv_text    = str_encode($_POST['year_pv_text']);
$month_ip_text   = str_encode($_POST['month_ip_text']);
$month_pv_text   = str_encode($_POST['month_pv_text']);
$day_ip_text     = str_encode($_POST['day_ip_text']);
$day_pv_text     = str_encode($_POST['day_pv_text']);
$online_text     = str_encode($_POST['online_text']);

$js_text_fontfamily       = "font-family:".$_POST['js_text_fontfamily'].";";
$js_text_fontsize         = (!preg_match("/^[0-9]{1,6}$/",$_POST['js_text_fontsize'])) ? "font-size:12;" : "font-size:".$_POST['js_text_fontsize'].";";
$js_text_fontcolor        = (!preg_match("/^[0-9a-f]{6,6}$/i",$_POST['js_text_fontcolor'])) ? "color:#000000;" : "color:#".$_POST['js_text_fontcolor'].";";
$js_text_fontborder       = (!preg_match("/^[0-9]{1,6}$/",$_POST['js_text_fontborder'])) ? "border:1px" : "border:".$_POST['js_text_fontborder']."px";
$js_text_fontborder_style = " ".$_POST['js_text_fontborder_style'];
$js_text_fontborder_color = (!preg_match("/^[0-9a-f]{6,6}$/i",$_POST['js_text_fontborder_color'])) ? " #000000;" : " #".$_POST['js_text_fontborder_color'].";";
$js_text_fontbg_color     = (!preg_match("/^[0-9a-f]{6,6}$/i",$_POST['js_text_fontbg_color'])) ? "background-color:#FFFFD7;" : "background-color:#".$_POST['js_text_fontbg_color'].";";

$image_custom_color       = (!preg_match("/^[0-9a-f]{6,6}$/i",$_POST['image_custom_color'])) ? "002280" : $_POST['image_custom_color'];
$image_custom_size        = (!preg_match("/^[0-9]{1,3}$/",$_POST['image_custom_size'])) ? "9" : $_POST['image_custom_size'];
$image_custom_top         = (!preg_match("/^[0-9]{1,3}$/",$_POST['image_custom_top'])) ? "4" : $_POST['image_custom_top'];
$image_custom_left        = (!preg_match("/^[0-9]{1,3}$/",$_POST['image_custom_left'])) ? "3" : $_POST['image_custom_left'];
$image_custom_rowspacing  = (!preg_match("/^[0-9]{1,3}$/",$_POST['image_custom_rowspacing'])) ? "0" : $_POST['image_custom_rowspacing'];
$image_custom_width       = (!preg_match("/^[0-9]{1,3}$/",$_POST['image_custom_width'])) ? "330" : $_POST['image_custom_width'];
$image_custom_height      = (!preg_match("/^[0-9]{1,3}$/",$_POST['image_custom_height'])) ? "18" : $_POST['image_custom_height'];

$user_config = "<?php
####################################### User Info #################################################
\$CONFIGUSER['username']                 = '".$user."';// Username
\$CONFIGUSER['password']                 = '".$password."';// Password

\$CONFIGUSER['email']                    = '".$_POST['email']."';// E-mail
\$CONFIGUSER['website']                  = '".$website."';// Website name
\$CONFIGUSER['weburl']                   = '".$weburl."';// Website url
\$CONFIGUSER['webintro']                 = '".$webintro."';// Website intro

####################################### Option ####################################################
\$CONFIGUSER['length']                   = '".$_POST['length']."';// Length
\$CONFIGUSER['timediff']                 = '".$timediff."';// Time difference
\$CONFIGUSER['ifview']                   = '".$_POST['ifview']."';// Allow other people view
\$CONFIGUSER['ifadd0']                   = '".$_POST['ifadd0']."';// If leading zeros
\$CONFIGUSER['language']                 = '".$_POST['language']."';// Language

####################################### Register Info #############################################
\$CONFIGUSER['begintime']                = '".$CONFIGUSER['begintime']."';// What time i begin to stat.

####################################### Display Option ############################################
\$CONFIGUSER['total_ip_if']              = '".$_POST['total_ip_if']."';// If show total ip
\$CONFIGUSER['total_ip_text']            = '".$total_ip_text."';// Text of total ip
\$CONFIGUSER['total_pv_if']              = '".$_POST['total_pv_if']."';// If show total pv
\$CONFIGUSER['total_pv_text']            = '".$total_pv_text."';// Text of total pv

\$CONFIGUSER['year_ip_if']               = '".$_POST['year_ip_if']."';// If show year ip
\$CONFIGUSER['year_ip_text']             = '".$year_ip_text."';// Text of year ip
\$CONFIGUSER['year_pv_if']               = '".$_POST['year_pv_if']."';// If show year pv
\$CONFIGUSER['year_pv_text']             = '".$year_pv_text."';// Text of year pv

\$CONFIGUSER['month_ip_if']              = '".$_POST['month_ip_if']."';// If show month ip
\$CONFIGUSER['month_ip_text']            = '".$month_ip_text."';// Text of month ip
\$CONFIGUSER['month_pv_if']              = '".$_POST['month_pv_if']."';// If show month pv
\$CONFIGUSER['month_pv_text']            = '".$month_pv_text."';// Text of month pv

\$CONFIGUSER['day_ip_if']                = '".$_POST['day_ip_if']."';// If show day ip
\$CONFIGUSER['day_ip_text']              = '".$day_ip_text."';// Text of day ip
\$CONFIGUSER['day_pv_if']                = '".$_POST['day_pv_if']."';// If show day pv
\$CONFIGUSER['day_pv_text']              = '".$day_pv_text."';// Text of day pv

\$CONFIGUSER['online_if']                = '".$_POST['online_if']."';// If show online
\$CONFIGUSER['online_text']              = '".$online_text."';// Text of online

####################################### Display Mode [js|image] ###################################
\$CONFIGUSER['mode']                     = '".$_POST['mode']."';

//===================================== Mode = js =================================================
// js = [js_text|js_picture|js_icon|js_hidden]
\$CONFIGUSER['js_style']                 = '".$_POST['js_style']."';
# js_text
\$CONFIGUSER['js_text_fontfamily']       = '".$js_text_fontfamily."';// Font
\$CONFIGUSER['js_text_fontsize']         = '".$js_text_fontsize."';// Font size
\$CONFIGUSER['js_text_fontcolor']        = '".$js_text_fontcolor."';// Font color
\$CONFIGUSER['js_text_fontborder']       = '".$js_text_fontborder."';// Font border
\$CONFIGUSER['js_text_fontborder_style'] = '".$js_text_fontborder_style."';// Font border style
\$CONFIGUSER['js_text_fontborder_color'] = '".$js_text_fontborder_color."';// Font border color
\$CONFIGUSER['js_text_fontbg_color']     = '".$js_text_fontbg_color."';// Background color
# js_picture
\$CONFIGUSER['js_picture_style']         = '".$_POST['js_picture_style']."';// The style of picture
# js_icon
\$CONFIGUSER['js_icon_style']            = '".$_POST['js_icon_style']."';// The style of icon
# js_hidden

//===================================== Mode = image ==============================================
// image = [image_custom|image_hidden]
\$CONFIGUSER['image_style']              = '".$_POST['image_style']."';
# image_custom
\$CONFIGUSER['image_custom_background']  = '".$_POST['image_custom_background']."';// Put the background picture into /images/image_custom/
\$CONFIGUSER['image_custom_font']        = '".$_POST['image_custom_font']."';// Put the font into dir of /fonts/.1,2,3,4,5 is built-in font
\$CONFIGUSER['image_custom_color']       = '".$image_custom_color."';// The color of text
\$CONFIGUSER['image_custom_size']        = '".$image_custom_size."';// Font size
\$CONFIGUSER['image_custom_top']         = '".$image_custom_top."';// Interval top of text
\$CONFIGUSER['image_custom_left']        = '".$image_custom_left."';// Interval left of text
\$CONFIGUSER['image_custom_rowspacing']  = '".$image_custom_rowspacing."';// Interval row spacing of text
\$CONFIGUSER['image_custom_width']       = '".$image_custom_width."';// Background width
\$CONFIGUSER['image_custom_height']      = '".$image_custom_height."';// Background height
# image_hidden
?>
";

@chmod($userdir,0777);
if(write_file($file_config,$user_config)) {

      unset($_SESSION['sess_username']);
      unset($_SESSION['sess_password']);

      header("location:prompt.php?act=succeed&mes=".htmlentities(urlencode($LANGUAGE['amend_succeed'])));
      exit;
}else{
      header("location:prompt.php?act=failed&mes=".htmlentities(urlencode($LANGUAGE['amend_failed'])));
      exit;
}

}

echo "<br></td></tr></table>";
include_once 'include/footer.php';
?>
