<?php
/*
+-----------------------------------------------------------------------------+
| $Id: *.php,v 1.* 2005/07/01 06:15:08 Bleakwind Exp $
| SnowStats
|         --- A Web Statistics Analysis for multiuser
| Copyright (c) 2003-2005 Weaverdream.com By Bleakwind
| http://www.weaverdream.com
+-----------------------------------------------------------------------------+
*/

include_once 'include/include.php';
check_ifview();
include_once 'include/header.php';
?>

<table width="760" border="0" cellpadding="0" cellspacing="0" bgcolor="#5E94DD" align="center">
  <tr bgcolor="#5E94DD">
    <td width="200" align="center" valign="top" class="left_bg">
      <?include_once 'include/menu.php';?>
	</td>
	<td width="560" bgcolor="#FFFFFF" valign="top">

<?php
$user                = $_SESSION['sess_select'];
$userdir             = $SETTING['dir_data'].$user;

$file_config         = $userdir."/".$SETTING['file_config'];
$file_click          = $userdir."/".$SETTING['file_click'];
$file_month          = $userdir."/".$SETTING['file_month'];
$file_day            = $userdir."/".$SETTING['file_day'];
$file_hour           = $userdir."/".$SETTING['file_hour'];
$file_online         = $userdir."/".$SETTING['file_online'];
   
include $file_config;

$begintime           = $CONFIGUSER['begintime'] + $CONFIGUSER['timediff'];
$totalyear           = time_margin($begintime,$TIMENOW['time'],946080000);// How many year
$totalmonth          = time_margin($begintime,$TIMENOW['time'],2592000);// How many month
$totalday            = time_margin($begintime,$TIMENOW['time'],86400);// How many day
$totalhour           = time_margin($begintime,$TIMENOW['time'],3600);// How many hour

$webintro            = str_decode($CONFIGUSER['webintro']);// User's webintro
$begindate           = date('Y-m-d H:i:s',$begintime);

$click               = read_click($file_click,$array_click);// Get the click array
$online_temp         = read_online($file_online,CONFIG_ONLINE_LONG,$TIMENOW['time']);
$online              = $online_temp['number'];// Online

// Average
$average['year_ip']  = ceil($click['ip'][0]/$totalyear);
$average['year_pv']  = ceil($click['pv'][0]/$totalyear);
$average['month_ip'] = ceil($click['ip'][0]/$totalmonth);
$average['month_pv'] = ceil($click['pv'][0]/$totalmonth);
$average['day_ip']   = ceil($click['ip'][0]/$totalday);
$average['day_pv']   = ceil($click['pv'][0]/$totalday);
$average['hour_ip']  = ceil($click['ip'][0]/$totalhour);
$average['hour_pv']  = ceil($click['pv'][0]/$totalhour);

// Forecast
$forecast_year       = read_sum($file_month,$array_month);
$array_day           = array_slice($array_day, 31-$number_thismonth);
$forecast_month      = read_sum($file_day,$array_day);
$forecast_day        = read_sum($file_hour,$array_hour);
?>

<table width="100%" border="0" cellspacing="0" cellpadding="3" align="center" bgcolor="#EBE9ED"><tr><td><img src="images/arrowright.gif" border=0 align="absmiddle"> <a href="index.php" target="_self"><font style="color:#000000;"><?php echo CONFIG_WEBSITE;?></font></a> &raquo; <?php echo $LANGUAGE['general_placedir'];?> &raquo; <?php echo $LANGUAGE['general_place'];?></td></tr></table>
<br>
<table width="95%" border="0" cellspacing="1" cellpadding="3" align="center" bgcolor="#FFFFFF">
<tr><td class="right_title" colspan="2"><?php echo $LANGUAGE['general_general'];?></td></tr>
<tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['general_username'];?></td><td width="80%" class="right_content"><font class="salient"><?php echo $CONFIGUSER['username'];?></font></td></tr>
<tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['general_website'];?></td><td width="80%" class="right_content"><a href="<?php echo $CONFIGUSER['weburl'];?>"><?php echo $CONFIGUSER['website'];?></a></td></tr>
<tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['general_email'];?></td><td width="80%" class="right_content"><a href="mailto:<?php echo $CONFIGUSER['email'];?>"><?php echo $CONFIGUSER['email'];?></a></td></tr>
<tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['general_webintro'];?></td><td width="80%" class="right_content"><textarea cols="45" rows="10" wrap="virtual" readonly><?php echo $webintro;?></textarea></td></tr>
<tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['general_begindate'];?></td><td width="80%" class="right_content"><?php echo $begindate;?></td></tr>
<tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['general_totalday'];?></td><td width="80%" class="right_content"><?php echo $totalday;?> day</td></tr>
</table>

<table width="95%" border="0" cellspacing="1" cellpadding="3" align="center" bgcolor="#FFFFFF">
<tr><td class="right_title" colspan="3"><?php echo $LANGUAGE['general_stats'];?></td></tr>
<tr><td width="20%" class="right_subject"></td><td width="40%" class="right_title2"><?php echo $LANGUAGE['general_ip'];?></td><td width="40%" class="right_title2"><?php echo $LANGUAGE['general_pv'];?></td></tr>
<tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['general_total'];?></td><td width="40%" class="right_content"><?php echo $click['ip'][0];?></td><td width="40%" class="right_content"><?php echo $click['pv'][0];?></td></tr>
<tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['general_year'];?></td><td width="40%" class="right_content"><?php echo $click['ip'][1];?></td><td width="40%" class="right_content"><?php echo $click['pv'][1];?></td></tr>
<tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['general_month'];?></td><td width="40%" class="right_content"><?php echo $click['ip'][2];?></td><td width="40%" class="right_content"><?php echo $click['pv'][2];?></td></tr>
<tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['general_day'];?></td><td width="40%" class="right_content"><?php echo $click['ip'][3];?></td><td width="40%" class="right_content"><?php echo $click['pv'][3];?></td></tr>
<tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['general_online'];?></td><td width="80%" class="right_content" colspan="2"><?php echo $online;?></td></tr>
</table>

<table width="95%" border="0" cellspacing="1" cellpadding="3" align="center" bgcolor="#FFFFFF">
<tr><td class="right_title" colspan="3"><?php echo $LANGUAGE['general_average_forecast'];?></td></tr>
<tr><td width="20%" class="right_subject"></td><td width="40%" class="right_title2"><?php echo $LANGUAGE['general_ip'];?></td><td width="40%" class="right_title2"><?php echo $LANGUAGE['general_pv'];?></td></tr>
<tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['general_average_year'];?></td><td width="40%" class="right_content"><?php echo $average['year_ip'];?></td><td width="40%" class="right_content"><?php echo $average['year_pv'];?></td></tr>
<tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['general_average_month'];?></td><td width="40%" class="right_content"><?php echo $average['month_ip'];?></td><td width="40%" class="right_content"><?php echo $average['month_pv'];?></td></tr>
<tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['general_average_day'];?></td><td width="40%" class="right_content"><?php echo $average['day_ip'];?></td><td width="40%" class="right_content"><?php echo $average['day_pv'];?></td></tr>
<tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['general_average_hour'];?></td><td width="40%" class="right_content"><?php echo $average['hour_ip'];?></td><td width="40%" class="right_content"><?php echo $average['hour_pv'];?></td></tr>
<tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['general_forecast_year'];?></td><td width="40%" class="right_content"><?php echo $forecast_year['ip'];?></td><td width="40%" class="right_content"><?php echo $forecast_year['pv'];?></td></tr>
<tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['general_forecast_month'];?></td><td width="40%" class="right_content"><?php echo $forecast_month['ip'];?></td><td width="40%" class="right_content"><?php echo $forecast_month['pv'];?></td></tr>
<tr><td width="20%" class="right_subject"><?php echo $LANGUAGE['general_forecast_day'];?></td><td width="40%" class="right_content"><?php echo $forecast_day['ip'];?></td><td width="40%" class="right_content"><?php echo $forecast_day['pv'];?></td></tr>
</table>

<?php
echo "<br></td></tr></table>";
include_once 'include/footer.php';
?>