<?php
/*
+-----------------------------------------------------------------------------+
| $Id: *.php,v 1.* 2005/07/01 06:15:08 Bleakwind Exp $
| SnowStats
|         --- A Web Statistics Analysis for multiuser
| Copyright (c) 2003-2005 Weaverdream.com By Bleakwind
| http://www.weaverdream.com
+-----------------------------------------------------------------------------+
*/


// Runtime
function get_microtime(){
   list($usec, $sec) = explode(" ",microtime());
   return ((float)$usec + (float)$sec);
}
$runtime_start = get_microtime();

set_magic_quotes_runtime(0);

// Session start
session_cache_limiter("private, must-revalidate");
session_start();
ob_start();

// Include some files
include_once 'config.php';
include_once 'include/function.php';
include_once 'include/setting.php';

// Set the language
if(isset($_GET['lang']) && ($_GET['lang'] != "")){
   $lang = trim(strtolower(strip_tags($_GET['lang'])));
   if(file_exists("language/".$lang."/index.php")){
       $_SESSION['sess_language'] = $lang;
   }
}

// Include the language
if(!empty($_SESSION['sess_language']) && file_exists('language/'.$_SESSION['sess_language'].'/index.php')){
   include_once 'language/'.$_SESSION['sess_language'].'/index.php';
} else {
   include_once 'language/'.CONFIG_LANGUAGE.'/index.php';
}

header('Content-Type: text/html; charset='.$LANGUAGE['charset']);

// Filtrate the IP
if(forbid_ip() == "y" &&  if_adminlogin() == "n"){
   include_once 'include/header.php';
   echo "<table width='760' height='200' border='0' cellpadding='0' cellspacing='1' bgcolor='#5E94DD' align='center'><tr bgcolor='#EBE9ED'><td align='center'>";
   echo "<img src='images/warning.gif' border='0' align='absmiddle'> ".$LANGUAGE['forbid_ip']."";
   echo "</td></tr></table>";
   include_once 'include/footer.php';
   exit;
}

// Initialization some variable
$TIMENOW['time']    = time() + $CONFIGUSER['timediff'];
$TIMENOW['year']    = date('Y',$TIMENOW['time']);
$TIMENOW['month']   = date('m',$TIMENOW['time']);
$TIMENOW['day']     = date('d',$TIMENOW['time']);
$TIMENOW['hour']    = date('H',$TIMENOW['time']);
$TIMENOW['minute']  = date('i',$TIMENOW['time']);
$TIMENOW['second']  = date('s',$TIMENOW['time']);

$number_thismonth   = date("t",mktime(0,0,0,$TIMENOW['month'],1,$TIMENOW['year']));// How many days this month
$number_lastmonth   = date("t",mktime(0,0,0,$TIMENOW['month'],0,$TIMENOW['year']));// How many days last month
 
$array_click        = array("total", $TIMENOW['year'], $TIMENOW['year'].$TIMENOW['month'], $TIMENOW['year'].$TIMENOW['month'].$TIMENOW['day']);

$array_year         = join_date("year",$TIMENOW['year'],$TIMENOW['month'],$TIMENOW['day'],$TIMENOW['hour']);
$array_month        = join_date("month",$TIMENOW['year'],$TIMENOW['month'],$TIMENOW['day'],$TIMENOW['hour']);
$array_day          = join_date("day",$TIMENOW['year'],$TIMENOW['month'],$TIMENOW['day'],$TIMENOW['hour']);
$array_hour         = join_date("hour",$TIMENOW['year'],$TIMENOW['month'],$TIMENOW['day'],$TIMENOW['hour']);

$array_month_virgin = join_str(1,12,2);
$array_day_virgin   = join_str(1,31,2);
$array_hour_virgin  = join_str(0,23,2);
?>
