<?php
/*
+-----------------------------------------------------------------------------+
| $Id: *.php,v 1.* 2005/07/01 06:15:08 Bleakwind Exp $
| SnowStats
|         --- A Web Statistics Analysis for multiuser
| Copyright (c) 2003-2005 Weaverdream.com By Bleakwind
| http://www.weaverdream.com
+-----------------------------------------------------------------------------+
*/

include_once 'include/include.php';

// If select user
if(!isset($_GET['user']) || $_GET['user'] == ""){
   echo "document.write(\"".$LANGUAGE['noshowuser']."\");";
   exit;
}

$user        = $_GET['user'];
$userdir     = $SETTING['dir_data'].$user;
$file_config = $userdir."/".$SETTING['file_config'];
$file_click  = $userdir."/".$SETTING['file_click'];
$file_online = $userdir."/".$SETTING['file_online'];

// If isset $file_config
if(!file_exists($file_config)){
   echo "document.write(\"".$LANGUAGE['nouser']."\");";
   exit;
}

include $file_config;

// If user == user of $file_config
if($user != $CONFIGUSER['username']){
   echo "document.write(\"".$LANGUAGE['configerror']."\");";
   exit;
}

// Read data
$click       = read_click($file_click,$array_click);
$online      = read_number($file_online,5);

// Format data
if($CONFIGUSER['ifadd0'] == "y"){
   for($i=0;$i<count($array_click);$i++){
      $click['ip'][$i] = sprintf("%0".$CONFIGUSER['length']."d", $click['ip'][$i]);
      $click['pv'][$i] = sprintf("%0".$CONFIGUSER['length']."d", $click['pv'][$i]);
   }
   $online             = sprintf("%0".$CONFIGUSER['length']."d", $online);
}

// Change type to string
for($i=0;$i<count($array_click);$i++){
   $click['ip'][$i] = (string)$click['ip'][$i];
   $click['pv'][$i] = (string)$click['pv'][$i];
}
$online             = (string)$online;

// Mode = js
if($CONFIGUSER['mode'] == "js"){

   // First write
?>
   var snowstats_href       = escape(location.href);
   var snowstats_referrer   = escape(document.referrer);
   var snowstats_language   = navigator.systemLanguage ? navigator.systemLanguage : navigator.userLanguage;
   var snowstats_colordepth = screen.colorDepth;
   var snowstats_screensize = screen.width+"*"+screen.height;
   var snowstats_date       = new Date();
   var snowstats_timezone   = 0 - snowstats_date.getTimezoneOffset()/60;
   document.write(
   "<script language='JavaScript' src='<?php echo CONFIG_URL;?>write.php?user=<?php echo $_GET['user'];?>"
   +"&snowstats_href="+snowstats_href
   +"&snowstats_referrer="+snowstats_referrer
   +"&snowstats_language="+snowstats_language
   +"&snowstats_colordepth="+snowstats_colordepth
   +"&snowstats_screensize="+snowstats_screensize
   +"&snowstats_timezone="+snowstats_timezone
   +"'></script>"
   );

<?php
   // Then read and put out
   switch ($CONFIGUSER['js_style']){
       // Style = text
       case "js_text":
           $total_ip_text   = $CONFIGUSER['total_ip_text'];
           $total_pv_text   = $CONFIGUSER['total_pv_text'];
           $year_ip_text    = $CONFIGUSER['year_ip_text'];
           $year_pv_text    = $CONFIGUSER['year_pv_text'];
           $month_ip_text   = $CONFIGUSER['month_ip_text'];
           $month_pv_text   = $CONFIGUSER['month_pv_text'];
           $day_ip_text     = $CONFIGUSER['day_ip_text'];
           $day_pv_text     = $CONFIGUSER['day_pv_text'];
           $online_text     = $CONFIGUSER['online_text'];

           $output = "";
           $output .= "<a href='".CONFIG_URL."login.php?user=".$user."' target='_blank'><span style='text-decoration: none;".$CONFIGUSER['js_text_fontfamily'].$CONFIGUSER['js_text_fontsize'].$CONFIGUSER['js_text_fontcolor'].$CONFIGUSER['js_text_fontborder'].$CONFIGUSER['js_text_fontborder_style'].$CONFIGUSER['js_text_fontborder_color'].$CONFIGUSER['js_text_fontbg_color']."'>";
           if($CONFIGUSER['total_ip_if'] == "y"){ $output .= $total_ip_text.$click['ip']['0']; }
           if($CONFIGUSER['total_pv_if'] == "y"){ $output .= $total_pv_text.$click['pv']['0']; }
           if($CONFIGUSER['year_ip_if']  == "y"){ $output .= $year_ip_text .$click['ip']['1']; }
           if($CONFIGUSER['year_pv_if']  == "y"){ $output .= $year_pv_text .$click['pv']['1']; }
           if($CONFIGUSER['month_ip_if'] == "y"){ $output .= $month_ip_text.$click['ip']['2']; }
           if($CONFIGUSER['month_pv_if'] == "y"){ $output .= $month_pv_text.$click['pv']['2']; }
           if($CONFIGUSER['day_ip_if']   == "y"){ $output .= $day_ip_text  .$click['ip']['3']; }
           if($CONFIGUSER['day_pv_if']   == "y"){ $output .= $day_pv_text  .$click['pv']['3']; }
           if($CONFIGUSER['online_if']   == "y"){ $output .= $online_text  .$online; }
           $output .= "</span></a>";
           echo  "document.write(\"".$output."\");";
       break;
       // Style = picture
       case "js_picture":
           $total_ip_text   = $CONFIGUSER['total_ip_text'];
           $total_pv_text   = $CONFIGUSER['total_pv_text'];
           $year_ip_text    = $CONFIGUSER['year_ip_text'];
           $year_pv_text    = $CONFIGUSER['year_pv_text'];
           $month_ip_text   = $CONFIGUSER['month_ip_text'];
           $month_pv_text   = $CONFIGUSER['month_pv_text'];
           $day_ip_text     = $CONFIGUSER['day_ip_text'];
           $day_pv_text     = $CONFIGUSER['day_pv_text'];
           $online_text     = $CONFIGUSER['online_text'];

           $output = "";
           $output .= "<a href='".CONFIG_URL."login.php?user=".$user."' target='_blank'><span style='text-decoration: none; font-size: 12px;'>";
           if($CONFIGUSER['total_ip_if'] == "y"){
               $output .= $total_ip_text;
               for($i=0;$i<strlen($click['ip']['0']);$i++){ $output .= "<img src='".CONFIG_URL."images/js_picture/default/".$click['ip']['0']{$i}.".gif' border='0'>"; }
           }
           if($CONFIGUSER['total_pv_if'] == "y"){
               $output .= $total_pv_text;
               for($i=0;$i<strlen($click['pv']['0']);$i++){ $output .= "<img src='".CONFIG_URL."images/js_picture/default/".$click['pv']['0']{$i}.".gif' border='0'>"; }
           }
           if($CONFIGUSER['year_ip_if'] == "y"){
               $output .= $year_ip_text;
               for($i=0;$i<strlen($click['ip']['1']);$i++){ $output .= "<img src='".CONFIG_URL."images/js_picture/default/".$click['ip']['1']{$i}.".gif' border='0'>"; }
           }
           if($CONFIGUSER['year_pv_if'] == "y"){
               $output .= $year_pv_text;
               for($i=0;$i<strlen($click['pv']['1']);$i++){ $output .= "<img src='".CONFIG_URL."images/js_picture/default/".$click['pv']['1']{$i}.".gif' border='0'>"; }
           }
           if($CONFIGUSER['month_ip_if'] == "y"){
               $output .= $month_ip_text;
               for($i=0;$i<strlen($click['ip']['2']);$i++){ $output .= "<img src='".CONFIG_URL."images/js_picture/default/".$click['ip']['2']{$i}.".gif' border='0'>"; }
           }
           if($CONFIGUSER['month_pv_if'] == "y"){
               $output .= $month_pv_text;
               for($i=0;$i<strlen($click['pv']['2']);$i++){ $output .= "<img src='".CONFIG_URL."images/js_picture/default/".$click['pv']['2']{$i}.".gif' border='0'>"; }
           }
           if($CONFIGUSER['day_ip_if'] == "y"){
               $output .= $day_ip_text;
               for($i=0;$i<strlen($click['ip']['3']);$i++){ $output .= "<img src='".CONFIG_URL."images/js_picture/default/".$click['ip']['3']{$i}.".gif' border='0'>"; }
           }
           if($CONFIGUSER['day_pv_if'] == "y"){
               $output .= $day_pv_text;
               for($i=0;$i<strlen($click['pv']['3']);$i++){ $output .= "<img src='".CONFIG_URL."images/js_picture/default/".$click['pv']['3']{$i}.".gif' border='0'>"; }
           }
           if($CONFIGUSER['online_if'] == "y"){
               $output .= $online_text;
               for($i=0;$i<strlen($online);$i++){ $output .= "<img src='".CONFIG_URL."images/js_picture/default/".$online{$i}.".gif' border='0'>"; }
           }
           $output .= "</span></a>";
           echo  "document.write(\"".$output."\");";
       break;
       // Style = icon
       case "js_icon":
           $total_ip_text   = str_decode_title($CONFIGUSER['total_ip_text']);
           $total_pv_text   = str_decode_title($CONFIGUSER['total_pv_text']);
           $year_ip_text    = str_decode_title($CONFIGUSER['year_ip_text']);
           $year_pv_text    = str_decode_title($CONFIGUSER['year_pv_text']);
           $month_ip_text   = str_decode_title($CONFIGUSER['month_ip_text']);
           $month_pv_text   = str_decode_title($CONFIGUSER['month_pv_text']);
           $day_ip_text     = str_decode_title($CONFIGUSER['day_ip_text']);
           $day_pv_text     = str_decode_title($CONFIGUSER['day_pv_text']);
           $online_text     = str_decode_title($CONFIGUSER['online_text']);

           $output = "";
           $output .= "<a href='".CONFIG_URL."login.php?user=".$user."' target='_blank'><img src='".CONFIG_URL."images/js_icon/".$CONFIGUSER['js_icon_style']."' border='0' title='";
           if($CONFIGUSER['total_ip_if'] == "y"){ $output .= $total_ip_text.$click['ip']['0']; }
           if($CONFIGUSER['total_pv_if'] == "y"){ $output .= $total_pv_text.$click['pv']['0']; }
           if($CONFIGUSER['year_ip_if']  == "y"){ $output .= $year_ip_text .$click['ip']['1']; }
           if($CONFIGUSER['year_pv_if']  == "y"){ $output .= $year_pv_text .$click['pv']['1']; }
           if($CONFIGUSER['month_ip_if'] == "y"){ $output .= $month_ip_text.$click['ip']['2']; }
           if($CONFIGUSER['month_pv_if'] == "y"){ $output .= $month_pv_text.$click['pv']['2']; }
           if($CONFIGUSER['day_ip_if']   == "y"){ $output .= $day_ip_text  .$click['ip']['3']; }
           if($CONFIGUSER['day_pv_if']   == "y"){ $output .= $day_pv_text  .$click['pv']['3']; }
           if($CONFIGUSER['online_if']   == "y"){ $output .= $online_text  .$online; }
           $output .= "'></a>";
           echo "document.write(\"".$output."\");";
       break;
       // Style = hidden
       case "js_hidden":
           # Hidden all thing here
       break;
       // Style = error
       default:
           echo "document.write(\"".$LANGUAGE['js_nostyle']."\");";
       break;
   }

// Mode = image
}elseif($CONFIGUSER['mode'] == "image"){

   $_GET['snowstats_referrer'] = "Unknown";

   // First write
   include 'write.php';

   // Then read and put out
   switch ($CONFIGUSER['image_style']){
       // Style = custom
       case "image_custom":
           $total_ip_text   = str_decode($CONFIGUSER['total_ip_text']);
           $total_pv_text   = str_decode($CONFIGUSER['total_pv_text']);
           $year_ip_text    = str_decode($CONFIGUSER['year_ip_text']);
           $year_pv_text    = str_decode($CONFIGUSER['year_pv_text']);
           $month_ip_text   = str_decode($CONFIGUSER['month_ip_text']);
           $month_pv_text   = str_decode($CONFIGUSER['month_pv_text']);
           $day_ip_text     = str_decode($CONFIGUSER['day_ip_text']);
           $day_pv_text     = str_decode($CONFIGUSER['day_pv_text']);
           $online_text     = str_decode($CONFIGUSER['online_text']);
        
           $output = "";
           if($CONFIGUSER['total_ip_if'] == "y"){ $output .= $total_ip_text.$click['ip']['0']; }
           if($CONFIGUSER['total_pv_if'] == "y"){ $output .= $total_pv_text.$click['pv']['0']; }
           if($CONFIGUSER['year_ip_if']  == "y"){ $output .= $year_ip_text .$click['ip']['1']; }
           if($CONFIGUSER['year_pv_if']  == "y"){ $output .= $year_pv_text .$click['pv']['1']; }
           if($CONFIGUSER['month_ip_if'] == "y"){ $output .= $month_ip_text.$click['ip']['2']; }
           if($CONFIGUSER['month_pv_if'] == "y"){ $output .= $month_pv_text.$click['pv']['2']; }
           if($CONFIGUSER['day_ip_if']   == "y"){ $output .= $day_ip_text  .$click['ip']['3']; }
           if($CONFIGUSER['day_pv_if']   == "y"){ $output .= $day_pv_text  .$click['pv']['3']; }
           if($CONFIGUSER['online_if']   == "y"){ $output .= $online_text  .$online; }
          
           $background  = $CONFIGUSER['image_custom_background'];// The background image
           $font        = $CONFIGUSER['image_custom_font'];// The font of text
           $color       = color_hexdec($CONFIGUSER['image_custom_color']);// The color of text
           $size        = (int)$CONFIGUSER['image_custom_size'];// Font size
           $top         = (int)$CONFIGUSER['image_custom_top'];// Interval top of text
           $left        = (int)$CONFIGUSER['image_custom_left'];// Interval left of text
           $rowspacing  = (int)$CONFIGUSER['image_custom_rowspacing'];// Interval row spacing of text
           $width       = (int)$CONFIGUSER['image_custom_width'];// The background width
           $height      = (int)$CONFIGUSER['image_custom_height'];// The background height
        
           $extend_name = substr($background,-3);
           
           if($extend_name == "png"){
               $str_header = "Content-type: image/png";
               $str_output = "imagepng";
           }elseif($extend_name == "jpg"){
               $str_header = "Content-type: image/jpeg";
               $str_output = "imagejpeg";
           }elseif($extend_name == "gif"){
               $str_header = "Content-type: image/gif";
               $str_output = "imagegif";
           }elseif($extend_name == "bmp"){
               $str_header = "Content-type: image/vnd.wap.wbmp";
               $str_output = "imagewbmp";
           }

           header($str_header);
           $img         = resize_image("images/image_custom/".$background,$width,$height);
           $fontcolor   = imagecolorallocate($img,$color['0'],$color['1'],$color['2']);

           if($rowspacing != "" && $rowspacing != 0){
               $output = explode("\n",$output);
               if(preg_match("/^[12345]{1,1}$/",$font)){
                   for($i=0;$i<count($output);$i++){
                       imagestring($img, $font, $left, $top+($rowspacing*$i), $output[$i], $fontcolor);
                   }
               }elseif(file_exists($SETTING['dir_fonts'].$font)){
                   for($i=0;$i<count($output);$i++){
                       imagettftext($img, $size, 0, $left, $size+$top+($rowspacing*$i), $fontcolor, $SETTING['dir_fonts'].$font, $output[$i]);
                   }
               }else{
                   for($i=0;$i<count($output);$i++){
                       imagestring($img, 2, $left, $top+($rowspacing*$i), $output[$i], $fontcolor);
                   }
               }
           }else{
               if(preg_match("/^[12345]{1,1}$/",$font)){
                   imagestring($img, $font, $left, $top, $output, $fontcolor);
               }elseif(file_exists($SETTING['dir_fonts'].$font)){
                   imagettftext($img, $size, 0, $left, $size+$top, $fontcolor, $SETTING['dir_fonts'].$font, $output);
               }else{
                   imagestring($img, 2, $left, $top, $output, $fontcolor);
               }
           }
           $str_output($img);
           //echo "document.write(\"<script>alert(document.cookie);</script>\");";
           imagedestroy($img);
       break;
       // Style = hidden
       case "image_hidden":
           # Hidden all thing here
       break;
       // Style = error
       default:
           $output    = "No style found!";;

           header("Content-type: image/png");           
           $values    = array(0 => 1, 1 => 1, 2 => 98, 3 => 1 , 4 => 98, 5 => 16, 6 => 1, 7 => 16,);
           $img       = imagecreate(100, 18);
           $border    = imagecolorallocate($img, 0, 34, 128);
           $fontcolor = imagecolorallocate($img, 0, 34, 128);
           $bg        = imagecolorallocate($img, 235, 233, 237);
           imagefilledpolygon($img, $values, 4, $bg );
           imagestring($img, 2, 6, 2, $output, $fontcolor);
           imagepng($img);
           imagedestroy($img);
       break;
   }

}else{
   echo "document.write(\"".$LANGUAGE['error']."\");";
}
?>
